/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.src;

import brut.androlib.AndrolibException;
import brut.androlib.src.TypeName;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.jf.baksmali.baksmali;
import org.jf.baksmali.baksmaliOptions;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.analysis.InlineMethodResolver;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedOdexFile;
import org.jf.dexlib2.iface.DexFile;

public class SmaliDecoder {
    private final File mApkFile;
    private final Path mOutDir;
    private final boolean mDebug;
    private final String mDebugLinePrefix;
    private final boolean mBakDeb;
    private final int mApi;

    public static void decode(File apkFile, File outDir, boolean debug, String debugLinePrefix, boolean bakdeb, int api) throws AndrolibException {
        new SmaliDecoder(apkFile, outDir, debug, debugLinePrefix, bakdeb, api).decode();
    }

    private SmaliDecoder(File apkFile, File outDir, boolean debug, String debugLinePrefix, boolean bakdeb, int api) {
        this.mApkFile = apkFile;
        this.mOutDir = outDir.toPath();
        this.mDebug = debug;
        this.mDebugLinePrefix = debugLinePrefix;
        this.mBakDeb = bakdeb;
        this.mApi = api;
    }

    private void decode() throws AndrolibException {
        try {
            DexBackedDexFile dexFile;
            ClassPath.dontLoadClassPath = this.mDebug;
            baksmaliOptions options = new baksmaliOptions();
            options.deodex = false;
            options.outputDirectory = this.mOutDir.toAbsolutePath().toString();
            options.noParameterRegisters = false;
            options.useLocalsDirective = true;
            options.useSequentialLabels = true;
            options.outputDebugInfo = this.mBakDeb;
            options.addCodeOffsets = false;
            options.jobs = -1;
            options.noAccessorComments = false;
            options.registerInfo = this.mDebug ? 128 : 0;
            options.ignoreErrors = false;
            options.inlineResolver = null;
            options.checkPackagePrivateAccess = false;
            if (options.jobs <= 0) {
                if (this.mDebug) {
                    options.jobs = 1;
                } else {
                    options.jobs = Runtime.getRuntime().availableProcessors();
                    if (options.jobs > 6) {
                        options.jobs = 6;
                    }
                }
            }
            if ((dexFile = DexFileFactory.loadDexFile((File)this.mApkFile, (int)this.mApi)).isOdexFile()) {
                throw new AndrolibException("Warning: You are disassembling an odex file without deodexing it.");
            }
            if (dexFile instanceof DexBackedOdexFile) {
                options.inlineResolver = InlineMethodResolver.createInlineMethodResolver((int)((DexBackedOdexFile)dexFile).getOdexVersion());
            }
            baksmali.disassembleDexFile((DexFile)dexFile, (boolean)false, (baksmaliOptions)options);
            if (this.mDebug) {
                Files.walkFileTree(this.mOutDir, new SmaliFileVisitor());
            }
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    private class SmaliFileVisitor
    extends SimpleFileVisitor<Path> {
        private SmaliFileVisitor() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            block16: {
                String fileName = file.getFileName().toString();
                if (!fileName.endsWith(".smali")) {
                    return FileVisitResult.CONTINUE;
                }
                fileName = fileName.substring(0, fileName.length() - 6);
                Throwable throwable = null;
                Object var5_6 = null;
                try {
                    BufferedReader in = Files.newBufferedReader(file, Charset.defaultCharset());
                    try {
                        try (BufferedWriter out = Files.newBufferedWriter(file.resolveSibling(String.valueOf(fileName) + ".java"), Charset.defaultCharset(), new OpenOption[0]);){
                            TypeName type = TypeName.fromPath(SmaliDecoder.this.mOutDir.relativize(file.resolveSibling(fileName)));
                            out.write("package " + type.package_ + "; class " + type.getName(true, true) + " { void a() { int a;");
                            out.newLine();
                            String debugLinePrefix = SmaliDecoder.this.mDebugLinePrefix;
                            while (true) {
                                String line;
                                if ((line = in.readLine()) == null) {
                                    out.write("}}");
                                    out.newLine();
                                    break;
                                }
                                out.write(debugLinePrefix);
                                out.write(line);
                                out.newLine();
                            }
                        }
                        if (in == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (in == null) throw throwable;
                        in.close();
                        throw throwable;
                    }
                    in.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }
    }
}

