/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2;

import brut.directory.ZipExtFile;
import com.google.common.io.ByteStreams;
import com.sv.view.AwtFrame;
import com.sv.view.TreeNode;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedOdexFile;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.writer.pool.DexPool;
import org.jf.util.ExceptionWithContext;

public final class DexFileFactory {
    @Nonnull
    public static DexBackedDexFile loadDexFile(String path, int api) throws IOException {
        return DexFileFactory.loadDexFile(new File(path), new Opcodes(api));
    }

    @Nonnull
    public static DexBackedDexFile loadDexFile(File dexFile, int api) throws IOException {
        return DexFileFactory.loadDexFile(dexFile, new Opcodes(api));
    }

    @Nonnull
    public static DexBackedDexFile loadDexFile(File dexFile, @Nonnull Opcodes opcodes) throws IOException {
        ZipExtFile zipFile = null;
        boolean isZipFile = false;
        try {
            zipFile = new ZipExtFile(dexFile);
            isZipFile = true;
            ZipArchiveEntry zipEntry = zipFile.getEntry("classes.dex");
            if (zipEntry == null) {
                throw new NoClassesDexException("zip file %s does not contain a classes.dex file", dexFile.getName());
            }
            long fileLength = zipEntry.getSize();
            if (fileLength < 40L) {
                throw new ExceptionWithContext("The classes.dex file in %s is too small to be a valid dex file", new Object[]{dexFile.getName()});
            }
            if (fileLength > Integer.MAX_VALUE) {
                throw new ExceptionWithContext("The classes.dex file in %s is too large to read in", new Object[]{dexFile.getName()});
            }
            byte[] dexBytes = new byte[(int)fileLength];
            ByteStreams.readFully((InputStream)zipFile.getInputStream(zipEntry), (byte[])dexBytes);
            DexBackedDexFile dexBackedDexFile = new DexBackedDexFile(opcodes, dexBytes);
            return dexBackedDexFile;
        }
        catch (IOException ex) {
            DexFileFactory.expandTree(AwtFrame.classtree.getJtree(), false);
            Toolkit t = Toolkit.getDefaultToolkit();
            t.beep();
            if (isZipFile) {
                throw ex;
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(dexFile));
        try {
            return DexBackedDexFile.fromInputStream(opcodes, inputStream);
        }
        catch (DexBackedDexFile.NotADexFile ex) {
            DexFileFactory.expandTree(AwtFrame.classtree.getJtree(), false);
            try {
                return DexBackedOdexFile.fromInputStream(opcodes, inputStream);
            }
            catch (DexBackedOdexFile.NotAnOdexFile ex2) {
                AwtFrame.WriteLog((String)(String.valueOf(dexFile.getPath()) + " is not an apk, dex file or odex file."));
                AwtFrame.initTabconfig();
                AwtFrame.classtree.change();
                AwtFrame.clearup();
                AwtFrame.autoTab();
                DexFileFactory.expandTree(AwtFrame.classtree.getJtree(), false);
                Toolkit t = Toolkit.getDefaultToolkit();
                t.beep();
                throw new ExceptionWithContext("%s is not an apk, dex file or odex file.", new Object[]{dexFile.getPath()});
            }
        }
    }

    public static void expandTree(JTree tree, boolean bo) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        DexFileFactory.expandAll(tree, new TreePath(root), bo);
    }

    private static void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = (TreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                DexFileFactory.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static void writeDexFile(String path, DexFile dexFile) throws IOException {
        DexPool.writeTo(path, dexFile);
    }

    private DexFileFactory() {
    }

    public static class NoClassesDexException
    extends ExceptionWithContext {
        public NoClassesDexException(Throwable cause) {
            super(cause);
        }

        public NoClassesDexException(Throwable cause, String message, Object ... formatArgs) {
            super(cause, message, formatArgs);
        }

        public NoClassesDexException(String message, Object ... formatArgs) {
            super(message, formatArgs);
        }
    }
}

