/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.analysis.ArrayProto;
import org.jf.dexlib2.analysis.ClassProto;
import org.jf.dexlib2.analysis.PrimitiveProto;
import org.jf.dexlib2.analysis.TypeProto;
import org.jf.dexlib2.analysis.UnknownClassProto;
import org.jf.dexlib2.analysis.UnresolvedClassException;
import org.jf.dexlib2.analysis.reflection.ReflectionClassDef;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.immutable.ImmutableDexFile;
import org.jf.util.ExceptionWithContext;

public class ClassPath {
    public static boolean dontLoadClassPath = false;
    @Nonnull
    private final TypeProto unknownClass;
    @Nonnull
    private HashMap<String, ClassDef> availableClasses = Maps.newHashMap();
    private int api;
    private final CacheLoader<String, TypeProto> classLoader = new CacheLoader<String, TypeProto>(){

        public TypeProto load(String type) throws Exception {
            if (type.charAt(0) == '[') {
                return new ArrayProto(ClassPath.this, type);
            }
            return new ClassProto(ClassPath.this, type);
        }
    };
    @Nonnull
    private LoadingCache<String, TypeProto> loadedClasses = CacheBuilder.newBuilder().build(this.classLoader);
    private static final Pattern dalvikCacheOdexPattern = Pattern.compile("@([^@]+)@classes.dex$");

    public ClassPath(DexFile ... classPath) throws IOException {
        this(Lists.newArrayList((Object[])classPath), 15);
    }

    public ClassPath(@Nonnull Iterable<DexFile> classPath, int api) {
        Iterable dexFiles = Iterables.concat(classPath, (Iterable)Lists.newArrayList((Object[])new DexFile[]{ClassPath.getBasicClasses()}));
        this.unknownClass = new UnknownClassProto(this);
        this.loadedClasses.put((Object)this.unknownClass.getType(), (Object)this.unknownClass);
        this.api = api;
        this.loadPrimitiveType("Z");
        this.loadPrimitiveType("B");
        this.loadPrimitiveType("S");
        this.loadPrimitiveType("C");
        this.loadPrimitiveType("I");
        this.loadPrimitiveType("J");
        this.loadPrimitiveType("F");
        this.loadPrimitiveType("D");
        this.loadPrimitiveType("L");
        for (DexFile dexFile : dexFiles) {
            for (ClassDef classDef : dexFile.getClasses()) {
                ClassDef prev = this.availableClasses.get(classDef.getType());
                if (prev != null) continue;
                this.availableClasses.put(classDef.getType(), classDef);
            }
        }
    }

    private void loadPrimitiveType(String type) {
        this.loadedClasses.put((Object)type, (Object)new PrimitiveProto(this, type));
    }

    private static DexFile getBasicClasses() {
        return new ImmutableDexFile((Collection<? extends ClassDef>)ImmutableSet.of((Object)new ReflectionClassDef(Class.class), (Object)new ReflectionClassDef(Cloneable.class), (Object)new ReflectionClassDef(Object.class), (Object)new ReflectionClassDef(Serializable.class), (Object)new ReflectionClassDef(String.class), (Object)new ReflectionClassDef(Throwable.class), (Object[])new ReflectionClassDef[0]));
    }

    @Nonnull
    public TypeProto getClass(CharSequence type) {
        return (TypeProto)this.loadedClasses.getUnchecked((Object)type.toString());
    }

    @Nonnull
    public ClassDef getClassDef(String type) {
        if (dontLoadClassPath) {
            throw new UnresolvedClassException("Could not resolve class %s", type);
        }
        ClassDef ret = this.availableClasses.get(type);
        if (ret == null) {
            throw new UnresolvedClassException("Could not resolve class %s", type);
        }
        return ret;
    }

    @Nonnull
    public TypeProto getUnknownClass() {
        return this.unknownClass;
    }

    public int getApi() {
        return this.api;
    }

    @Nonnull
    public static ClassPath fromClassPath(Iterable<String> classPathDirs, Iterable<String> classPath, DexFile dexFile, int api) {
        ArrayList dexFiles = Lists.newArrayList();
        for (String classPathEntry : classPath) {
            dexFiles.add(ClassPath.loadClassPathEntry(classPathDirs, classPathEntry, api));
        }
        dexFiles.add(dexFile);
        return new ClassPath(dexFiles, api);
    }

    @Nonnull
    private static DexFile loadClassPathEntry(@Nonnull Iterable<String> classPathDirs, @Nonnull String bootClassPathEntry, int api) {
        int extIndex;
        File rawEntry = new File(bootClassPathEntry);
        String entryName = rawEntry.getName();
        if (entryName.endsWith("@classes.dex")) {
            Matcher m = dalvikCacheOdexPattern.matcher(entryName);
            if (!m.find()) {
                throw new ExceptionWithContext(String.format("Cannot parse dependency value %s", bootClassPathEntry), new Object[0]);
            }
            entryName = m.group(1);
        }
        String baseEntryName = (extIndex = entryName.lastIndexOf(".")) == -1 ? entryName : entryName.substring(0, extIndex);
        for (String classPathDir : classPathDirs) {
            String[] stringArray = new String[]{"", ".odex", ".jar", ".apk", ".zip"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                File file = new File(classPathDir, String.valueOf(baseEntryName) + ext);
                if (file.exists() && file.isFile()) {
                    if (!file.canRead()) {
                        System.err.println(String.format("warning: cannot open %s for reading. Will continue looking.", file.getPath()));
                    } else {
                        try {
                            return DexFileFactory.loadDexFile(file, api);
                        }
                        catch (DexFileFactory.NoClassesDexException noClassesDexException) {
                        }
                        catch (Exception ex) {
                            throw ExceptionWithContext.withContext((Throwable)ex, (String)"Error while reading boot class path entry \"%s\"", (Object[])new Object[]{bootClassPathEntry});
                        }
                    }
                }
                ++n2;
            }
        }
        throw new ExceptionWithContext("Cannot locate boot class path file %s", new Object[]{bootClassPathEntry});
    }
}

