/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.analysis.ClassProto;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Method;
import org.jf.util.ConsoleUtil;

public class DumpVtables {
    public static Options options = new Options();

    static {
        DumpVtables.buildOptions();
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        PosixParser parser = new PosixParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException ex) {
            DumpVtables.usage();
            return;
        }
        String[] remainingArgs = commandLine.getArgs();
        Option[] parsedOptions = commandLine.getOptions();
        ArrayList bootClassPathDirs = Lists.newArrayList();
        String outFile = "vtables.txt";
        int apiLevel = 15;
        int i = 0;
        while (i < parsedOptions.length) {
            Option option = parsedOptions[i];
            String opt = option.getOpt();
            switch (opt.charAt(0)) {
                case 'd': {
                    bootClassPathDirs.add(option.getValue());
                    break;
                }
                case 'o': {
                    outFile = option.getValue();
                    break;
                }
                case 'a': {
                    apiLevel = Integer.parseInt(commandLine.getOptionValue("a"));
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            ++i;
        }
        if (remainingArgs.length != 1) {
            DumpVtables.usage();
            return;
        }
        String inputDexFileName = remainingArgs[0];
        File dexFileFile = new File(inputDexFileName);
        if (!dexFileFile.exists()) {
            System.err.println("Can't find the file " + inputDexFileName);
            System.exit(1);
        }
        try {
            DexBackedDexFile dexFile = DexFileFactory.loadDexFile(dexFileFile, apiLevel);
            Iterable bootClassPaths = Splitter.on((String)":").split((CharSequence)"core.jar:ext.jar:framework.jar:android.policy.jar:services.jar");
            ClassPath classPath = ClassPath.fromClassPath(bootClassPathDirs, bootClassPaths, dexFile, apiLevel);
            FileOutputStream outStream = new FileOutputStream(outFile);
            for (ClassDef classDef : dexFile.getClasses()) {
                ClassProto classProto = (ClassProto)classPath.getClass(classDef);
                List<Method> methods = classProto.getVtable();
                String className = "Class " + classDef.getType() + " extends " + classDef.getSuperclass() + " : " + methods.size() + " methods\n";
                outStream.write(className.getBytes());
                int i2 = 0;
                while (i2 < methods.size()) {
                    Method method = methods.get(i2);
                    String methodString = String.valueOf(i2) + ":" + method.getDefiningClass() + "->" + method.getName() + "(";
                    for (CharSequence charSequence : method.getParameterTypes()) {
                        methodString = String.valueOf(methodString) + charSequence;
                    }
                    methodString = String.valueOf(methodString) + ")" + method.getReturnType() + "\n";
                    outStream.write(methodString.getBytes());
                    ++i2;
                }
                outStream.write("\n".getBytes());
            }
            outStream.close();
        }
        catch (IOException ex) {
            System.out.println("IOException thrown when trying to open a dex file or write out vtables: " + ex);
        }
    }

    private static void usage() {
        int consoleWidth = ConsoleUtil.getConsoleWidth();
        if (consoleWidth <= 0) {
            consoleWidth = 80;
        }
        System.out.println("java -cp baksmali.jar org.jf.dexlib2.analysis.DumpVtables -d path/to/framework/jar/files <dex-file>");
    }

    private static void buildOptions() {
        OptionBuilder.withLongOpt((String)"bootclasspath-dir");
        OptionBuilder.withDescription((String)"the base folder to look for the bootclasspath files in. Defaults to the current directory");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"DIR");
        Option classPathDirOption = OptionBuilder.create((String)"d");
        OptionBuilder.withLongOpt((String)"out-file");
        OptionBuilder.withDescription((String)"output file");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        Option outputFileOption = OptionBuilder.create((String)"o");
        OptionBuilder.withLongOpt((String)"api-level");
        OptionBuilder.withDescription((String)"The numeric api-level of the file being disassembled. If not specified, it defaults to 15 (ICS).");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"API_LEVEL");
        Option apiLevelOption = OptionBuilder.create((String)"a");
        options.addOption(classPathDirOption);
        options.addOption(outputFileOption);
        options.addOption(apiLevelOption);
    }
}

