/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis.reflection;

import com.google.common.collect.ImmutableSet;
import java.util.AbstractList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.analysis.reflection.util.ReflectionUtils;
import org.jf.dexlib2.base.BaseMethodParameter;
import org.jf.dexlib2.base.reference.BaseMethodReference;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.MethodParameter;

public class ReflectionMethod
extends BaseMethodReference
implements Method {
    private final java.lang.reflect.Method method;

    public ReflectionMethod(java.lang.reflect.Method method) {
        this.method = method;
    }

    @Override
    @Nonnull
    public List<? extends MethodParameter> getParameters() {
        java.lang.reflect.Method method = this.method;
        return new AbstractList<MethodParameter>(method){
            private final Class[] parameters;
            {
                this.parameters = method.getParameterTypes();
            }

            @Override
            public MethodParameter get(final int index) {
                return new BaseMethodParameter(){

                    @Override
                    @Nonnull
                    public Set<? extends Annotation> getAnnotations() {
                        return ImmutableSet.of();
                    }

                    @Override
                    @Nullable
                    public String getName() {
                        return null;
                    }

                    @Override
                    @Nonnull
                    public String getType() {
                        return ReflectionUtils.javaToDexName(parameters[index].getName());
                    }
                };
            }

            @Override
            public int size() {
                return this.parameters.length;
            }
        };
    }

    @Override
    public int getAccessFlags() {
        return this.method.getModifiers();
    }

    @Override
    @Nonnull
    public Set<? extends Annotation> getAnnotations() {
        return ImmutableSet.of();
    }

    @Override
    @Nullable
    public MethodImplementation getImplementation() {
        return null;
    }

    @Override
    @Nonnull
    public String getDefiningClass() {
        return ReflectionUtils.javaToDexName(this.method.getDeclaringClass().getName());
    }

    @Override
    @Nonnull
    public String getName() {
        return this.method.getName();
    }

    @Nonnull
    public List<String> getParameterTypes() {
        return new AbstractList<String>(){
            private final List<? extends MethodParameter> parameters;
            {
                this.parameters = ReflectionMethod.this.getParameters();
            }

            @Override
            public String get(int index) {
                return this.parameters.get(index).getType();
            }

            @Override
            public int size() {
                return this.parameters.size();
            }
        };
    }

    @Override
    @Nonnull
    public String getReturnType() {
        return ReflectionUtils.javaToDexName(this.method.getReturnType().getName());
    }
}

