/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.builder;

import com.google.common.collect.Lists;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.builder.BuilderDebugItem;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.Label;
import org.jf.dexlib2.builder.debug.BuilderEndLocal;
import org.jf.dexlib2.builder.debug.BuilderEpilogueBegin;
import org.jf.dexlib2.builder.debug.BuilderLineNumber;
import org.jf.dexlib2.builder.debug.BuilderPrologueEnd;
import org.jf.dexlib2.builder.debug.BuilderRestartLocal;
import org.jf.dexlib2.builder.debug.BuilderSetSourceFile;
import org.jf.dexlib2.builder.debug.BuilderStartLocal;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.writer.builder.BuilderStringReference;

public class MethodLocation {
    @Nullable
    BuilderInstruction instruction;
    int codeAddress;
    int index;
    private List<Label> labels = Lists.newArrayList();
    List<BuilderDebugItem> debugItems = Lists.newArrayList();

    MethodLocation(@Nullable BuilderInstruction instruction, int codeAddress, int index) {
        this.instruction = instruction;
        this.codeAddress = codeAddress;
        this.index = index;
    }

    @Nullable
    public Instruction getInstruction() {
        return this.instruction;
    }

    public int getCodeAddress() {
        return this.codeAddress;
    }

    public int getIndex() {
        return this.index;
    }

    void mergeInto(@Nonnull MethodLocation other) {
        for (Label label : this.labels) {
            label.location = other;
            other.labels.add(label);
        }
        for (BuilderDebugItem debugItem : this.debugItems) {
            debugItem.location = other;
        }
        this.debugItems.addAll(other.debugItems);
        other.debugItems = this.debugItems;
    }

    @Nonnull
    public Set<Label> getLabels() {
        return new AbstractSet<Label>(){

            @Override
            @Nonnull
            public Iterator<Label> iterator() {
                final Iterator it = MethodLocation.this.labels.iterator();
                return new Iterator<Label>(){
                    @Nullable
                    private Label currentLabel = null;

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Label next() {
                        this.currentLabel = (Label)it.next();
                        return this.currentLabel;
                    }

                    @Override
                    public void remove() {
                        if (this.currentLabel != null) {
                            this.currentLabel.location = null;
                        }
                        it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return MethodLocation.this.labels.size();
            }

            @Override
            public boolean add(@Nonnull Label label) {
                if (label.isPlaced()) {
                    throw new IllegalArgumentException("Cannot add a label that is already placed. You must remove it from its current location first.");
                }
                label.location = MethodLocation.this;
                MethodLocation.this.labels.add(label);
                return true;
            }
        };
    }

    @Nonnull
    public Label addNewLabel() {
        Label label = new Label(this);
        this.labels.add(label);
        return label;
    }

    @Nonnull
    public Set<BuilderDebugItem> getDebugItems() {
        return new AbstractSet<BuilderDebugItem>(){

            @Override
            @Nonnull
            public Iterator<BuilderDebugItem> iterator() {
                final Iterator<BuilderDebugItem> it = MethodLocation.this.debugItems.iterator();
                return new Iterator<BuilderDebugItem>(){
                    @Nullable
                    private BuilderDebugItem currentDebugItem = null;

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public BuilderDebugItem next() {
                        this.currentDebugItem = (BuilderDebugItem)it.next();
                        return this.currentDebugItem;
                    }

                    @Override
                    public void remove() {
                        if (this.currentDebugItem != null) {
                            this.currentDebugItem.location = null;
                        }
                        it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return MethodLocation.this.labels.size();
            }

            @Override
            public boolean add(@Nonnull BuilderDebugItem debugItem) {
                if (debugItem.location != null) {
                    throw new IllegalArgumentException("Cannot add a debug item that has already been added to a method. You must remove it from its current location first.");
                }
                debugItem.location = MethodLocation.this;
                MethodLocation.this.debugItems.add(debugItem);
                return true;
            }
        };
    }

    public void addLineNumber(int lineNumber) {
        this.getDebugItems().add(new BuilderLineNumber(lineNumber));
    }

    public void addStartLocal(int registerNumber, @Nullable StringReference name, @Nullable TypeReference type, @Nullable StringReference signature) {
        this.getDebugItems().add(new BuilderStartLocal(registerNumber, name, type, signature));
    }

    public void addEndLocal(int registerNumber) {
        this.getDebugItems().add(new BuilderEndLocal(registerNumber));
    }

    public void addRestartLocal(int registerNumber) {
        this.getDebugItems().add(new BuilderRestartLocal(registerNumber));
    }

    public void addPrologue() {
        this.getDebugItems().add(new BuilderPrologueEnd());
    }

    public void addEpilogue() {
        this.getDebugItems().add(new BuilderEpilogueBegin());
    }

    public void addSetSourceFile(@Nullable BuilderStringReference sourceFile) {
        this.getDebugItems().add(new BuilderSetSourceFile(sourceFile));
    }
}

