/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.dexbacked.BaseDexBuffer;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.RawDexFile;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;
import org.jf.util.StringUtils;

public class HeaderItem {
    public static final int ITEM_SIZE = 112;
    public static final byte[][] MAGIC_VALUES;
    public static final int LITTLE_ENDIAN_TAG = 305419896;
    public static final int BIG_ENDIAN_TAG = 2018915346;
    public static final int CHECKSUM_OFFSET = 8;
    public static final int SIGNATURE_OFFSET = 12;
    public static final int SIGNATURE_SIZE = 20;
    public static final int HEADER_SIZE_OFFSET = 36;
    public static final int ENDIAN_TAG_OFFSET = 40;
    public static final int MAP_OFFSET = 52;
    public static final int STRING_COUNT_OFFSET = 56;
    public static final int STRING_START_OFFSET = 60;
    public static final int TYPE_COUNT_OFFSET = 64;
    public static final int TYPE_START_OFFSET = 68;
    public static final int PROTO_COUNT_OFFSET = 72;
    public static final int PROTO_START_OFFSET = 76;
    public static final int FIELD_COUNT_OFFSET = 80;
    public static final int FIELD_START_OFFSET = 84;
    public static final int METHOD_COUNT_OFFSET = 88;
    public static final int METHOD_START_OFFSET = 92;
    public static final int CLASS_COUNT_OFFSET = 96;
    public static final int CLASS_START_OFFSET = 100;
    @Nonnull
    private RawDexFile dexFile;

    static {
        byte[][] byArrayArray = new byte[2][];
        byte[] byArray = new byte[8];
        byArray[0] = 100;
        byArray[1] = 101;
        byArray[2] = 120;
        byArray[3] = 10;
        byArray[4] = 48;
        byArray[5] = 51;
        byArray[6] = 53;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[0] = 100;
        byArray2[1] = 101;
        byArray2[2] = 120;
        byArray2[3] = 10;
        byArray2[4] = 48;
        byArray2[5] = 51;
        byArray2[6] = 54;
        byArrayArray[1] = byArray2;
        MAGIC_VALUES = byArrayArray;
    }

    public HeaderItem(@Nonnull RawDexFile dexFile) {
        this.dexFile = dexFile;
    }

    public int getChecksum() {
        return this.dexFile.readSmallUint(8);
    }

    @Nonnull
    public byte[] getSignature() {
        return this.dexFile.readByteRange(12, 20);
    }

    public int getMapOffset() {
        return this.dexFile.readSmallUint(52);
    }

    public int getHeaderSize() {
        return this.dexFile.readSmallUint(36);
    }

    public int getStringCount() {
        return this.dexFile.readSmallUint(56);
    }

    public int getStringOffset() {
        return this.dexFile.readSmallUint(60);
    }

    public int getTypeCount() {
        return this.dexFile.readSmallUint(64);
    }

    public int getTypeOffset() {
        return this.dexFile.readSmallUint(68);
    }

    public int getProtoCount() {
        return this.dexFile.readSmallUint(72);
    }

    public int getProtoOffset() {
        return this.dexFile.readSmallUint(76);
    }

    public int getFieldCount() {
        return this.dexFile.readSmallUint(80);
    }

    public int getFieldOffset() {
        return this.dexFile.readSmallUint(84);
    }

    public int getMethodCount() {
        return this.dexFile.readSmallUint(88);
    }

    public int getMethodOffset() {
        return this.dexFile.readSmallUint(92);
    }

    public int getClassCount() {
        return this.dexFile.readSmallUint(96);
    }

    public int getClassOffset() {
        return this.dexFile.readSmallUint(100);
    }

    @Nonnull
    public static SectionAnnotator makeAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            @Nonnull
            public String getItemName() {
                return "header_item";
            }

            @Override
            protected void annotateItem(@Nonnull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                int startOffset = out.getCursor();
                StringBuilder magicBuilder = new StringBuilder();
                int i = 0;
                while (i < 8) {
                    magicBuilder.append((char)this.dexFile.readUbyte(startOffset + i));
                    ++i;
                }
                out.annotate(8, "magic: %s", StringUtils.escapeString((String)magicBuilder.toString()));
                out.annotate(4, "checksum", new Object[0]);
                out.annotate(20, "signature", new Object[0]);
                out.annotate(4, "file_size: %d", this.dexFile.readInt(out.getCursor()));
                int headerSize = this.dexFile.readInt(out.getCursor());
                out.annotate(4, "header_size: %d", headerSize);
                int endianTag = this.dexFile.readInt(out.getCursor());
                out.annotate(4, "endian_tag: 0x%x (%s)", endianTag, HeaderItem.getEndianText(endianTag));
                out.annotate(4, "link_size: %d", this.dexFile.readInt(out.getCursor()));
                out.annotate(4, "link_offset: 0x%x", this.dexFile.readInt(out.getCursor()));
                out.annotate(4, "map_off: 0x%x", this.dexFile.readInt(out.getCursor()));
                out.annotate(4, "string_ids_size: %d", this.dexFile.readInt(out.getCursor()));
                out.annotate(4, "string_ids_off: 0x%x", this.dexFile.readInt(out.getCursor()));
                out.annotate(4, "type_ids_size: %d", this.dexFile.readInt(out.getCursor()));
                out.annotate(4, "type_ids_off: 0x%x", this.dexFile.readInt(out.getCursor()));
                out.annotate(4, "proto_ids_size: %d", this.dexFile.readInt(out.getCursor()));
                out.annotate(4, "proto_ids_off: 0x%x", this.dexFile.readInt(out.getCursor()));
                out.annotate(4, "field_ids_size: %d", this.dexFile.readInt(out.getCursor()));
                out.annotate(4, "field_ids_off: 0x%x", this.dexFile.readInt(out.getCursor()));
                out.annotate(4, "method_ids_size: %d", this.dexFile.readInt(out.getCursor()));
                out.annotate(4, "method_ids_off: 0x%x", this.dexFile.readInt(out.getCursor()));
                out.annotate(4, "class_defs_size: %d", this.dexFile.readInt(out.getCursor()));
                out.annotate(4, "class_defs_off: 0x%x", this.dexFile.readInt(out.getCursor()));
                out.annotate(4, "data_size: %d", this.dexFile.readInt(out.getCursor()));
                out.annotate(4, "data_off: 0x%x", this.dexFile.readInt(out.getCursor()));
                if (headerSize > 112) {
                    out.annotateTo(headerSize, "header padding", new Object[0]);
                }
            }
        };
    }

    private static String getEndianText(int endianTag) {
        if (endianTag == 305419896) {
            return "Little Endian";
        }
        if (endianTag == 2018915346) {
            return "Big Endian";
        }
        return "Invalid";
    }

    private static int getVersion(byte[] buf, int offset) {
        if (buf.length - offset < 8) {
            return 0;
        }
        boolean matches = true;
        int i = 0;
        while (i < MAGIC_VALUES.length) {
            byte[] expected = MAGIC_VALUES[i];
            matches = true;
            int j = 0;
            while (j < 8) {
                if (buf[offset + j] != expected[j]) {
                    matches = false;
                    break;
                }
                ++j;
            }
            if (matches) {
                return i == 0 ? 35 : 36;
            }
            ++i;
        }
        return 0;
    }

    public static boolean verifyMagic(byte[] buf, int offset) {
        return HeaderItem.getVersion(buf, offset) != 0;
    }

    public static int getEndian(byte[] buf, int offset) {
        BaseDexBuffer bdb = new BaseDexBuffer(buf);
        return bdb.readInt(offset + 40);
    }
}

