/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.util;

import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nullable;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.util.StringUtils;

public final class ReferenceUtil {
    public static String getShortMethodDescriptor(MethodReference methodReference) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodReference.getName());
        sb.append('(');
        for (CharSequence charSequence : methodReference.getParameterTypes()) {
            sb.append(charSequence);
        }
        sb.append(')');
        sb.append(methodReference.getReturnType());
        return sb.toString();
    }

    public static String getMethodDescriptor(MethodReference methodReference) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodReference.getDefiningClass());
        sb.append("->");
        sb.append(methodReference.getName());
        sb.append('(');
        for (CharSequence charSequence : methodReference.getParameterTypes()) {
            sb.append(charSequence);
        }
        sb.append(')');
        sb.append(methodReference.getReturnType());
        return sb.toString();
    }

    public static void writeMethodDescriptor(Writer writer, MethodReference methodReference) throws IOException {
        writer.write(methodReference.getDefiningClass());
        writer.write("->");
        writer.write(methodReference.getName());
        writer.write(40);
        for (CharSequence charSequence : methodReference.getParameterTypes()) {
            writer.write(charSequence.toString());
        }
        writer.write(41);
        writer.write(methodReference.getReturnType());
    }

    public static String getFieldDescriptor(FieldReference fieldReference) {
        StringBuilder sb = new StringBuilder();
        sb.append(fieldReference.getDefiningClass());
        sb.append("->");
        sb.append(fieldReference.getName());
        sb.append(':');
        sb.append(fieldReference.getType());
        return sb.toString();
    }

    public static String getShortFieldDescriptor(FieldReference fieldReference) {
        StringBuilder sb = new StringBuilder();
        sb.append(fieldReference.getName());
        sb.append(':');
        sb.append(fieldReference.getType());
        return sb.toString();
    }

    public static void writeFieldDescriptor(Writer writer, FieldReference fieldReference) throws IOException {
        writer.write(fieldReference.getDefiningClass());
        writer.write("->");
        writer.write(fieldReference.getName());
        writer.write(58);
        writer.write(fieldReference.getType());
    }

    @Nullable
    public static String getReferenceString(Reference reference) {
        if (reference instanceof StringReference) {
            return String.format("\"%s\"", StringUtils.escapeString((String)((StringReference)reference).getString()));
        }
        if (reference instanceof TypeReference) {
            return ((TypeReference)reference).getType();
        }
        if (reference instanceof FieldReference) {
            return ReferenceUtil.getFieldDescriptor((FieldReference)reference);
        }
        if (reference instanceof MethodReference) {
            return ReferenceUtil.getMethodDescriptor((MethodReference)reference);
        }
        return null;
    }

    private ReferenceUtil() {
    }
}

