/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request.async;

import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.context.request.async.AsyncWebRequest;
import org.springframework.web.context.request.async.StaleAsyncWebRequestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncExecutionChainRunnable
implements Runnable {
    private static final Log logger = LogFactory.getLog(AsyncExecutionChainRunnable.class);
    private final AsyncWebRequest asyncWebRequest;
    private final Callable<?> callable;

    public AsyncExecutionChainRunnable(AsyncWebRequest asyncWebRequest, Callable<?> callable) {
        Assert.notNull((Object)asyncWebRequest, (String)"An AsyncWebRequest is required");
        Assert.notNull(callable, (String)"A Callable is required");
        this.asyncWebRequest = asyncWebRequest;
        this.callable = callable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.callable.call();
        }
        catch (StaleAsyncWebRequestException ex) {
            logger.trace((Object)"Could not complete async request", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.trace((Object)"Could not complete async request", (Throwable)ex);
            this.asyncWebRequest.sendError(HttpStatus.INTERNAL_SERVER_ERROR, ex.getMessage());
        }
        finally {
            logger.debug((Object)"Completing async request processing");
            this.asyncWebRequest.complete();
        }
    }
}

