/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request.async;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.util.Assert;
import org.springframework.web.context.request.async.StaleAsyncWebRequestException;

public final class DeferredResult {
    private static final Object TIMEOUT_RESULT_NONE = new Object();
    private Object result;
    private final Object timeoutResult;
    private DeferredResultHandler resultHandler;
    private final CountDownLatch readySignal = new CountDownLatch(1);
    private final ReentrantLock timeoutLock = new ReentrantLock();

    public DeferredResult() {
        this(TIMEOUT_RESULT_NONE);
    }

    public DeferredResult(Object timeoutResult) {
        this.timeoutResult = timeoutResult;
    }

    boolean canHandleTimeout() {
        return this.timeoutResult != TIMEOUT_RESULT_NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object result) throws StaleAsyncWebRequestException {
        if (this.timeoutLock.tryLock() && this.result != this.timeoutResult) {
            try {
                this.handle(result);
            }
            finally {
                this.timeoutLock.unlock();
            }
        } else {
            throw new StaleAsyncWebRequestException("Async request already timed out");
        }
    }

    public boolean trySet(Object result) throws StaleAsyncWebRequestException {
        try {
            this.set(result);
            return true;
        }
        catch (StaleAsyncWebRequestException staleAsyncWebRequestException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTimeout() {
        Assert.state((boolean)this.canHandleTimeout(), (String)"Can't handle timeout");
        this.timeoutLock.lock();
        try {
            if (this.result == null) {
                this.handle(this.timeoutResult);
            }
        }
        finally {
            this.timeoutLock.unlock();
        }
    }

    private void handle(Object result) throws StaleAsyncWebRequestException {
        Assert.isNull((Object)this.result, (String)"A deferred result can be set once only");
        this.result = result;
        try {
            this.readySignal.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Gave up on waiting for DeferredResult to be initialized. Are you perhaps creating and setting a DeferredResult in the same thread? The DeferredResult must be fully initialized before you can set it. See the class javadoc for more details");
        }
        this.resultHandler.handle(result);
    }

    void init(DeferredResultHandler handler) {
        this.resultHandler = handler;
        this.readySignal.countDown();
    }

    static interface DeferredResultHandler {
        public void handle(Object var1) throws StaleAsyncWebRequestException;
    }
}

