/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request.async;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.async.AsyncWebRequest;

public class StandardServletAsyncWebRequest
extends ServletWebRequest
implements AsyncWebRequest,
AsyncListener {
    private Long timeout;
    private AsyncContext asyncContext;
    private AtomicBoolean asyncCompleted = new AtomicBoolean(false);
    private Runnable timeoutHandler;

    public StandardServletAsyncWebRequest(HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public boolean isAsyncStarted() {
        return this.asyncContext != null && this.getRequest().isAsyncStarted();
    }

    public boolean isAsyncCompleted() {
        return this.asyncCompleted.get();
    }

    public void setTimeoutHandler(Runnable timeoutHandler) {
        this.timeoutHandler = timeoutHandler;
    }

    public void startAsync() {
        Assert.state((boolean)this.getRequest().isAsyncSupported(), (String)"Async support must be enabled on a servlet and for all filters involved in async request processing. This is done in Java code using the Servlet API or by adding \"<async-supported>true</async-supported>\" to servlet and filter declarations in web.xml.");
        this.assertNotStale();
        Assert.state((!this.isAsyncStarted() ? 1 : 0) != 0, (String)"Async processing already started");
        this.asyncContext = this.getRequest().startAsync((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
        this.asyncContext.addListener((AsyncListener)this);
        if (this.timeout != null) {
            this.asyncContext.setTimeout(this.timeout.longValue());
        }
    }

    public void complete() {
        if (!this.isAsyncCompleted()) {
            this.asyncContext.complete();
            this.completeInternal();
        }
    }

    private void completeInternal() {
        this.asyncContext = null;
        this.asyncCompleted.set(true);
    }

    public void sendError(HttpStatus status, String message) {
        try {
            if (!this.isAsyncCompleted()) {
                this.getResponse().sendError(500, message);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void assertNotStale() {
        Assert.state((!this.isAsyncCompleted() ? 1 : 0) != 0, (String)"Cannot use async request after completion");
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        if (this.timeoutHandler == null) {
            this.getResponse().sendError(HttpStatus.SERVICE_UNAVAILABLE.value());
        } else {
            this.timeoutHandler.run();
        }
        this.completeInternal();
    }

    public void onError(AsyncEvent event) throws IOException {
        this.completeInternal();
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
    }

    public void onComplete(AsyncEvent event) throws IOException {
        this.completeInternal();
    }
}

