/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate4;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.orm.hibernate4.SpringSessionContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalSessionFactoryBuilder
extends Configuration {
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private static final TypeFilter[] ENTITY_TYPE_FILTERS = new TypeFilter[]{new AnnotationTypeFilter(Entity.class, false), new AnnotationTypeFilter(Embeddable.class, false), new AnnotationTypeFilter(MappedSuperclass.class, false)};
    private static final Method addAnnotatedClassMethod = ClassUtils.getMethod(Configuration.class, (String)"addAnnotatedClass", (Class[])new Class[]{Class.class});
    private static final Method addPackageMethod = ClassUtils.getMethod(Configuration.class, (String)"addPackage", (Class[])new Class[]{String.class});
    private final ResourcePatternResolver resourcePatternResolver;

    public LocalSessionFactoryBuilder(DataSource dataSource) {
        this(dataSource, (ResourceLoader)new PathMatchingResourcePatternResolver());
    }

    public LocalSessionFactoryBuilder(DataSource dataSource, ClassLoader classLoader) {
        this(dataSource, (ResourceLoader)new PathMatchingResourcePatternResolver(classLoader));
    }

    public LocalSessionFactoryBuilder(DataSource dataSource, ResourceLoader resourceLoader) {
        this.getProperties().put("hibernate.current_session_context_class", SpringSessionContext.class.getName());
        if (dataSource != null) {
            this.getProperties().put("hibernate.connection.datasource", dataSource);
        }
        this.getProperties().put("hibernate.classLoader.application", resourceLoader.getClassLoader());
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
    }

    public LocalSessionFactoryBuilder addAnnotatedClasses(Class<?> ... annotatedClasses) {
        for (Class<?> annotatedClass : annotatedClasses) {
            ReflectionUtils.invokeMethod((Method)addAnnotatedClassMethod, (Object)((Object)this), (Object[])new Object[]{annotatedClass});
        }
        return this;
    }

    public LocalSessionFactoryBuilder addPackages(String ... annotatedPackages) {
        for (String annotatedPackage : annotatedPackages) {
            ReflectionUtils.invokeMethod((Method)addPackageMethod, (Object)((Object)this), (Object[])new Object[]{annotatedPackage});
        }
        return this;
    }

    public LocalSessionFactoryBuilder scanPackages(String ... packagesToScan) throws HibernateException {
        try {
            for (String pkg : packagesToScan) {
                String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + RESOURCE_PATTERN;
                Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                for (Resource resource : resources) {
                    if (!resource.isReadable()) continue;
                    MetadataReader reader = readerFactory.getMetadataReader(resource);
                    String className = reader.getClassMetadata().getClassName();
                    if (!this.matchesFilter(reader, (MetadataReaderFactory)readerFactory)) continue;
                    this.addAnnotatedClasses(this.resourcePatternResolver.getClassLoader().loadClass(className));
                }
            }
            return this;
        }
        catch (IOException ex) {
            throw new MappingException("Failed to scan classpath for unlisted classes", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new MappingException("Failed to load annotated classes from classpath", (Throwable)ex);
        }
    }

    private boolean matchesFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        for (TypeFilter filter : ENTITY_TYPE_FILTERS) {
            if (!filter.match(reader, readerFactory)) continue;
            return true;
        }
        return false;
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        return super.buildSessionFactory();
    }
}

