/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import com.sun.rowset.CachedRowSetImpl;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.rowset.CachedRowSet;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.support.rowset.ResultSetWrappingSqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlRowSetResultSetExtractor
implements ResultSetExtractor<SqlRowSet> {
    private static Object rowSetFactory = null;
    private static Method createCachedRowSet = null;

    @Override
    public SqlRowSet extractData(ResultSet rs) throws SQLException {
        return this.createSqlRowSet(rs);
    }

    protected SqlRowSet createSqlRowSet(ResultSet rs) throws SQLException {
        CachedRowSet rowSet = this.newCachedRowSet();
        rowSet.populate(rs);
        return new ResultSetWrappingSqlRowSet(rowSet);
    }

    protected CachedRowSet newCachedRowSet() throws SQLException {
        if (createCachedRowSet != null) {
            return (CachedRowSet)ReflectionUtils.invokeJdbcMethod((Method)createCachedRowSet, (Object)rowSetFactory);
        }
        return new CachedRowSetImpl();
    }

    static {
        ClassLoader cl = SqlRowSetResultSetExtractor.class.getClassLoader();
        try {
            Class<?> rowSetProviderClass = cl.loadClass("javax.sql.rowset.RowSetProvider");
            Method newFactory = rowSetProviderClass.getMethod("newFactory", new Class[0]);
            rowSetFactory = ReflectionUtils.invokeMethod((Method)newFactory, null);
            createCachedRowSet = rowSetFactory.getClass().getMethod("createCachedRowSet", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

