/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.ExpressionInvocationTargetException;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.FormatHelper;
import org.springframework.expression.spel.ast.SpelNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodReference
extends SpelNodeImpl {
    private final String name;
    private final boolean nullSafe;
    private volatile MethodExecutor cachedExecutor;

    public MethodReference(boolean nullSafe, String methodName, int pos, SpelNodeImpl ... arguments) {
        super(pos, arguments);
        this.name = methodName;
        this.nullSafe = nullSafe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypedValue currentContext = state.getActiveContextObject();
        Object[] arguments = new Object[this.getChildCount()];
        for (int i = 0; i < arguments.length; ++i) {
            try {
                state.pushActiveContextObject(state.getRootContextObject());
                arguments[i] = this.children[i].getValueInternal(state).getValue();
                continue;
            }
            finally {
                state.popActiveContextObject();
            }
        }
        if (currentContext.getValue() == null) {
            if (this.nullSafe) {
                return TypedValue.NULL;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.METHOD_CALL_ON_NULL_OBJECT_NOT_ALLOWED, FormatHelper.formatMethodForMessage(this.name, this.getTypes(arguments)));
        }
        MethodExecutor executorToUse = this.cachedExecutor;
        if (executorToUse != null) {
            try {
                return executorToUse.execute(state.getEvaluationContext(), state.getActiveContextObject().getValue(), arguments);
            }
            catch (AccessException ae) {
                this.throwSimpleExceptionIfPossible(state, ae);
                this.cachedExecutor = null;
            }
        }
        this.cachedExecutor = executorToUse = this.findAccessorForMethod(this.name, this.getTypes(arguments), state);
        try {
            return executorToUse.execute(state.getEvaluationContext(), state.getActiveContextObject().getValue(), arguments);
        }
        catch (AccessException ae) {
            this.throwSimpleExceptionIfPossible(state, ae);
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ae, SpelMessage.EXCEPTION_DURING_METHOD_INVOCATION, this.name, state.getActiveContextObject().getValue().getClass().getName(), ae.getMessage());
        }
    }

    private void throwSimpleExceptionIfPossible(ExpressionState state, AccessException ae) {
        if (ae.getCause() instanceof InvocationTargetException) {
            Throwable rootCause = ae.getCause().getCause();
            if (rootCause instanceof RuntimeException) {
                throw (RuntimeException)rootCause;
            }
            throw new ExpressionInvocationTargetException(this.getStartPosition(), "A problem occurred when trying to execute method '" + this.name + "' on object of type '" + state.getActiveContextObject().getValue().getClass().getName() + "'", rootCause);
        }
    }

    private List<TypeDescriptor> getTypes(Object ... arguments) {
        ArrayList<TypeDescriptor> descriptors = new ArrayList<TypeDescriptor>(arguments.length);
        for (Object argument : arguments) {
            descriptors.add(TypeDescriptor.forObject((Object)argument));
        }
        return descriptors;
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("(");
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getChild(i).toStringAST());
        }
        sb.append(")");
        return sb.toString();
    }

    private MethodExecutor findAccessorForMethod(String name, List<TypeDescriptor> argumentTypes, ExpressionState state) throws SpelEvaluationException {
        TypedValue context = state.getActiveContextObject();
        Object contextObject = context.getValue();
        EvaluationContext eContext = state.getEvaluationContext();
        List<MethodResolver> mResolvers = eContext.getMethodResolvers();
        if (mResolvers != null) {
            for (MethodResolver methodResolver : mResolvers) {
                try {
                    MethodExecutor cEx = methodResolver.resolve(state.getEvaluationContext(), contextObject, name, argumentTypes);
                    if (cEx == null) continue;
                    return cEx;
                }
                catch (AccessException ex) {
                    throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.PROBLEM_LOCATING_METHOD, name, contextObject.getClass());
                }
            }
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.METHOD_NOT_FOUND, FormatHelper.formatMethodForMessage(name, argumentTypes), FormatHelper.formatClassNameForMessage(contextObject instanceof Class ? (Class<?>)contextObject : contextObject.getClass()));
    }
}

