/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache;

import java.io.Serializable;
import javax.cache.Status;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCacheCache
implements Cache {
    private static final Object NULL_HOLDER = new NullHolder();
    private final javax.cache.Cache cache;
    private final boolean allowNullValues;

    public JCacheCache(javax.cache.Cache<?, ?> jcache) {
        this(jcache, true);
    }

    public JCacheCache(javax.cache.Cache<?, ?> jcache, boolean allowNullValues) {
        Assert.notNull(jcache, (String)"Cache must not be null");
        Status status = jcache.getStatus();
        Assert.isTrue((boolean)Status.STARTED.equals((Object)status), (String)("A 'started' cache is required - current cache is " + status.toString()));
        this.cache = jcache;
        this.allowNullValues = allowNullValues;
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    public javax.cache.Cache<?, ?> getNativeCache() {
        return this.cache;
    }

    public boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    @Override
    public Cache.ValueWrapper get(Object key) {
        Object value = this.cache.get(key);
        return value != null ? new SimpleValueWrapper(this.fromStoreValue(value)) : null;
    }

    @Override
    public void put(Object key, Object value) {
        this.cache.put(key, this.toStoreValue(value));
    }

    @Override
    public void evict(Object key) {
        this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.removeAll();
    }

    protected Object fromStoreValue(Object storeValue) {
        if (this.allowNullValues && storeValue == NULL_HOLDER) {
            return null;
        }
        return storeValue;
    }

    protected Object toStoreValue(Object userValue) {
        if (this.allowNullValues && userValue == null) {
            return NULL_HOLDER;
        }
        return userValue;
    }

    private static class NullHolder
    implements Serializable {
        private NullHolder() {
        }
    }
}

