/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractGenericContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfigContextLoader
extends AbstractGenericContextLoader {
    private static final Log logger = LogFactory.getLog(AnnotationConfigContextLoader.class);

    @Override
    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        if (ObjectUtils.isEmpty((Object[])configAttributes.getClasses()) && this.isGenerateDefaultLocations()) {
            Class<?>[] defaultConfigClasses = this.detectDefaultConfigurationClasses(configAttributes.getDeclaringClass());
            configAttributes.setClasses(defaultConfigClasses);
        }
    }

    private boolean isStaticNonPrivateAndNonFinal(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Class must not be null");
        int modifiers = clazz.getModifiers();
        return Modifier.isStatic(modifiers) && !Modifier.isPrivate(modifiers) && !Modifier.isFinal(modifiers);
    }

    private boolean isDefaultConfigurationClassCandidate(Class<?> clazz) {
        return clazz != null && this.isStaticNonPrivateAndNonFinal(clazz) && clazz.isAnnotationPresent(Configuration.class);
    }

    protected Class<?>[] detectDefaultConfigurationClasses(Class<?> declaringClass) {
        Assert.notNull(declaringClass, (String)"Declaring class must not be null");
        ArrayList configClasses = new ArrayList();
        for (Class<?> candidate : declaringClass.getDeclaredClasses()) {
            if (this.isDefaultConfigurationClassCandidate(candidate)) {
                configClasses.add(candidate);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)String.format("Ignoring class [%s]; it must be static, non-private, non-final, and annotated with @Configuration to be considered a default configuration class.", candidate.getName()));
        }
        if (configClasses.isEmpty() && logger.isInfoEnabled()) {
            logger.info((Object)String.format("Could not detect default configuration classes for test class [%s]: %s does not declare any static, non-private, non-final, inner classes annotated with @Configuration.", declaringClass.getName(), declaringClass.getSimpleName()));
        }
        return configClasses.toArray(new Class[configClasses.size()]);
    }

    @Override
    protected String[] modifyLocations(Class<?> clazz, String ... locations) {
        throw new UnsupportedOperationException("AnnotationConfigContextLoader does not support the modifyLocations(Class, String...) method");
    }

    @Override
    protected String[] generateDefaultLocations(Class<?> clazz) {
        throw new UnsupportedOperationException("AnnotationConfigContextLoader does not support the generateDefaultLocations(Class) method");
    }

    @Override
    protected String getResourceSuffix() {
        throw new UnsupportedOperationException("AnnotationConfigContextLoader does not support the getResourceSuffix() method");
    }

    @Override
    protected void loadBeanDefinitions(GenericApplicationContext context, MergedContextConfiguration mergedConfig) {
        Object[] annotatedClasses = mergedConfig.getClasses();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering annotated classes: " + ObjectUtils.nullSafeToString((Object[])annotatedClasses)));
        }
        new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)context).register((Class[])annotatedClasses);
    }

    @Override
    protected BeanDefinitionReader createBeanDefinitionReader(GenericApplicationContext context) {
        throw new UnsupportedOperationException("AnnotationConfigContextLoader does not support the createBeanDefinitionReader(GenericApplicationContext) method");
    }
}

