/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import javax.servlet.ServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.async.AsyncExecutionChain;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class AsyncMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    public boolean supportsReturnType(MethodParameter returnType) {
        Class paramType = returnType.getParameterType();
        return Callable.class.isAssignableFrom(paramType) || DeferredResult.class.isAssignableFrom(paramType);
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Assert.notNull((Object)returnValue, (String)"A Callable or a DeferredValue is required");
        mavContainer.setRequestHandled(true);
        Class paramType = returnType.getParameterType();
        ServletRequest servletRequest = (ServletRequest)webRequest.getNativeRequest(ServletRequest.class);
        AsyncExecutionChain chain = AsyncExecutionChain.getForCurrentRequest((ServletRequest)servletRequest);
        if (Callable.class.isAssignableFrom(paramType)) {
            chain.setCallable((Callable)returnValue);
            chain.startCallableChainProcessing();
        } else if (DeferredResult.class.isAssignableFrom(paramType)) {
            chain.startDeferredResultProcessing((DeferredResult)returnValue);
        } else {
            Method method = returnType.getMethod();
            throw new UnsupportedOperationException("Unknown return value: " + paramType + " in method: " + method);
        }
    }
}

