/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.SmartView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentNegotiatingViewResolver
extends WebApplicationObjectSupport
implements ViewResolver,
Ordered {
    private static final Log logger = LogFactory.getLog(ContentNegotiatingViewResolver.class);
    private static final String ACCEPT_HEADER = "Accept";
    private static final boolean jafPresent = ClassUtils.isPresent((String)"javax.activation.FileTypeMap", (ClassLoader)ContentNegotiatingViewResolver.class.getClassLoader());
    private static final UrlPathHelper urlPathHelper = new UrlPathHelper();
    private int order = Integer.MIN_VALUE;
    private boolean favorPathExtension = true;
    private boolean favorParameter = false;
    private String parameterName = "format";
    private boolean useNotAcceptableStatusCode = false;
    private boolean ignoreAcceptHeader = false;
    private boolean useJaf = jafPresent;
    private ConcurrentMap<String, MediaType> mediaTypes = new ConcurrentHashMap<String, MediaType>();
    private List<View> defaultViews;
    private MediaType defaultContentType;
    private List<ViewResolver> viewResolvers;
    private static final View NOT_ACCEPTABLE_VIEW;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setFavorPathExtension(boolean favorPathExtension) {
        this.favorPathExtension = favorPathExtension;
    }

    public void setFavorParameter(boolean favorParameter) {
        this.favorParameter = favorParameter;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setIgnoreAcceptHeader(boolean ignoreAcceptHeader) {
        this.ignoreAcceptHeader = ignoreAcceptHeader;
    }

    public void setUseNotAcceptableStatusCode(boolean useNotAcceptableStatusCode) {
        this.useNotAcceptableStatusCode = useNotAcceptableStatusCode;
    }

    public void setMediaTypes(Map<String, String> mediaTypes) {
        Assert.notNull(mediaTypes, (String)"'mediaTypes' must not be null");
        for (Map.Entry<String, String> entry : mediaTypes.entrySet()) {
            String extension = entry.getKey().toLowerCase(Locale.ENGLISH);
            MediaType mediaType = MediaType.parseMediaType((String)entry.getValue());
            this.mediaTypes.put(extension, mediaType);
        }
    }

    public void setDefaultViews(List<View> defaultViews) {
        this.defaultViews = defaultViews;
    }

    public void setDefaultContentType(MediaType defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    public void setUseJaf(boolean useJaf) {
        this.useJaf = useJaf;
    }

    public void setViewResolvers(List<ViewResolver> viewResolvers) {
        this.viewResolvers = viewResolvers;
    }

    protected void initServletContext(ServletContext servletContext) {
        Collection matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), ViewResolver.class).values();
        if (this.viewResolvers == null) {
            this.viewResolvers = new ArrayList<ViewResolver>(matchingBeans.size());
            for (ViewResolver viewResolver : matchingBeans) {
                if (this == viewResolver) continue;
                this.viewResolvers.add(viewResolver);
            }
        } else {
            for (int i = 0; i < this.viewResolvers.size(); ++i) {
                if (matchingBeans.contains(this.viewResolvers.get(i))) continue;
                String name = this.viewResolvers.get(i).getClass().getName() + i;
                this.getApplicationContext().getAutowireCapableBeanFactory().initializeBean((Object)this.viewResolvers.get(i), name);
            }
        }
        if (this.viewResolvers.isEmpty()) {
            logger.warn((Object)"Did not find any ViewResolvers to delegate to; please configure them using the 'viewResolvers' property on the ContentNegotiatingViewResolver");
        }
        OrderComparator.sort(this.viewResolvers);
    }

    @Override
    public View resolveViewName(String viewName, Locale locale) throws Exception {
        List<View> candidateViews;
        View bestView;
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        Assert.isInstanceOf(ServletRequestAttributes.class, (Object)attrs);
        List<MediaType> requestedMediaTypes = this.getMediaTypes(((ServletRequestAttributes)attrs).getRequest());
        if (requestedMediaTypes != null && (bestView = this.getBestView(candidateViews = this.getCandidateViews(viewName, locale, requestedMediaTypes), requestedMediaTypes)) != null) {
            return bestView;
        }
        if (this.useNotAcceptableStatusCode) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No acceptable view found; returning 406 (Not Acceptable) status code");
            }
            return NOT_ACCEPTABLE_VIEW;
        }
        logger.debug((Object)"No acceptable view found; returning null");
        return null;
    }

    protected List<MediaType> getMediaTypes(HttpServletRequest request) {
        String acceptHeader;
        String parameterValue;
        MediaType mediaType;
        String requestUri;
        String filename;
        MediaType mediaType2;
        if (this.favorPathExtension && (mediaType2 = this.getMediaTypeFromFilename(filename = WebUtils.extractFullFilenameFromUrlPath((String)(requestUri = urlPathHelper.getLookupPathForRequest(request))))) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Requested media type is '" + mediaType2 + "' (based on filename '" + filename + "')"));
            }
            return Collections.singletonList(mediaType2);
        }
        if (this.favorParameter && request.getParameter(this.parameterName) != null && (mediaType = this.getMediaTypeFromParameter(parameterValue = request.getParameter(this.parameterName))) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Requested media type is '" + mediaType + "' (based on parameter '" + this.parameterName + "'='" + parameterValue + "')"));
            }
            return Collections.singletonList(mediaType);
        }
        if (!this.ignoreAcceptHeader && StringUtils.hasText((String)(acceptHeader = request.getHeader(ACCEPT_HEADER)))) {
            try {
                List acceptableMediaTypes = MediaType.parseMediaTypes((String)acceptHeader);
                List<MediaType> producibleMediaTypes = this.getProducibleMediaTypes(request);
                LinkedHashSet<MediaType> compatibleMediaTypes = new LinkedHashSet<MediaType>();
                for (MediaType acceptable : acceptableMediaTypes) {
                    for (MediaType producible : producibleMediaTypes) {
                        if (!acceptable.isCompatibleWith(producible)) continue;
                        compatibleMediaTypes.add(this.getMostSpecificMediaType(acceptable, producible));
                    }
                }
                ArrayList<MediaType> selectedMediaTypes = new ArrayList<MediaType>(compatibleMediaTypes);
                MediaType.sortBySpecificityAndQuality(selectedMediaTypes);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Requested media types are " + selectedMediaTypes + " based on Accept header types " + "and producible media types " + producibleMediaTypes + ")"));
                }
                return selectedMediaTypes;
            }
            catch (IllegalArgumentException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not parse accept header [" + acceptHeader + "]: " + ex.getMessage()));
                }
                return null;
            }
        }
        if (this.defaultContentType != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Requested media types is " + this.defaultContentType + " (based on defaultContentType property)"));
            }
            return Collections.singletonList(this.defaultContentType);
        }
        return Collections.emptyList();
    }

    private List<MediaType> getProducibleMediaTypes(HttpServletRequest request) {
        Set mediaTypes = (Set)request.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        if (!CollectionUtils.isEmpty((Collection)mediaTypes)) {
            return new ArrayList<MediaType>(mediaTypes);
        }
        return Collections.singletonList(MediaType.ALL);
    }

    private MediaType getMostSpecificMediaType(MediaType acceptType, MediaType produceType) {
        return MediaType.SPECIFICITY_COMPARATOR.compare(acceptType, produceType = produceType.copyQualityValue(acceptType)) < 0 ? acceptType : produceType;
    }

    protected MediaType getMediaTypeFromFilename(String filename) {
        String extension = StringUtils.getFilenameExtension((String)filename);
        if (!StringUtils.hasText((String)extension)) {
            return null;
        }
        MediaType mediaType = (MediaType)this.mediaTypes.get(extension = extension.toLowerCase(Locale.ENGLISH));
        if (mediaType == null) {
            MediaType jafMediaType;
            String mimeType = this.getServletContext().getMimeType(filename);
            if (StringUtils.hasText((String)mimeType)) {
                mediaType = MediaType.parseMediaType((String)mimeType);
            }
            if (this.useJaf && (mediaType == null || MediaType.APPLICATION_OCTET_STREAM.equals((Object)mediaType)) && (jafMediaType = ActivationMediaTypeFactory.getMediaType(filename)) != null && !MediaType.APPLICATION_OCTET_STREAM.equals((Object)jafMediaType)) {
                mediaType = jafMediaType;
            }
            if (mediaType != null) {
                this.mediaTypes.putIfAbsent(extension, mediaType);
            }
        }
        return mediaType;
    }

    protected MediaType getMediaTypeFromParameter(String parameterValue) {
        return (MediaType)this.mediaTypes.get(parameterValue.toLowerCase(Locale.ENGLISH));
    }

    private List<View> getCandidateViews(String viewName, Locale locale, List<MediaType> requestedMediaTypes) throws Exception {
        ArrayList<View> candidateViews = new ArrayList<View>();
        for (ViewResolver viewResolver : this.viewResolvers) {
            View view = viewResolver.resolveViewName(viewName, locale);
            if (view != null) {
                candidateViews.add(view);
            }
            for (MediaType requestedMediaType : requestedMediaTypes) {
                List<String> extensions = this.getExtensionsForMediaType(requestedMediaType);
                for (String extension : extensions) {
                    String viewNameWithExtension = viewName + "." + extension;
                    view = viewResolver.resolveViewName(viewNameWithExtension, locale);
                    if (view == null) continue;
                    candidateViews.add(view);
                }
            }
        }
        if (!CollectionUtils.isEmpty(this.defaultViews)) {
            candidateViews.addAll(this.defaultViews);
        }
        return candidateViews;
    }

    private List<String> getExtensionsForMediaType(MediaType requestedMediaType) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry entry : this.mediaTypes.entrySet()) {
            if (!requestedMediaType.includes((MediaType)entry.getValue())) continue;
            result.add((String)entry.getKey());
        }
        return result;
    }

    private View getBestView(List<View> candidateViews, List<MediaType> requestedMediaTypes) {
        for (View candidateView : candidateViews) {
            SmartView smartView;
            if (!(candidateView instanceof SmartView) || !(smartView = (SmartView)candidateView).isRedirectView()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Returning redirect view [" + candidateView + "]"));
            }
            return candidateView;
        }
        for (MediaType mediaType : requestedMediaTypes) {
            for (View candidateView : candidateViews) {
                MediaType candidateContentType;
                if (!StringUtils.hasText((String)candidateView.getContentType()) || !mediaType.includes(candidateContentType = MediaType.parseMediaType((String)candidateView.getContentType()))) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Returning [" + candidateView + "] based on requested media type '" + mediaType + "'"));
                }
                return candidateView;
            }
        }
        return null;
    }

    static /* synthetic */ Log access$000() {
        return logger;
    }

    static {
        urlPathHelper.setUrlDecode(false);
        NOT_ACCEPTABLE_VIEW = new View(){

            @Override
            public String getContentType() {
                return null;
            }

            @Override
            public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) {
                response.setStatus(406);
            }
        };
    }

    private static class ActivationMediaTypeFactory {
        private static final FileTypeMap fileTypeMap = ActivationMediaTypeFactory.loadFileTypeMapFromContextSupportModule();

        private ActivationMediaTypeFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private static FileTypeMap loadFileTypeMapFromContextSupportModule() {
            mappingLocation = new ClassPathResource("org/springframework/mail/javamail/mime.types");
            if (mappingLocation.exists()) {
                block13: {
                    if (ContentNegotiatingViewResolver.access$000().isTraceEnabled()) {
                        ContentNegotiatingViewResolver.access$000().trace((Object)("Loading Java Activation Framework FileTypeMap from " + mappingLocation));
                    }
                    inputStream = null;
                    inputStream = mappingLocation.getInputStream();
                    var2_2 = new MimetypesFileTypeMap(inputStream);
                    var4_4 = null;
                    if (inputStream == null) break block13;
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                return var2_2;
                catch (IOException var2_3) {
                    try {
                        var4_5 = null;
                        ** if (inputStream == null) goto lbl-1000
                    }
                    catch (Throwable var3_10) {
                        var4_6 = null;
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                        }
                        throw var3_10;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ex) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
            }
            if (ContentNegotiatingViewResolver.access$000().isTraceEnabled()) {
                ContentNegotiatingViewResolver.access$000().trace((Object)"Loading default Java Activation Framework FileTypeMap");
            }
            return FileTypeMap.getDefaultFileTypeMap();
        }

        public static MediaType getMediaType(String filename) {
            String mediaType = fileTypeMap.getContentType(filename);
            return StringUtils.hasText((String)mediaType) ? MediaType.parseMediaType((String)mediaType) : null;
        }
    }
}

