/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.RegionFactory;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cache.access.AccessType;
import org.hibernate.cache.infinispan.TypeOverrides;
import org.hibernate.cache.infinispan.collection.CollectionRegionImpl;
import org.hibernate.cache.infinispan.entity.EntityRegionImpl;
import org.hibernate.cache.infinispan.query.QueryResultsRegionImpl;
import org.hibernate.cache.infinispan.timestamp.TimestampTypeOverrides;
import org.hibernate.cache.infinispan.timestamp.TimestampsRegionImpl;
import org.hibernate.cache.infinispan.tm.HibernateTransactionManagerLookup;
import org.hibernate.cache.infinispan.util.CacheAdapter;
import org.hibernate.cache.infinispan.util.CacheAdapterImpl;
import org.hibernate.cfg.Settings;
import org.hibernate.util.PropertiesHelper;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanRegionFactory
implements RegionFactory {
    private static final Log log = LogFactory.getLog(InfinispanRegionFactory.class);
    private static final String PREFIX = "hibernate.cache.infinispan.";
    private static final String CONFIG_SUFFIX = ".cfg";
    private static final String STRATEGY_SUFFIX = ".eviction.strategy";
    private static final String WAKE_UP_INTERVAL_SUFFIX = ".eviction.wake_up_interval";
    private static final String MAX_ENTRIES_SUFFIX = ".eviction.max_entries";
    private static final String LIFESPAN_SUFFIX = ".expiration.lifespan";
    private static final String MAX_IDLE_SUFFIX = ".expiration.max_idle";
    public static final String INFINISPAN_CONFIG_RESOURCE_PROP = "hibernate.cache.infinispan.cfg";
    public static final String INFINISPAN_GLOBAL_STATISTICS_PROP = "hibernate.cache.infinispan.statistics";
    private static final String ENTITY_KEY = "entity";
    public static final String ENTITY_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan.entity.cfg";
    private static final String COLLECTION_KEY = "collection";
    public static final String COLLECTION_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan.collection.cfg";
    private static final String TIMESTAMPS_KEY = "timestamps";
    public static final String TIMESTAMPS_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan.timestamps.cfg";
    private static final String QUERY_KEY = "query";
    public static final String QUERY_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan.query.cfg";
    public static final String DEF_INFINISPAN_CONFIG_RESOURCE = "org/hibernate/cache/infinispan/builder/infinispan-configs.xml";
    public static final String DEF_ENTITY_RESOURCE = "entity";
    public static final String DEF_TIMESTAMPS_RESOURCE = "timestamps";
    public static final String DEF_QUERY_RESOURCE = "local-query";
    private EmbeddedCacheManager manager;
    private final Map<String, TypeOverrides> typeOverrides = new HashMap<String, TypeOverrides>();
    private final Set<String> definedConfigurations = new HashSet<String>();
    private TransactionManagerLookup transactionManagerlookup;
    private TransactionManager transactionManager;

    public InfinispanRegionFactory() {
    }

    public InfinispanRegionFactory(Properties props) {
    }

    @Override
    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building collection cache region [" + regionName + "]"));
        }
        Cache cache = this.getCache(regionName, COLLECTION_KEY, properties);
        CacheAdapter cacheAdapter = CacheAdapterImpl.newInstance(cache);
        CollectionRegionImpl region = new CollectionRegionImpl(cacheAdapter, regionName, metadata, this.transactionManager, this);
        region.start();
        return region;
    }

    @Override
    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building entity cache region [" + regionName + "]"));
        }
        Cache cache = this.getCache(regionName, "entity", properties);
        CacheAdapter cacheAdapter = CacheAdapterImpl.newInstance(cache);
        EntityRegionImpl region = new EntityRegionImpl(cacheAdapter, regionName, metadata, this.transactionManager, this);
        region.start();
        return region;
    }

    @Override
    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building query results cache region [" + regionName + "]"));
        }
        String cacheName = this.typeOverrides.get(QUERY_KEY).getCacheName();
        if (!regionName.equals("org.hibernate.cache.StandardQueryCache")) {
            cacheName = regionName;
        }
        Cache cache = this.getCache(cacheName, QUERY_KEY, properties);
        CacheAdapter cacheAdapter = CacheAdapterImpl.newInstance(cache);
        QueryResultsRegionImpl region = new QueryResultsRegionImpl(cacheAdapter, regionName, properties, this.transactionManager, (RegionFactory)this);
        region.start();
        return region;
    }

    @Override
    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building timestamps cache region [" + regionName + "]"));
        }
        Cache cache = this.getCache(regionName, "timestamps", properties);
        CacheAdapter cacheAdapter = CacheAdapterImpl.newInstance(cache);
        TimestampsRegionImpl region = new TimestampsRegionImpl(cacheAdapter, regionName, this.transactionManager, this);
        region.start();
        return region;
    }

    @Override
    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    @Override
    public AccessType getDefaultAccessType() {
        return AccessType.TRANSACTIONAL;
    }

    @Override
    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public void setCacheManager(EmbeddedCacheManager manager) {
        this.manager = manager;
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.manager;
    }

    @Override
    public void start(Settings settings, Properties properties) throws CacheException {
        log.debug((Object)"Starting Infinispan region factory");
        try {
            this.transactionManagerlookup = new HibernateTransactionManagerLookup(settings, properties);
            this.transactionManager = this.transactionManagerlookup.getTransactionManager();
            this.manager = this.createCacheManager(properties);
            this.initGenericDataTypeOverrides();
            Enumeration<?> keys = properties.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                int prefixLoc = -1;
                prefixLoc = key.indexOf(PREFIX);
                if (prefixLoc == -1) continue;
                this.dissectProperty(prefixLoc, key, properties);
            }
            this.defineGenericDataTypeCacheConfigurations(settings, properties);
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new CacheException("Unable to start region factory", t);
        }
    }

    @Override
    public void stop() {
        log.debug((Object)"Stopping Infinispan CacheManager");
        this.manager.stop();
    }

    public Map<String, TypeOverrides> getTypeOverrides() {
        return Collections.unmodifiableMap(this.typeOverrides);
    }

    public Set<String> getDefinedConfigurations() {
        return Collections.unmodifiableSet(this.definedConfigurations);
    }

    protected EmbeddedCacheManager createCacheManager(Properties properties) throws CacheException {
        try {
            String configLoc = PropertiesHelper.getString(INFINISPAN_CONFIG_RESOURCE_PROP, properties, DEF_INFINISPAN_CONFIG_RESOURCE);
            DefaultCacheManager manager = new DefaultCacheManager(configLoc, false);
            String globalStats = PropertiesHelper.extractPropertyValue(INFINISPAN_GLOBAL_STATISTICS_PROP, properties);
            if (globalStats != null) {
                manager.getGlobalConfiguration().setExposeGlobalJmxStatistics(Boolean.parseBoolean(globalStats));
            }
            manager.start();
            return manager;
        }
        catch (IOException e) {
            throw new CacheException("Unable to create default cache manager", e);
        }
    }

    private Map<String, TypeOverrides> initGenericDataTypeOverrides() {
        TypeOverrides entityOverrides = new TypeOverrides();
        entityOverrides.setCacheName("entity");
        this.typeOverrides.put("entity", entityOverrides);
        TypeOverrides collectionOverrides = new TypeOverrides();
        collectionOverrides.setCacheName("entity");
        this.typeOverrides.put(COLLECTION_KEY, collectionOverrides);
        TimestampTypeOverrides timestampOverrides = new TimestampTypeOverrides();
        timestampOverrides.setCacheName("timestamps");
        this.typeOverrides.put("timestamps", timestampOverrides);
        TypeOverrides queryOverrides = new TypeOverrides();
        queryOverrides.setCacheName(DEF_QUERY_RESOURCE);
        this.typeOverrides.put(QUERY_KEY, queryOverrides);
        return this.typeOverrides;
    }

    private void dissectProperty(int prefixLoc, String key, Properties properties) {
        TypeOverrides cfgOverride = null;
        int suffixLoc = -1;
        if (!key.equals(INFINISPAN_CONFIG_RESOURCE_PROP) && (suffixLoc = key.indexOf(CONFIG_SUFFIX)) != -1) {
            cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
            cfgOverride.setCacheName(PropertiesHelper.extractPropertyValue(key, properties));
        } else {
            suffixLoc = key.indexOf(STRATEGY_SUFFIX);
            if (suffixLoc != -1) {
                cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                cfgOverride.setEvictionStrategy(PropertiesHelper.extractPropertyValue(key, properties));
            } else {
                suffixLoc = key.indexOf(WAKE_UP_INTERVAL_SUFFIX);
                if (suffixLoc != -1) {
                    cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                    cfgOverride.setEvictionWakeUpInterval(Long.parseLong(PropertiesHelper.extractPropertyValue(key, properties)));
                } else {
                    suffixLoc = key.indexOf(MAX_ENTRIES_SUFFIX);
                    if (suffixLoc != -1) {
                        cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                        cfgOverride.setEvictionMaxEntries(PropertiesHelper.getInt(key, properties, -1));
                    } else {
                        suffixLoc = key.indexOf(LIFESPAN_SUFFIX);
                        if (suffixLoc != -1) {
                            cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                            cfgOverride.setExpirationLifespan(Long.parseLong(PropertiesHelper.extractPropertyValue(key, properties)));
                        } else {
                            suffixLoc = key.indexOf(MAX_IDLE_SUFFIX);
                            if (suffixLoc != -1) {
                                cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                                cfgOverride.setExpirationMaxIdle(Long.parseLong(PropertiesHelper.extractPropertyValue(key, properties)));
                            }
                        }
                    }
                }
            }
        }
    }

    private TypeOverrides getOrCreateConfig(int prefixLoc, String key, int suffixLoc) {
        String name = key.substring(prefixLoc + PREFIX.length(), suffixLoc);
        TypeOverrides cfgOverride = this.typeOverrides.get(name);
        if (cfgOverride == null) {
            cfgOverride = new TypeOverrides();
            this.typeOverrides.put(name, cfgOverride);
        }
        return cfgOverride;
    }

    private void defineGenericDataTypeCacheConfigurations(Settings settings, Properties properties) throws CacheException {
        String[] defaultGenericDataTypes;
        for (String type : defaultGenericDataTypes = new String[]{"entity", COLLECTION_KEY, "timestamps", QUERY_KEY}) {
            TypeOverrides override = this.overrideStatisticsIfPresent(this.typeOverrides.get(type), properties);
            String cacheName = override.getCacheName();
            Configuration newCacheCfg = override.createInfinispanConfiguration();
            Configuration cacheConfig = this.manager.defineConfiguration(cacheName, cacheName, newCacheCfg);
            cacheConfig = this.configureTransactionManager(cacheConfig, cacheName, properties);
            this.manager.defineConfiguration(cacheName, cacheName, cacheConfig);
            this.definedConfigurations.add(cacheName);
            override.validateInfinispanConfiguration(cacheConfig);
        }
    }

    private Cache getCache(String regionName, String typeKey, Properties properties) {
        TypeOverrides regionOverride = this.typeOverrides.get(regionName);
        if (!this.definedConfigurations.contains(regionName)) {
            String templateCacheName = null;
            Configuration regionCacheCfg = null;
            if (regionOverride != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cache region specific configuration exists: " + regionOverride));
                }
                regionOverride = this.overrideStatisticsIfPresent(regionOverride, properties);
                regionCacheCfg = regionOverride.createInfinispanConfiguration();
                String cacheName = regionOverride.getCacheName();
                templateCacheName = cacheName != null ? cacheName : this.typeOverrides.get(typeKey).getCacheName();
            } else {
                templateCacheName = this.typeOverrides.get(typeKey).getCacheName();
                regionCacheCfg = this.typeOverrides.get(typeKey).createInfinispanConfiguration();
            }
            regionCacheCfg = this.configureTransactionManager(regionCacheCfg, templateCacheName, properties);
            this.manager.defineConfiguration(regionName, templateCacheName, regionCacheCfg);
            this.definedConfigurations.add(regionName);
        }
        return this.manager.getCache(regionName);
    }

    private Configuration configureTransactionManager(Configuration regionOverrides, String templateCacheName, Properties properties) {
        Configuration templateConfig = this.manager.defineConfiguration(templateCacheName, new Configuration());
        String ispnTmLookupClassName = templateConfig.getTransactionManagerLookupClass();
        String hbTmLookupClassName = HibernateTransactionManagerLookup.class.getName();
        if (ispnTmLookupClassName != null && !ispnTmLookupClassName.equals(hbTmLookupClassName)) {
            log.debug((Object)("Infinispan is configured [" + ispnTmLookupClassName + "] with a different transaction manager lookup " + "class than Hibernate [" + hbTmLookupClassName + "]"));
        } else {
            regionOverrides.setTransactionManagerLookup(this.transactionManagerlookup);
        }
        return regionOverrides;
    }

    private TypeOverrides overrideStatisticsIfPresent(TypeOverrides override, Properties properties) {
        String globalStats = PropertiesHelper.extractPropertyValue(INFINISPAN_GLOBAL_STATISTICS_PROP, properties);
        if (globalStats != null) {
            override.setExposeStatistics(Boolean.parseBoolean(globalStats));
        }
        return override;
    }
}

