/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.timestamp;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.RegionFactory;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cache.infinispan.impl.BaseGeneralDataRegion;
import org.hibernate.cache.infinispan.util.CacheAdapter;
import org.hibernate.cache.infinispan.util.CacheHelper;
import org.hibernate.cache.infinispan.util.FlagAdapter;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;

@Listener
public class TimestampsRegionImpl
extends BaseGeneralDataRegion
implements TimestampsRegion {
    private Map localCache = new ConcurrentHashMap();

    public TimestampsRegionImpl(CacheAdapter cacheAdapter, String name, TransactionManager transactionManager, RegionFactory factory) {
        super(cacheAdapter, name, transactionManager, factory);
        cacheAdapter.addListener(this);
        this.populateLocalCache();
    }

    @Override
    public void evict(Object key) throws CacheException {
        this.cacheAdapter.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictAll() throws CacheException {
        Transaction tx = this.suspend();
        try {
            CacheHelper.sendEvictAllNotification(this.cacheAdapter, this.getAddress());
        }
        finally {
            this.resume(tx);
        }
    }

    @Override
    public Object get(Object key) throws CacheException {
        Object value = this.localCache.get(key);
        if (value == null && this.checkValid() && (value = this.get(key, null, false)) != null) {
            this.localCache.put(key, value);
        }
        return value;
    }

    @Override
    public void put(Object key, Object value) throws CacheException {
        Transaction tx = this.suspend();
        try {
            this.cacheAdapter.withFlags(FlagAdapter.FORCE_ASYNCHRONOUS).put(key, value);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
        finally {
            this.resume(tx);
        }
    }

    @Override
    public void destroy() throws CacheException {
        this.localCache.clear();
        this.cacheAdapter.removeListener(this);
        super.destroy();
    }

    @CacheEntryModified
    public void nodeModified(CacheEntryModifiedEvent event) {
        if (!this.handleEvictAllModification(event) && !event.isPre()) {
            this.localCache.put(event.getKey(), event.getValue());
        }
    }

    @CacheEntryRemoved
    public void nodeRemoved(CacheEntryRemovedEvent event) {
        if (event.isPre()) {
            return;
        }
        this.localCache.remove(event.getKey());
    }

    @Override
    protected boolean handleEvictAllModification(CacheEntryModifiedEvent event) {
        boolean result = super.handleEvictAllModification(event);
        if (result) {
            this.localCache.clear();
        }
        return result;
    }

    @Override
    protected boolean handleEvictAllInvalidation(CacheEntryInvalidatedEvent event) {
        boolean result = super.handleEvictAllInvalidation(event);
        if (result) {
            this.localCache.clear();
        }
        return result;
    }

    private void populateLocalCache() {
        Set children = this.cacheAdapter.keySet();
        for (Object key : children) {
            this.get(key);
        }
    }
}

