/**
  ******************************************************************************
  * @file    app.h
  * @author  MCD Application Team
  * @version V1.1.0
  * @date    19-March-2012
  * @brief   Header for app.c file
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT 2012 STMicroelectronics</center></h2>
  *
  * Licensed under MCD-ST Liberty SW License Agreement V2, (the "License");
  * You may not use this file except in compliance with the License.
  * You may obtain a copy of the License at:
  *
  *        http://www.st.com/software_license_agreement_liberty_v2
  *
  * Unless required by applicable law or agreed to in writing, software 
  * distributed under the License is distributed on an "AS IS" BASIS, 
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  ******************************************************************************
  */ 

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __APP__H__
#define __APP__H__

#ifdef __cplusplus
 extern "C" {
#endif 

/* Includes ------------------------------------------------------------------*/
#if defined (USE_STM322xG_EVAL)
 #include "stm32f2xx.h"
 #include "stm322xg_eval.h"
 #include "stm322xg_eval_lcd.h"
#elif defined(USE_STM324xG_EVAL)
 #include "stm32f4xx.h"
 #include "stm324xg_eval.h" 
 #include "stm324xg_eval_lcd.h"
#elif defined (USE_STM3210C_EVAL)
 #include "stm32f10x.h"
 #include "stm3210c_eval.h" 
 #include "stm3210c_eval_lcd.h"
#else
 #error "Missing define: Evaluation board (ie. USE_STM322xG_EVAL)"
#endif

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */

#ifdef __cplusplus
}
#endif

#endif /* __APP__H__ */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
