/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi;

import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.impl.DefaultConfiguration;
import com.opensymphony.xwork2.config.providers.XmlConfigurationProvider;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.osgi.PackageLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundlePackageLoader
implements PackageLoader {
    private static final Logger LOG = LogManager.getLogger(BundlePackageLoader.class);

    @Override
    public List<PackageConfig> loadPackages(Bundle bundle, BundleContext bundleContext, ObjectFactory objectFactory, FileManagerFactory fileManagerFactory, Map<String, PackageConfig> pkgConfigs) throws ConfigurationException {
        DefaultConfiguration config = new DefaultConfiguration("struts.xml");
        BundleConfigurationProvider prov = new BundleConfigurationProvider("struts.xml", bundle, bundleContext);
        for (PackageConfig pkg : pkgConfigs.values()) {
            config.addPackageConfig(pkg.getName(), pkg);
        }
        prov.setObjectFactory(objectFactory);
        prov.setFileManagerFactory(fileManagerFactory);
        prov.init((Configuration)config);
        prov.loadPackages();
        ArrayList<PackageConfig> list = new ArrayList<PackageConfig>(config.getPackageConfigs().values());
        list.removeAll(pkgConfigs.values());
        return list;
    }

    static class EnumeratorIterator<E>
    implements Iterator<E> {
        Enumeration<E> e = null;

        public EnumeratorIterator(Enumeration<E> e) {
            this.e = e;
        }

        @Override
        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        @Override
        public E next() {
            return this.e.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class BundleConfigurationProvider
    extends XmlConfigurationProvider {
        private Bundle bundle;
        private BundleContext bundleContext;

        public BundleConfigurationProvider(String filename, Bundle bundle, BundleContext bundleContext) {
            super(filename, false);
            this.bundle = bundle;
            this.bundleContext = bundleContext;
        }

        public BundleConfigurationProvider(String filename) {
            super(filename);
        }

        protected Iterator<URL> getConfigurationUrls(String fileName) throws IOException {
            Enumeration e = this.bundle.getResources("struts.xml");
            return e.hasMoreElements() ? new EnumeratorIterator(e) : null;
        }
    }
}

