/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.PackageProvider;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import java.util.Map;
import org.apache.struts2.osgi.BundleAccessor;
import org.apache.struts2.osgi.OsgiConfigurationProvider;
import org.apache.struts2.util.ObjectFactoryDestroyable;

public class DelegatingObjectFactory
extends ObjectFactory
implements ObjectFactoryDestroyable {
    private ObjectFactory delegateObjectFactory;
    private BundleAccessor bundleResourceLoader;
    private OsgiConfigurationProvider osgiConfigurationProvider;

    @Inject
    public void setDelegateObjectFactory(@Inject Container container, @Inject(value="struts.objectFactory.delegate") String delegate) {
        if (delegate == null) {
            delegate = "struts";
        }
        this.delegateObjectFactory = (ObjectFactory)container.getInstance(ObjectFactory.class, delegate);
    }

    @Inject
    public void setBundleResourceLoader(BundleAccessor rl) {
        this.bundleResourceLoader = rl;
    }

    public boolean isNoArgConstructorRequired() {
        return this.delegateObjectFactory.isNoArgConstructorRequired();
    }

    public Object buildBean(Class clazz, Map extraContext) throws Exception {
        return this.delegateObjectFactory.buildBean(clazz, extraContext);
    }

    public Object buildBean(String className, Map<String, Object> extraContext, boolean injectInternal) throws Exception {
        try {
            return this.delegateObjectFactory.buildBean(className, extraContext, injectInternal);
        }
        catch (Exception e) {
            Object object = this.bundleResourceLoader.loadClass(className).newInstance();
            if (injectInternal) {
                this.injectInternalBeans(object);
            }
            return object;
        }
    }

    public Class getClassInstance(String className) throws ClassNotFoundException {
        try {
            return this.delegateObjectFactory.getClassInstance(className);
        }
        catch (Exception e) {
            return this.bundleResourceLoader.loadClass(className);
        }
    }

    public void destroy() {
        if (this.osgiConfigurationProvider != null) {
            this.osgiConfigurationProvider.destroy();
        }
    }

    @Inject(value="osgi")
    public void setOsgiConfigurationProvider(PackageProvider osgiConfigurationProvider) {
        this.osgiConfigurationProvider = (OsgiConfigurationProvider)osgiConfigurationProvider;
    }
}

