/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.autotag.core.runtime;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Pattern;
import org.apache.tiles.autotag.core.runtime.ModelBody;
import org.apache.tiles.autotag.core.runtime.util.NullWriter;

public abstract class AbstractModelBody
implements ModelBody {
    private static final Pattern PATTERN = Pattern.compile("^\\s*|\\s*$");
    private Writer defaultWriter;

    public AbstractModelBody(Writer defaultWriter) {
        this.defaultWriter = defaultWriter;
    }

    @Override
    public void evaluate() throws IOException {
        this.evaluate(this.defaultWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String evaluateAsString() throws IOException {
        StringWriter writer = new StringWriter();
        try {
            this.evaluate(writer);
        }
        finally {
            writer.close();
        }
        String body = writer.toString();
        if (body != null && (body = PATTERN.matcher(body).replaceAll("")).length() <= 0) {
            body = null;
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluateWithoutWriting() throws IOException {
        NullWriter writer = new NullWriter();
        try {
            this.evaluate(writer);
        }
        finally {
            writer.close();
        }
    }
}

