/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.base.Type;

public class ObjectConstant
extends Expression {
    private final Type type;
    private final String value;

    public ObjectConstant(StringConstant node) {
        this((Node)node, node.evaluate());
    }

    public ObjectConstant(Node fromNode, String value) {
        this(fromNode, value, null);
    }

    public ObjectConstant(Node fromNode, String value, Type type) {
        super(fromNode, null);
        this.value = Preconditions.checkNotNull(value);
        this.type = type;
    }

    public ObjectConstant withType(Type newType) {
        return new ObjectConstant(this, this.getValue(), newType);
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitObjectConstant(this);
    }

    public String toString() {
        return this.getDisplayName() + "=StringConstant@" + this.getSourcePosition() + "(\"" + CharEscapers.javaStringEscaper().escape(this.getValue()) + "\")";
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof ObjectConstant && this.equals((ObjectConstant)that);
    }

    public boolean equals(ObjectConstant that) {
        return this.equalsExpression(that) && this.value.equals(that.value) && Objects.equal(this.type, that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.type, this.value);
    }
}

