/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.bind;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.com.google.common.collect.Sets;
import com.google.gxp.compiler.alerts.AlertSetBuilder;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.common.BadNodePlacementError;
import com.google.gxp.compiler.alerts.common.MultiValueAttributeError;
import com.google.gxp.compiler.base.AttrBundleParam;
import com.google.gxp.compiler.base.BoundCall;
import com.google.gxp.compiler.base.BoundImplementsDeclaration;
import com.google.gxp.compiler.base.BundleType;
import com.google.gxp.compiler.base.Call;
import com.google.gxp.compiler.base.CallVisitor;
import com.google.gxp.compiler.base.Callable;
import com.google.gxp.compiler.base.CollapseExpression;
import com.google.gxp.compiler.base.ConstructedConstant;
import com.google.gxp.compiler.base.ConvertibleToContent;
import com.google.gxp.compiler.base.DefaultingTypeVisitor;
import com.google.gxp.compiler.base.ExhaustiveExpressionVisitor;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.FormalParameter;
import com.google.gxp.compiler.base.Implementable;
import com.google.gxp.compiler.base.ImplementsDeclaration;
import com.google.gxp.compiler.base.ImplementsVisitor;
import com.google.gxp.compiler.base.NativeImplementsDeclaration;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.ObjectConstant;
import com.google.gxp.compiler.base.Root;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.base.Template;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.base.Type;
import com.google.gxp.compiler.base.UnboundCall;
import com.google.gxp.compiler.base.UnboundImplementsDeclaration;
import com.google.gxp.compiler.base.ValidatedCall;
import com.google.gxp.compiler.bind.BadParameterError;
import com.google.gxp.compiler.bind.BoundTree;
import com.google.gxp.compiler.bind.CallableNotFoundError;
import com.google.gxp.compiler.bind.ImplementableNotFoundError;
import com.google.gxp.compiler.bind.InvalidParameterFailedRegexError;
import com.google.gxp.compiler.reparent.Attribute;
import com.google.gxp.compiler.reparent.ReparentedTree;
import com.google.gxp.compiler.schema.AttributeValidator;
import com.google.gxp.compiler.schema.Schema;
import com.google.gxp.compiler.schema.SchemaFactory;
import com.google.gxp.compiler.servicedir.ScopedServiceDirectory;
import com.google.gxp.compiler.servicedir.ServiceDirectory;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class Binder
implements Function<ReparentedTree, BoundTree> {
    private final SchemaFactory schemaFactory;
    private final ServiceDirectory baseServiceDirectory;

    public Binder(SchemaFactory schemaFactory, ServiceDirectory baseServiceDirectory) {
        this.schemaFactory = Preconditions.checkNotNull(schemaFactory);
        this.baseServiceDirectory = Preconditions.checkNotNull(baseServiceDirectory);
    }

    @Override
    public BoundTree apply(ReparentedTree reparentedTree) {
        HashSet<Callable> requirements = Sets.newHashSet();
        AlertSetBuilder alertSetBuilder = new AlertSetBuilder(reparentedTree.getAlerts());
        Object oldRoot = reparentedTree.getRoot();
        ScopedServiceDirectory serviceDirectory = new ScopedServiceDirectory(alertSetBuilder, this.baseServiceDirectory, oldRoot.getName().getPackageName(), oldRoot.getImports());
        Root newRoot = oldRoot.acceptVisitor(new Visitor(alertSetBuilder, this.schemaFactory, serviceDirectory, requirements));
        return new BoundTree(reparentedTree.getSourcePosition(), alertSetBuilder.buildAndClear(), newRoot, requirements);
    }

    private static class Visitor
    extends ExhaustiveExpressionVisitor
    implements CallVisitor<Expression>,
    ImplementsVisitor<ImplementsDeclaration> {
        private final AlertSink alertSink;
        private final SchemaFactory schemaFactory;
        private final ServiceDirectory serviceDirectory;
        private final Set<Callable> requirements;

        Visitor(AlertSink alertSink, SchemaFactory schemaFactory, ServiceDirectory serviceDirectory, Set<Callable> requirements) {
            this.alertSink = Preconditions.checkNotNull(alertSink);
            this.schemaFactory = Preconditions.checkNotNull(schemaFactory);
            this.serviceDirectory = Preconditions.checkNotNull(serviceDirectory);
            this.requirements = Preconditions.checkNotNull(requirements);
        }

        @Override
        public Template visitTemplate(Template template) {
            LinkedList<ImplementsDeclaration> newImplDeclarations = Lists.newLinkedList();
            for (ImplementsDeclaration id : template.getImplementsDeclarations()) {
                ImplementsDeclaration transformedImplDec = id.acceptImplementsVisitor(this);
                if (transformedImplDec == null) continue;
                newImplDeclarations.add(transformedImplDec);
            }
            return super.visitTemplate(template.withImplementsDeclarations(newImplDeclarations));
        }

        @Override
        public Expression visitCall(Call call) {
            return call.acceptCallVisitor(this);
        }

        @Override
        public Expression visitBoundCall(BoundCall call) {
            return call.transformParams(this);
        }

        @Override
        public Expression visitValidatedCall(ValidatedCall call) {
            return call.transformParams(this);
        }

        @Override
        public Expression visitUnboundCall(UnboundCall call) {
            Callable callee;
            TemplateName calleeName = call.getCallee();
            Map<String, Attribute> params = call.getAttributes();
            Callable callable = callee = params.containsKey("this") ? this.serviceDirectory.getInstanceCallable(calleeName) : this.serviceDirectory.getCallable(calleeName);
            if (callee == null) {
                this.alertSink.add(new CallableNotFoundError(call, calleeName));
                return new StringConstant(call, null, "");
            }
            final ImmutableMap.Builder newAttrBuilder = ImmutableMap.builder();
            final LinkedHashMap attrBundles = Maps.newLinkedHashMap();
            for (FormalParameter formalParameter : callee.getParameters()) {
                if (!(formalParameter.getType() instanceof BundleType)) continue;
                attrBundles.put(formalParameter.getPrimaryName(), new LinkedHashMap());
            }
            for (Map.Entry entry : params.entrySet()) {
                final String name = (String)entry.getKey();
                final FormalParameter parameter = callee.getParameter(name);
                Attribute attr = (Attribute)entry.getValue();
                if (parameter == null) {
                    this.alertSink.add(new BadParameterError(attr.getValue(), callee, name));
                    continue;
                }
                if (attr.getValue() instanceof ObjectConstant) {
                    ObjectConstant oc = (ObjectConstant)attr.getValue();
                    if (!parameter.regexMatches(oc)) {
                        this.alertSink.add(new InvalidParameterFailedRegexError(calleeName, name, parameter.getRegex(), oc));
                    }
                    attr = parameter.hasConstructor() ? attr.withValue(new ConstructedConstant(oc, oc.getValue(), callee, parameter)) : attr.withValue(parameter.getType().parseObjectConstant(name, oc, this.alertSink));
                }
                attr = attr.withValue(Visitor.prepareExpressionAsParameterValue(parameter, attr.getValue()));
                final Attribute updatedAttr = this.visitAttribute(attr);
                parameter.getType().acceptTypeVisitor(new DefaultingTypeVisitor<Void>(){

                    @Override
                    protected Void defaultVisitType(Type type) {
                        newAttrBuilder.put(name, updatedAttr);
                        return null;
                    }

                    @Override
                    public Void visitBundleType(BundleType type) {
                        AttributeValidator validator = type.getValidator(name);
                        String innerContentTypeString = validator.getContentType();
                        if (innerContentTypeString != null) {
                            Schema innerSchema = Visitor.this.schemaFactory.fromContentTypeName(innerContentTypeString);
                            ((Map)attrBundles.get(parameter.getPrimaryName())).put(validator, updatedAttr.withInnerSchema(innerSchema));
                        } else {
                            ((Map)attrBundles.get(parameter.getPrimaryName())).put(validator, updatedAttr);
                        }
                        return null;
                    }
                });
            }
            for (Map.Entry entry : attrBundles.entrySet()) {
                FormalParameter parameter = callee.getParameterByPrimary((String)entry.getKey());
                BundleType bt = (BundleType)parameter.getType();
                Set<String> includeAttrs = attrBundles.size() == 1 ? Collections.emptySet() : bt.getAttrMap().keySet();
                AttrBundleParam newBundle = new AttrBundleParam(call, callee.getSchema(), includeAttrs, (Map)entry.getValue(), call.getAttrBundles());
                newAttrBuilder.put(entry.getKey(), new Attribute((Node)call, (String)entry.getKey(), newBundle, null));
            }
            FormalParameter contentParam = callee.getContentConsumingParameter();
            Expression expression = Visitor.prepareExpressionAsParameterValue(contentParam, this.apply(call.getContent()));
            boolean contentIgnorable = expression.alwaysOnlyWhitespace();
            if (contentParam == null) {
                if (!contentIgnorable) {
                    this.alertSink.add(new BadNodePlacementError(expression, call));
                }
            } else {
                String paramName = contentParam.getPrimaryName();
                if (!contentIgnorable && params.containsKey(paramName)) {
                    this.alertSink.add(new MultiValueAttributeError(call, params.get(paramName)));
                } else if (!contentIgnorable || !contentParam.hasDefault() && !params.containsKey(paramName)) {
                    newAttrBuilder.put(contentParam.getPrimaryName(), new Attribute((Node)call, paramName, expression, null));
                }
            }
            this.requirements.add(callee);
            return new BoundCall(call, callee, newAttrBuilder.build());
        }

        private static Expression prepareExpressionAsParameterValue(FormalParameter parameter, Expression expr) {
            if (parameter != null) {
                if (!parameter.getType().isContent() && expr instanceof ConvertibleToContent) {
                    expr = ((ConvertibleToContent)expr).getSubexpression();
                }
                if (expr instanceof CollapseExpression || expr instanceof ConvertibleToContent) {
                    return CollapseExpression.create(expr, parameter.getSpaceOperators());
                }
            }
            return expr;
        }

        @Override
        public ImplementsDeclaration visitUnboundImplementsDeclaration(UnboundImplementsDeclaration uid) {
            TemplateName templateName = uid.getTemplateName();
            Implementable theInterface = this.serviceDirectory.getImplementable(templateName);
            if (theInterface == null) {
                this.alertSink.add(new ImplementableNotFoundError(uid, templateName));
                return null;
            }
            this.requirements.add(theInterface);
            return new BoundImplementsDeclaration(theInterface, uid.getSourcePosition(), uid.getDisplayName());
        }

        @Override
        public ImplementsDeclaration visitBoundImplementsDeclaration(BoundImplementsDeclaration bid) {
            return bid;
        }

        @Override
        public ImplementsDeclaration visitNativeImplementsDeclaration(NativeImplementsDeclaration nid) {
            return nid;
        }
    }
}

