/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.TextProviderFactory;
import com.opensymphony.xwork2.Validateable;
import com.opensymphony.xwork2.ValidationAwareSupport;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.ValidationAware;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class ActionSupport
implements Action,
Validateable,
ValidationAware,
TextProvider,
LocaleProvider,
Serializable {
    private final ValidationAwareSupport validationAware = new ValidationAwareSupport();
    private transient TextProvider textProvider;
    protected Container container;

    @Override
    public void setActionErrors(Collection<String> errorMessages) {
        this.validationAware.setActionErrors(errorMessages);
    }

    @Override
    public Collection<String> getActionErrors() {
        return this.validationAware.getActionErrors();
    }

    @Override
    public void setActionMessages(Collection<String> messages) {
        this.validationAware.setActionMessages(messages);
    }

    @Override
    public Collection<String> getActionMessages() {
        return this.validationAware.getActionMessages();
    }

    @Override
    public void setFieldErrors(Map<String, List<String>> errorMap) {
        this.validationAware.setFieldErrors(errorMap);
    }

    @Override
    public Map<String, List<String>> getFieldErrors() {
        return this.validationAware.getFieldErrors();
    }

    @Override
    public Locale getLocale() {
        return this.container.getInstance(LocaleProvider.class).getLocale();
    }

    @Override
    public boolean isValidLocaleString(String localeStr) {
        return this.container.getInstance(LocaleProvider.class).isValidLocaleString(localeStr);
    }

    @Override
    public boolean isValidLocale(Locale locale) {
        return this.container.getInstance(LocaleProvider.class).isValidLocale(locale);
    }

    @Override
    public boolean hasKey(String key) {
        return this.getTextProvider().hasKey(key);
    }

    @Override
    public String getText(String aTextName) {
        return this.getTextProvider().getText(aTextName);
    }

    @Override
    public String getText(String aTextName, String defaultValue) {
        return this.getTextProvider().getText(aTextName, defaultValue);
    }

    @Override
    public String getText(String aTextName, String defaultValue, String obj) {
        return this.getTextProvider().getText(aTextName, defaultValue, obj);
    }

    @Override
    public String getText(String aTextName, List<?> args) {
        return this.getTextProvider().getText(aTextName, args);
    }

    @Override
    public String getText(String key, String[] args) {
        return this.getTextProvider().getText(key, args);
    }

    @Override
    public String getText(String aTextName, String defaultValue, List<?> args) {
        return this.getTextProvider().getText(aTextName, defaultValue, args);
    }

    @Override
    public String getText(String key, String defaultValue, String[] args) {
        return this.getTextProvider().getText(key, defaultValue, args);
    }

    @Override
    public String getText(String key, String defaultValue, List<?> args, ValueStack stack) {
        return this.getTextProvider().getText(key, defaultValue, args, stack);
    }

    @Override
    public String getText(String key, String defaultValue, String[] args, ValueStack stack) {
        return this.getTextProvider().getText(key, defaultValue, args, stack);
    }

    public String getFormatted(String key, String expr) {
        Map<String, Object> conversionErrors = ActionContext.getContext().getConversionErrors();
        if (conversionErrors.containsKey(expr)) {
            String[] vals = (String[])conversionErrors.get(expr);
            return vals[0];
        }
        ValueStack valueStack = ActionContext.getContext().getValueStack();
        Object val = valueStack.findValue(expr);
        return this.getText(key, Arrays.asList(val));
    }

    @Override
    public ResourceBundle getTexts() {
        return this.getTextProvider().getTexts();
    }

    @Override
    public ResourceBundle getTexts(String aBundleName) {
        return this.getTextProvider().getTexts(aBundleName);
    }

    @Override
    public void addActionError(String anErrorMessage) {
        this.validationAware.addActionError(anErrorMessage);
    }

    @Override
    public void addActionMessage(String aMessage) {
        this.validationAware.addActionMessage(aMessage);
    }

    @Override
    public void addFieldError(String fieldName, String errorMessage) {
        this.validationAware.addFieldError(fieldName, errorMessage);
    }

    public String input() throws Exception {
        return "input";
    }

    @Override
    public String execute() throws Exception {
        return "success";
    }

    @Override
    public boolean hasActionErrors() {
        return this.validationAware.hasActionErrors();
    }

    @Override
    public boolean hasActionMessages() {
        return this.validationAware.hasActionMessages();
    }

    @Override
    public boolean hasErrors() {
        return this.validationAware.hasErrors();
    }

    @Override
    public boolean hasFieldErrors() {
        return this.validationAware.hasFieldErrors();
    }

    public void clearFieldErrors() {
        this.validationAware.clearFieldErrors();
    }

    public void clearActionErrors() {
        this.validationAware.clearActionErrors();
    }

    public void clearMessages() {
        this.validationAware.clearMessages();
    }

    public void clearErrors() {
        this.validationAware.clearErrors();
    }

    public void clearErrorsAndMessages() {
        this.validationAware.clearErrorsAndMessages();
    }

    @Override
    public void validate() {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void pause(String result) {
    }

    private TextProvider getTextProvider() {
        if (this.textProvider == null) {
            TextProviderFactory tpf = new TextProviderFactory();
            if (this.container != null) {
                this.container.inject(tpf);
            }
            this.textProvider = tpf.createInstance(this.getClass(), (LocaleProvider)this);
        }
        return this.textProvider;
    }

    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }
}

