/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import java.util.Arrays;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultLocaleProvider
implements LocaleProvider {
    private static final Logger LOG = LogManager.getLogger(DefaultLocaleProvider.class);

    @Override
    public Locale getLocale() {
        ActionContext ctx = ActionContext.getContext();
        if (ctx != null) {
            return ctx.getLocale();
        }
        LOG.debug("Action context not initialized");
        return null;
    }

    @Override
    public boolean isValidLocaleString(String localeStr) {
        return this.isValidLocale(LocalizedTextUtil.localeFromString(localeStr, this.getLocale()));
    }

    @Override
    public boolean isValidLocale(Locale locale) {
        return locale != null && Arrays.asList(Locale.getAvailableLocales()).contains(locale);
    }
}

