/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator.validators;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;
import org.apache.commons.lang3.StringUtils;

public class DoubleRangeFieldValidator
extends FieldValidatorSupport {
    private Double maxInclusive = null;
    private Double minInclusive = null;
    private Double minExclusive = null;
    private Double maxExclusive = null;
    private String minInclusiveExpression;
    private String maxInclusiveExpression;
    private String minExclusiveExpression;
    private String maxExclusiveExpression;

    @Override
    public void validate(Object object) throws ValidationException {
        Double value;
        String fieldName = this.getFieldName();
        try {
            Object obj = this.getFieldValue(fieldName, object);
            if (obj == null) {
                return;
            }
            value = Double.valueOf(obj.toString());
        }
        catch (NumberFormatException e) {
            return;
        }
        Double maxInclusiveToUse = this.getMaxInclusive();
        Double minInclusiveToUse = this.getMinInclusive();
        Double maxExclusiveToUse = this.getMaxExclusive();
        Double minExclusiveToUse = this.getMinExclusive();
        if (maxInclusiveToUse != null && value.compareTo(maxInclusiveToUse) > 0 || minInclusiveToUse != null && value.compareTo(minInclusiveToUse) < 0 || maxExclusiveToUse != null && value.compareTo(maxExclusiveToUse) >= 0 || minExclusiveToUse != null && value.compareTo(minExclusiveToUse) <= 0) {
            this.addFieldError(fieldName, object);
        }
    }

    public void setMaxInclusive(Double maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    public Double getMaxInclusive() {
        if (this.maxInclusive != null) {
            return this.maxInclusive;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.maxInclusiveExpression)) {
            return (Double)this.parse(this.maxInclusiveExpression, Double.class);
        }
        return this.maxInclusive;
    }

    public void setMinInclusive(Double minInclusive) {
        this.minInclusive = minInclusive;
    }

    public Double getMinInclusive() {
        if (this.minInclusive != null) {
            return this.minInclusive;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.minInclusiveExpression)) {
            return (Double)this.parse(this.minInclusiveExpression, Double.class);
        }
        return null;
    }

    public void setMinExclusive(Double minExclusive) {
        this.minExclusive = minExclusive;
    }

    public Double getMinExclusive() {
        if (this.minExclusive != null) {
            return this.minExclusive;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.minExclusiveExpression)) {
            return (Double)this.parse(this.minExclusiveExpression, Double.class);
        }
        return null;
    }

    public void setMaxExclusive(Double maxExclusive) {
        this.maxExclusive = maxExclusive;
    }

    public Double getMaxExclusive() {
        if (this.maxExclusive != null) {
            return this.maxExclusive;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.maxExclusiveExpression)) {
            return (Double)this.parse(this.maxExclusiveExpression, Double.class);
        }
        return null;
    }

    public void setMinInclusiveExpression(String minInclusiveExpression) {
        this.minInclusiveExpression = minInclusiveExpression;
    }

    public void setMaxInclusiveExpression(String maxInclusiveExpression) {
        this.maxInclusiveExpression = maxInclusiveExpression;
    }

    public void setMinExclusiveExpression(String minExclusiveExpression) {
        this.minExclusiveExpression = minExclusiveExpression;
    }

    public void setMaxExclusiveExpression(String maxExclusiveExpression) {
        this.maxExclusiveExpression = maxExclusiveExpression;
    }
}

