/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.codebehind;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.UnknownHandler;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.config.providers.InterceptorBuilder;
import com.opensymphony.xwork2.inject.Inject;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CodebehindUnknownHandler
implements UnknownHandler {
    protected String defaultPackageName;
    protected ServletContext servletContext;
    protected Map<String, ResultTypeConfig> resultsByExtension;
    protected String templatePathPrefix;
    protected Configuration configuration;
    protected ObjectFactory objectFactory;
    protected static final Log LOG = LogFactory.getLog(CodebehindUnknownHandler.class);

    @Inject
    public CodebehindUnknownHandler(@Inject(value="struts.codebehind.defaultPackage") String defaultPackage, @Inject Configuration configuration) {
        this.configuration = configuration;
        this.defaultPackageName = defaultPackage;
        this.resultsByExtension = new LinkedHashMap<String, ResultTypeConfig>();
        PackageConfig parentPackage = configuration.getPackageConfig(this.defaultPackageName);
        if (parentPackage == null) {
            throw new ConfigurationException("Unknown parent package: " + parentPackage);
        }
        Map results = parentPackage.getAllResultTypeConfigs();
        this.resultsByExtension.put("jsp", (ResultTypeConfig)results.get("dispatcher"));
        this.resultsByExtension.put("vm", (ResultTypeConfig)results.get("velocity"));
        this.resultsByExtension.put("ftl", (ResultTypeConfig)results.get("freemarker"));
    }

    @Inject(value="struts.codebehind.pathPrefix")
    public void setPathPrefix(String prefix) {
        this.templatePathPrefix = prefix;
    }

    @Inject
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Inject
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public ActionConfig handleUnknownAction(String namespace, String actionName) throws XWorkException {
        String pathPrefix = this.determinePath(this.templatePathPrefix, namespace);
        ActionConfig actionConfig = null;
        for (String ext : this.resultsByExtension.keySet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to locate unknown action template with extension ." + ext + " in directory " + pathPrefix));
            }
            String path = this.string(pathPrefix, actionName, ".", ext);
            try {
                if (this.servletContext.getResource(path) == null) continue;
                actionConfig = this.buildActionConfig(path, namespace, actionName, this.resultsByExtension.get(ext));
                break;
            }
            catch (MalformedURLException e) {
                LOG.warn((Object)("Unable to parse template path: " + path + ", skipping..."));
            }
        }
        return actionConfig;
    }

    protected ActionConfig buildActionConfig(String path, String namespace, String actionName, ResultTypeConfig resultTypeConfig) {
        HashMap<String, ResultConfig> results = new HashMap<String, ResultConfig>();
        HashMap<String, String> params = new HashMap<String, String>();
        if (resultTypeConfig.getParams() != null) {
            params.putAll(resultTypeConfig.getParams());
        }
        params.put(resultTypeConfig.getDefaultResultParam(), path);
        PackageConfig pkg = this.configuration.getPackageConfig(this.defaultPackageName);
        List interceptors = InterceptorBuilder.constructInterceptorReference((PackageConfig)pkg, (String)pkg.getFullDefaultInterceptorRef(), (Map)Collections.EMPTY_MAP, null, (ObjectFactory)this.objectFactory);
        ResultConfig config = new ResultConfig("success", resultTypeConfig.getClazz(), params);
        results.put("success", config);
        return new ActionConfig("execute", ActionSupport.class.getName(), this.defaultPackageName, new HashMap(), results, interceptors);
    }

    public Result handleUnknownResult(ActionContext actionContext, String actionName, ActionConfig actionConfig, String resultCode) throws XWorkException {
        Result result = null;
        PackageConfig pkg = this.configuration.getPackageConfig(actionConfig.getPackageName());
        String ns = pkg.getNamespace();
        String pathPrefix = this.determinePath(this.templatePathPrefix, ns);
        for (String ext : this.resultsByExtension.keySet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to locate result with extension ." + ext + " in directory " + pathPrefix));
            }
            String path = this.string(pathPrefix, actionName, "-", resultCode, ".", ext);
            try {
                if (this.servletContext.getResource(path) != null) {
                    result = this.buildResult(path, resultCode, this.resultsByExtension.get(ext), actionContext);
                    break;
                }
            }
            catch (MalformedURLException e) {
                LOG.warn((Object)("Unable to parse template path: " + path + ", skipping..."));
            }
            path = this.string(pathPrefix, actionName, ".", ext);
            try {
                if (this.servletContext.getResource(path) == null) continue;
                result = this.buildResult(path, resultCode, this.resultsByExtension.get(ext), actionContext);
                break;
            }
            catch (MalformedURLException e) {
                LOG.warn((Object)("Unable to parse template path: " + path + ", skipping..."));
            }
        }
        return result;
    }

    protected Result buildResult(String path, String resultCode, ResultTypeConfig config, ActionContext invocationContext) {
        String resultClass = config.getClazz();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (config.getParams() != null) {
            params.putAll(config.getParams());
        }
        params.put(config.getDefaultResultParam(), path);
        ResultConfig resultConfig = new ResultConfig(resultCode, resultClass, params);
        try {
            return this.objectFactory.buildResult(resultConfig, invocationContext.getContextMap());
        }
        catch (Exception e) {
            throw new XWorkException("Unable to build codebehind result", (Throwable)e, (Object)resultConfig);
        }
    }

    protected String string(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part);
        }
        return sb.toString();
    }

    protected String determinePath(String prefix, String ns) {
        if (ns == null || "/".equals(ns)) {
            ns = "";
        }
        if (ns.length() > 0) {
            if (ns.charAt(0) == '/') {
                ns = ns.substring(1);
            }
            if (ns.charAt(ns.length() - 1) != '/') {
                ns = ns + "/";
            }
        }
        return prefix + ns;
    }
}

