/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.sitegraph;

import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.config.BeanSelectionProvider;
import org.apache.struts2.config.DefaultPropertiesProvider;
import org.apache.struts2.config.LegacyPropertiesConfigurationProvider;
import org.apache.struts2.config.StrutsXmlConfigurationProvider;
import org.apache.struts2.sitegraph.entities.FreeMarkerView;
import org.apache.struts2.sitegraph.entities.JspView;
import org.apache.struts2.sitegraph.entities.VelocityView;
import org.apache.struts2.sitegraph.entities.View;

public class StrutsConfigRetriever {
    private static final Log LOG = LogFactory.getLog(StrutsConfigRetriever.class);
    private static String configDir;
    private static String[] views;
    private static boolean isXWorkStarted;
    private static Map viewCache;
    private static ConfigurationManager cm;

    public static Map getActionConfigs() {
        if (!isXWorkStarted) {
            StrutsConfigRetriever.initXWork();
        }
        return cm.getConfiguration().getRuntimeConfiguration().getActionConfigs();
    }

    private static void initXWork() {
        String configFilePath = configDir + "/struts.xml";
        File configFile = new File(configFilePath);
        try {
            StrutsXmlConfigurationProvider configProvider = new StrutsXmlConfigurationProvider(configFile.getCanonicalPath(), true, null);
            cm = new ConfigurationManager();
            cm.addConfigurationProvider((ConfigurationProvider)new DefaultPropertiesProvider());
            cm.addConfigurationProvider((ConfigurationProvider)new StrutsXmlConfigurationProvider("struts-default.xml", false, null));
            cm.addConfigurationProvider((ConfigurationProvider)configProvider);
            cm.addConfigurationProvider((ConfigurationProvider)new LegacyPropertiesConfigurationProvider());
            cm.addConfigurationProvider((ConfigurationProvider)new BeanSelectionProvider());
            isXWorkStarted = true;
        }
        catch (IOException e) {
            LOG.error((Object)"IOException", (Throwable)e);
        }
    }

    public static Set getNamespaces() {
        Set namespaces = Collections.EMPTY_SET;
        Map allActionConfigs = StrutsConfigRetriever.getActionConfigs();
        if (allActionConfigs != null) {
            namespaces = allActionConfigs.keySet();
        }
        return namespaces;
    }

    public static Set getActionNames(String namespace) {
        Map actionMappings;
        Set actionNames = Collections.EMPTY_SET;
        Map allActionConfigs = StrutsConfigRetriever.getActionConfigs();
        if (allActionConfigs != null && (actionMappings = (Map)allActionConfigs.get(namespace)) != null) {
            actionNames = actionMappings.keySet();
        }
        return actionNames;
    }

    public static ActionConfig getActionConfig(String namespace, String actionName) {
        Map actionMappings;
        ActionConfig config = null;
        Map allActionConfigs = StrutsConfigRetriever.getActionConfigs();
        if (allActionConfigs != null && (actionMappings = (Map)allActionConfigs.get(namespace)) != null) {
            config = (ActionConfig)actionMappings.get(actionName);
        }
        return config;
    }

    public static ResultConfig getResultConfig(String namespace, String actionName, String resultName) {
        ResultConfig result = null;
        ActionConfig actionConfig = StrutsConfigRetriever.getActionConfig(namespace, actionName);
        if (actionConfig != null) {
            Map resultMap = actionConfig.getResults();
            result = (ResultConfig)resultMap.get(resultName);
        }
        return result;
    }

    public static File getViewFile(String namespace, String actionName, String resultName) {
        ResultConfig result = StrutsConfigRetriever.getResultConfig(namespace, actionName, resultName);
        String location = (String)result.getParams().get("location");
        for (int i = 0; i < views.length; ++i) {
            String viewRoot = views[i];
            File viewFile = StrutsConfigRetriever.getViewFileInternal(viewRoot, location, namespace);
            if (viewFile == null) continue;
            return viewFile;
        }
        return null;
    }

    private static File getViewFileInternal(String root, String location, String namespace) {
        StringBuffer filePath = new StringBuffer(root);
        if (!location.startsWith("/")) {
            filePath.append(namespace + "/");
        }
        filePath.append(location);
        File viewFile = new File(filePath.toString());
        if (viewFile.exists()) {
            return viewFile;
        }
        return null;
    }

    public static View getView(String namespace, String actionName, String resultName, int type) {
        File viewFile;
        String viewId = namespace + "/" + actionName + "/" + resultName;
        View view = (View)viewCache.get(viewId);
        if (view == null && (viewFile = StrutsConfigRetriever.getViewFile(namespace, actionName, resultName)) != null) {
            switch (type) {
                case 0: {
                    view = new JspView(viewFile);
                    break;
                }
                case 2: {
                    view = new FreeMarkerView(viewFile);
                    break;
                }
                case 1: {
                    view = new VelocityView(viewFile);
                    break;
                }
                default: {
                    return null;
                }
            }
            viewCache.put(viewId, view);
        }
        return view;
    }

    public static void setConfiguration(String configDir, String[] views) {
        StrutsConfigRetriever.configDir = configDir;
        StrutsConfigRetriever.views = views;
        isXWorkStarted = false;
        viewCache = new LinkedHashMap();
    }

    static {
        isXWorkStarted = false;
        viewCache = new LinkedHashMap();
    }
}

