/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.sitegraph.entities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.sitegraph.entities.Target;
import org.apache.struts2.sitegraph.entities.View;

public abstract class FileBasedView
implements View {
    private String name;
    private String contents;
    private static final Log log = LogFactory.getLog(FileBasedView.class);

    public FileBasedView(File file) {
        this.name = file.getName();
        this.contents = this.readFile(file).replaceAll("[\r\n ]+", " ");
    }

    public String getName() {
        return this.name;
    }

    public Set getTargets() {
        TreeSet targets = new TreeSet();
        this.matchPatterns(this.getLinkPattern(), targets, 2);
        this.matchPatterns(this.getActionPattern(), targets, 1);
        this.matchPatterns(this.getFormPattern(), targets, 0);
        return targets;
    }

    protected Pattern getLinkPattern() {
        String ext = "action";
        String actionRegex = "([A-Za-z0-9\\._\\-\\!]+\\." + ext + ")";
        return Pattern.compile(actionRegex);
    }

    private void matchPatterns(Pattern pattern, Set targets, int type) {
        Matcher matcher = pattern.matcher(this.contents);
        while (matcher.find()) {
            String target = matcher.group(1);
            targets.add(new Target(target, type));
        }
    }

    protected abstract Pattern getActionPattern();

    protected abstract Pattern getFormPattern();

    protected String readFile(File file) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String s = new String();
            StringBuffer buffer = new StringBuffer();
            while ((s = in.readLine()) != null) {
                buffer.append(s + "\n");
            }
            in.close();
            return buffer.toString();
        }
        catch (FileNotFoundException e) {
            log.warn((Object)"File not found");
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return null;
    }
}

