/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.sitegraph.model;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.struts2.sitegraph.model.IndentWriter;
import org.apache.struts2.sitegraph.model.Link;
import org.apache.struts2.sitegraph.model.SiteGraphNode;
import org.apache.struts2.sitegraph.model.SubGraph;

public class Graph
extends SubGraph {
    private Set links = new TreeSet();
    public static Map nodeMap = new LinkedHashMap();

    public Graph() {
        super("");
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

    public void render(IndentWriter writer) throws IOException {
        writer.write("digraph mygraph {", true);
        writer.write("fontsize=10;");
        writer.write("fontname=helvetica;");
        writer.write("node [fontsize=10, fontname=helvetica, style=filled, shape=rectangle]");
        writer.write("edge [fontsize=10, fontname=helvetica]");
        for (SubGraph subGraph : this.subGraphs) {
            subGraph.render(new IndentWriter(writer));
        }
        for (SiteGraphNode siteGraphNode : this.nodes) {
            siteGraphNode.render(writer);
        }
        for (Link link : this.links) {
            link.render(writer);
        }
        writer.write("}", true);
    }

    public SiteGraphNode findNode(String location, SiteGraphNode ref) {
        if (location.startsWith("/")) {
            location = location.substring(1);
        } else {
            String prefix = null;
            if (ref.getParent() != null) {
                prefix = ref.getParent().getPrefix();
                location = prefix + "_" + location;
            }
        }
        location = location.replaceAll("[\\.\\/\\-\\$\\{\\}]", "_");
        return (SiteGraphNode)nodeMap.get(location);
    }
}

