/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.sitegraph.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.struts2.sitegraph.model.Graph;
import org.apache.struts2.sitegraph.model.IndentWriter;
import org.apache.struts2.sitegraph.model.Render;
import org.apache.struts2.sitegraph.model.SiteGraphNode;

public class SubGraph
implements Render {
    protected String name;
    protected SubGraph parent;
    protected List subGraphs;
    protected List nodes;

    public SubGraph(String name) {
        this.name = name;
        this.subGraphs = new ArrayList();
        this.nodes = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public void addSubGraph(SubGraph subGraph) {
        subGraph.setParent(this);
        this.subGraphs.add(subGraph);
    }

    public void setParent(SubGraph parent) {
        this.parent = parent;
    }

    public void addNode(SiteGraphNode node) {
        node.setParent(this);
        Graph.nodeMap.put(node.getFullName(), node);
        this.nodes.add(node);
    }

    public void render(IndentWriter writer) throws IOException {
        writer.write("subgraph cluster_" + this.getPrefix() + " {", true);
        writer.write("color=grey;");
        writer.write("fontcolor=grey;");
        writer.write("label=\"" + this.name + "\";");
        for (SubGraph subGraph : this.subGraphs) {
            subGraph.render(new IndentWriter(writer));
        }
        for (SiteGraphNode siteGraphNode : this.nodes) {
            siteGraphNode.render(writer);
        }
        writer.write("}", true);
    }

    public String getPrefix() {
        if (this.parent == null) {
            return this.name;
        }
        String prefix = this.parent.getPrefix();
        if (prefix.equals("")) {
            return this.name;
        }
        return prefix + "_" + this.name;
    }

    public SubGraph create(String namespace) {
        if (namespace.equals("")) {
            return this;
        }
        String[] parts = namespace.split("\\/");
        SubGraph last = this;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.equals("")) continue;
            SubGraph subGraph = this.findSubGraph(part);
            if (subGraph == null) {
                subGraph = new SubGraph(part);
                last.addSubGraph(subGraph);
            }
            last = subGraph;
        }
        return last;
    }

    private SubGraph findSubGraph(String name) {
        for (SubGraph subGraph : this.subGraphs) {
            if (!subGraph.getName().equals(name)) continue;
            return subGraph;
        }
        return null;
    }
}

