/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.portlet.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletRequest;
import org.apache.tiles.context.MapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PortletRequestScopeMap
implements Map<String, Object> {
    private PortletRequest request = null;

    public PortletRequestScopeMap(PortletRequest request) {
        this.request = request;
    }

    @Override
    public void clear() {
        Iterator<String> keys = this.keySet().iterator();
        while (keys.hasNext()) {
            this.request.removeAttribute(keys.next());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.request.getAttribute(this.key(key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        Enumeration keys = this.request.getAttributeNames();
        while (keys.hasMoreElements()) {
            Object next = this.request.getAttribute((String)keys.nextElement());
            if (next != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> set = new HashSet<Map.Entry<String, Object>>();
        Enumeration keys = this.request.getAttributeNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            set.add(new MapEntry<String, Object>(key, this.request.getAttribute(key), true));
        }
        return set;
    }

    @Override
    public boolean equals(Object o) {
        return this.request.equals(o);
    }

    @Override
    public Object get(Object key) {
        return this.request.getAttribute(this.key(key));
    }

    @Override
    public int hashCode() {
        return this.request.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        Enumeration keys = this.request.getAttributeNames();
        while (keys.hasMoreElements()) {
            set.add((String)keys.nextElement());
        }
        return set;
    }

    @Override
    public Object put(String key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        String skey = this.key(key);
        Object previous = this.request.getAttribute(skey);
        this.request.setAttribute(skey, value);
        return previous;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        for (String string : map.keySet()) {
            this.request.setAttribute(string, map.get(string));
        }
    }

    @Override
    public Object remove(Object key) {
        String skey = this.key(key);
        Object previous = this.request.getAttribute(skey);
        this.request.removeAttribute(skey);
        return previous;
    }

    @Override
    public int size() {
        int n = 0;
        Enumeration keys = this.request.getAttributeNames();
        while (keys.hasMoreElements()) {
            keys.nextElement();
            ++n;
        }
        return n;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> list = new ArrayList<Object>();
        Enumeration keys = this.request.getAttributeNames();
        while (keys.hasMoreElements()) {
            list.add(this.request.getAttribute((String)keys.nextElement()));
        }
        return list;
    }

    private String key(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key instanceof String) {
            return (String)key;
        }
        return key.toString();
    }
}

