/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.jasperreports;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.TextUtils;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.StrutsResultSupport;
import org.apache.struts2.views.jasperreports.JasperReportConstants;
import org.apache.struts2.views.jasperreports.ValueStackDataSource;
import org.apache.struts2.views.jasperreports.ValueStackShadowMap;

public class JasperReportsResult
extends StrutsResultSupport
implements JasperReportConstants {
    private static final long serialVersionUID = -2523174799621182907L;
    private static final Log LOG = LogFactory.getLog(JasperReportsResult.class);
    protected String dataSource;
    protected String format;
    protected String documentName;
    protected String contentDisposition;
    protected String delimiter;
    protected String imageServletUrl = "/images/";

    public JasperReportsResult() {
    }

    public JasperReportsResult(String location) {
        super(location);
    }

    public String getImageServletUrl() {
        return this.imageServletUrl;
    }

    public JasperReportsResult setImageServletUrl(String imageServletUrl) {
        this.imageServletUrl = imageServletUrl;
        return this;
    }

    public JasperReportsResult setDataSource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public JasperReportsResult setFormat(String format) {
        this.format = format;
        return this;
    }

    public JasperReportsResult setDocumentName(String documentName) {
        this.documentName = documentName;
        return this;
    }

    public JasperReportsResult setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public JasperReportsResult setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        if (this.format == null) {
            this.format = "PDF";
        }
        if (this.dataSource == null) {
            String message = "No dataSource specified...";
            LOG.error((Object)message);
            throw new RuntimeException(message);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating JasperReport for dataSource = " + this.dataSource + ", format = " + this.format));
        }
        HttpServletRequest request = (HttpServletRequest)invocation.getInvocationContext().get((Object)"com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)invocation.getInvocationContext().get((Object)"com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        ValueStack stack = invocation.getStack();
        ValueStackDataSource stackDataSource = new ValueStackDataSource(stack, this.dataSource);
        this.format = this.conditionalParse(this.format, invocation);
        this.dataSource = this.conditionalParse(this.dataSource, invocation);
        if (this.contentDisposition != null) {
            this.contentDisposition = this.conditionalParse(this.contentDisposition, invocation);
        }
        if (this.documentName != null) {
            this.documentName = this.conditionalParse(this.documentName, invocation);
        }
        if (!TextUtils.stringSet((String)this.format)) {
            this.format = "PDF";
        }
        if (!"contype".equals(request.getHeader("User-Agent"))) {
            byte[] output;
            JasperPrint jasperPrint;
            ServletContext servletContext = (ServletContext)invocation.getInvocationContext().get((Object)"com.opensymphony.xwork2.dispatcher.ServletContext");
            String systemId = servletContext.getRealPath(finalLocation);
            ValueStackShadowMap parameters = new ValueStackShadowMap(stack);
            File directory = new File(systemId.substring(0, systemId.lastIndexOf(File.separator)));
            parameters.put("reportDirectory", directory);
            parameters.put("REPORT_LOCALE", invocation.getInvocationContext().getLocale());
            try {
                JasperReport jasperReport = (JasperReport)JRLoader.loadObject((String)systemId);
                jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)parameters, (JRDataSource)stackDataSource);
            }
            catch (JRException e) {
                LOG.error((Object)("Error building report for uri " + systemId), (Throwable)e);
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            try {
                if (this.contentDisposition != null || this.documentName != null) {
                    StringBuffer tmp = new StringBuffer();
                    tmp.append(this.contentDisposition == null ? "inline" : this.contentDisposition);
                    if (this.documentName != null) {
                        tmp.append("; filename=");
                        tmp.append(this.documentName);
                        tmp.append(".");
                        tmp.append(this.format.toLowerCase());
                    }
                    response.setHeader("Content-disposition", tmp.toString());
                }
                if (this.format.equals("PDF")) {
                    response.setContentType("application/pdf");
                    output = JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
                } else {
                    JRCsvExporter exporter;
                    if (this.format.equals("CSV")) {
                        response.setContentType("text/plain");
                        exporter = new JRCsvExporter();
                    } else if (this.format.equals("HTML")) {
                        response.setContentType("text/html");
                        HashMap imagesMap = new HashMap();
                        request.getSession(true).setAttribute("IMAGES_MAP", imagesMap);
                        exporter = new JRHtmlExporter();
                        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, imagesMap);
                        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)(request.getContextPath() + this.imageServletUrl));
                        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                        request.getSession().setAttribute("net.sf.jasperreports.j2ee.jasper_print", (Object)jasperPrint);
                    } else if (this.format.equals("XLS")) {
                        response.setContentType("application/vnd.ms-excel");
                        exporter = new JRXlsExporter();
                    } else if (this.format.equals("XML")) {
                        response.setContentType("text/xml");
                        exporter = new JRXmlExporter();
                    } else if (this.format.equals("RTF")) {
                        response.setContentType("application/rtf");
                        exporter = new JRRtfExporter();
                    } else {
                        throw new ServletException("Unknown report format: " + this.format);
                    }
                    output = this.exportReportToBytes(jasperPrint, (JRExporter)exporter);
                }
            }
            catch (JRException e) {
                String message = "Error producing " + this.format + " report for uri " + systemId;
                LOG.error((Object)message, (Throwable)e);
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            response.setContentLength(output.length);
            try {
                ServletOutputStream ouputStream = response.getOutputStream();
                ouputStream.write(output);
                ouputStream.flush();
                ouputStream.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Error writing report output", (Throwable)e);
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            response.setContentType("application/pdf");
            response.setContentLength(0);
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Error writing report output", (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    private byte[] exportReportToBytes(JasperPrint jasperPrint, JRExporter exporter) throws JRException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
        if (this.delimiter != null) {
            exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)this.delimiter);
        }
        exporter.exportReport();
        byte[] output = baos.toByteArray();
        return output;
    }
}

