/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.jasperreports;

import com.opensymphony.xwork2.util.ValueStack;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.util.MakeIterator;

public class ValueStackDataSource
implements JRDataSource {
    private static Log log = LogFactory.getLog(ValueStackDataSource.class);
    Iterator iterator;
    ValueStack valueStack;
    boolean firstTimeThrough = true;

    public ValueStackDataSource(ValueStack valueStack, String dataSource) {
        this.valueStack = valueStack;
        Object dataSourceValue = valueStack.findValue(dataSource);
        if (dataSourceValue != null) {
            if (MakeIterator.isIterable((Object)dataSourceValue)) {
                this.iterator = MakeIterator.convert((Object)dataSourceValue);
            } else {
                Object[] array = new Object[]{dataSourceValue};
                this.iterator = MakeIterator.convert((Object)array);
            }
        } else {
            log.warn((Object)("Data source value for data source " + dataSource + " was null"));
        }
    }

    public Object getFieldValue(JRField field) throws JRException {
        String expression = field.getDescription();
        if (expression == null) {
            expression = field.getName();
        }
        Object value = this.valueStack.findValue(expression);
        if (log.isDebugEnabled()) {
            log.debug((Object)("field: " + field.getName() + "/" + value));
        }
        if (MakeIterator.isIterable((Object)value)) {
            return new ValueStackDataSource(this.valueStack, expression);
        }
        return value;
    }

    public boolean next() throws JRException {
        if (this.firstTimeThrough) {
            this.firstTimeThrough = false;
        } else {
            this.valueStack.pop();
        }
        if (this.iterator != null && this.iterator.hasNext()) {
            this.valueStack.push(this.iterator.next());
            log.debug((Object)("Pushed next value: " + this.valueStack.findValue(".")));
            return true;
        }
        log.debug((Object)"No more values");
        return false;
    }
}

