/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components.template;

import com.opensymphony.xwork2.util.ClassLoaderUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.components.template.Template;
import org.apache.struts2.components.template.TemplateEngine;

public abstract class BaseTemplateEngine
implements TemplateEngine {
    private static final Log LOG = LogFactory.getLog(BaseTemplateEngine.class);
    public static final String DEFAULT_THEME_PROPERTIES_FILE_NAME = "theme.properties";
    final Map<String, Properties> themeProps = new HashMap<String, Properties>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getThemeProps(Template template) {
        Map<String, Properties> map = this.themeProps;
        synchronized (map) {
            Properties props = this.themeProps.get(template.getTheme());
            if (props == null) {
                String propName = template.getDir() + "/" + template.getTheme() + "/" + this.getThemePropertiesFileName();
                File propFile = new File(propName);
                InputStream is = null;
                try {
                    if (propFile.exists()) {
                        is = new FileInputStream(propFile);
                    }
                }
                catch (FileNotFoundException e) {
                    LOG.warn((Object)("Unable to find file in filesystem [" + propFile.getAbsolutePath() + "]"));
                }
                if (is == null) {
                    is = ClassLoaderUtil.getResourceAsStream((String)propName, this.getClass());
                }
                props = new Properties();
                if (is != null) {
                    try {
                        props.load(is);
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Could not load " + propName), (Throwable)e);
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException io) {
                            LOG.warn((Object)"Unable to close input stream", (Throwable)io);
                        }
                    }
                }
                this.themeProps.put(template.getTheme(), props);
            }
            return props;
        }
    }

    protected String getFinalTemplateName(Template template) {
        String t = template.toString();
        if (t.indexOf(".") <= 0) {
            return t + "." + this.getSuffix();
        }
        return t;
    }

    protected String getThemePropertiesFileName() {
        return DEFAULT_THEME_PROPERTIES_FILE_NAME;
    }

    protected abstract String getSuffix();
}

