/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.util;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class UrlHelper {
    private static final Log LOG = LogFactory.getLog(UrlHelper.class);
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String AMP = "&amp;";
    private static int httpPort = 80;
    private static int httpsPort = 443;
    private static String customEncoding;

    @Inject(value="struts.url.http.port")
    public static void setHttpPort(String val) {
        httpPort = Integer.parseInt(val);
    }

    @Inject(value="struts.url.https.port")
    public static void setHttpsPort(String val) {
        httpsPort = Integer.parseInt(val);
    }

    @Inject(value="struts.i18n.encoding")
    public static void setCustomEncoding(String val) {
        customEncoding = val;
    }

    public static String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map params) {
        return UrlHelper.buildUrl(action, request, response, params, null, true, true);
    }

    public static String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map params, String scheme, boolean includeContext, boolean encodeResult) {
        return UrlHelper.buildUrl(action, request, response, params, scheme, includeContext, encodeResult, false);
    }

    public static String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map params, String scheme, boolean includeContext, boolean encodeResult, boolean forceAddSchemeHostAndPort) {
        return UrlHelper.buildUrl(action, request, response, params, scheme, includeContext, encodeResult, forceAddSchemeHostAndPort, true);
    }

    public static String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map params, String scheme, boolean includeContext, boolean encodeResult, boolean forceAddSchemeHostAndPort, boolean escapeAmp) {
        StringBuffer link = new StringBuffer();
        boolean changedScheme = false;
        if (forceAddSchemeHostAndPort) {
            String reqScheme = request.getScheme();
            changedScheme = true;
            link.append(scheme != null ? scheme : reqScheme);
            link.append("://");
            link.append(request.getServerName());
            if (scheme != null) {
                if (!scheme.equals(reqScheme)) {
                    if (scheme.equals("http") && httpPort != 80 || scheme.equals("https") && httpsPort != 443) {
                        link.append(":");
                        link.append(scheme.equals("http") ? httpPort : httpsPort);
                    }
                } else {
                    int reqPort = request.getServerPort();
                    if (scheme.equals("http") && reqPort != 80 || scheme.equals("https") && reqPort != 443) {
                        link.append(":");
                        link.append(reqPort);
                    }
                }
            }
        } else if (scheme != null && !scheme.equals(request.getScheme())) {
            changedScheme = true;
            link.append(scheme);
            link.append("://");
            link.append(request.getServerName());
            if (scheme.equals("http") && httpPort != 80 || scheme.equals("https") && httpsPort != 443) {
                link.append(":");
                link.append(scheme.equals("http") ? httpPort : httpsPort);
            }
        }
        if (action != null) {
            if (action.startsWith("/") && includeContext) {
                String contextPath = request.getContextPath();
                if (!contextPath.equals("/")) {
                    link.append(contextPath);
                }
            } else if (changedScheme) {
                String uri = (String)request.getAttribute("javax.servlet.forward.request_uri");
                if (uri == null) {
                    uri = request.getRequestURI();
                }
                link.append(uri.substring(0, uri.lastIndexOf(47) + 1));
            }
            link.append(action);
        } else {
            String requestURI = (String)request.getAttribute("struts.request_uri");
            if (requestURI == null) {
                requestURI = (String)request.getAttribute("javax.servlet.forward.request_uri");
            }
            if (requestURI == null) {
                requestURI = request.getRequestURI();
            }
            link.append(requestURI);
        }
        if (escapeAmp) {
            UrlHelper.buildParametersString(params, link);
        } else {
            UrlHelper.buildParametersString(params, link, "&");
        }
        String result = link.toString();
        while (result.indexOf("<script>") > 0) {
            result = result.replaceAll("<script>", "script");
        }
        try {
            result = encodeResult ? response.encodeURL(result) : result;
        }
        catch (Exception ex) {
            result = link.toString();
        }
        return result;
    }

    public static void buildParametersString(Map params, StringBuffer link) {
        UrlHelper.buildParametersString(params, link, AMP);
    }

    public static void buildParametersString(Map params, StringBuffer link, String paramSeparator) {
        if (params != null && params.size() > 0) {
            if (link.toString().indexOf("?") == -1) {
                link.append("?");
            } else {
                link.append(paramSeparator);
            }
            Iterator iter = params.entrySet().iterator();
            String[] valueHolder = new String[1];
            while (iter.hasNext()) {
                String[] values;
                Map.Entry entry = iter.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String[]) {
                    values = (String[])value;
                } else {
                    valueHolder[0] = value.toString();
                    values = valueHolder;
                }
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] != null) {
                        link.append(name);
                        link.append('=');
                        link.append(UrlHelper.translateAndEncode(values[i]));
                    }
                    if (i >= values.length - 1) continue;
                    link.append(paramSeparator);
                }
                if (!iter.hasNext()) continue;
                link.append(paramSeparator);
            }
        }
    }

    public static String translateAndEncode(String input) {
        String translatedInput = UrlHelper.translateVariable(input);
        String encoding = UrlHelper.getEncodingFromConfiguration();
        try {
            return URLEncoder.encode(translatedInput, encoding);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Could not encode URL parameter '" + input + "', returning value un-encoded"));
            return translatedInput;
        }
    }

    public static String translateAndDecode(String input) {
        String translatedInput = UrlHelper.translateVariable(input);
        String encoding = UrlHelper.getEncodingFromConfiguration();
        try {
            return URLDecoder.decode(translatedInput, encoding);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Could not encode URL parameter '" + input + "', returning value un-encoded"));
            return translatedInput;
        }
    }

    private static String translateVariable(String input) {
        ValueStack valueStack = ServletActionContext.getContext().getValueStack();
        String output = TextParseUtil.translateVariables((String)input, (ValueStack)valueStack);
        return output;
    }

    private static String getEncodingFromConfiguration() {
        String encoding = customEncoding != null ? customEncoding : "UTF-8";
        return encoding;
    }

    public static Map parseQueryString(String queryString) {
        LinkedHashMap<String, Object> queryParams = new LinkedHashMap<String, Object>();
        if (queryString != null) {
            String[] params = queryString.split("&");
            for (int a = 0; a < params.length; ++a) {
                if (params[a].trim().length() <= 0) continue;
                String[] tmpParams = params[a].split("=");
                String paramName = null;
                String paramValue = "";
                if (tmpParams.length > 0) {
                    paramName = tmpParams[0];
                }
                if (tmpParams.length > 1) {
                    paramValue = tmpParams[1];
                }
                if (paramName == null) continue;
                String translatedParamValue = UrlHelper.translateAndDecode(paramValue);
                if (queryParams.containsKey(paramName)) {
                    Object currentParam = queryParams.get(paramName);
                    if (currentParam instanceof String) {
                        queryParams.put(paramName, new String[]{(String)currentParam, translatedParamValue});
                        continue;
                    }
                    String[] currentParamValues = (String[])currentParam;
                    ArrayList<String> paramList = new ArrayList<String>(Arrays.asList(currentParamValues));
                    paramList.add(translatedParamValue);
                    String[] newParamValues = new String[paramList.size()];
                    queryParams.put(paramName, paramList.toArray(newParamValues));
                    continue;
                }
                queryParams.put(paramName, translatedParamValue);
            }
        }
        return queryParams;
    }
}

