/*
 *	Program type:   Embedded Static SQL
 *
 *	Description:
 *		This program performs a simple update to an existing
 *		table, asks the user whether to save the update, and
 *		commits or undoes the transaction accordingly.
 */

#include "example.h"
#include <stdio.h>
#include <stdlib.h>

int do_save PROTO((void));
void clean_up PROTO((void));

EXEC SQL	
	BEGIN DECLARE SECTION;
EXEC SQL	
	END DECLARE SECTION;


int main PROTO((void))
{
	clean_up();

	/* Insert a new row. */
	EXEC SQL
		INSERT INTO country (country, currency)
		VALUES ('Mexico', 'Peso');

	/* Check the SQLCODE directly */
	if (SQLCODE)
	{
		isc_print_sqlerror((short)SQLCODE, gds__status);
		exit(1);
	}

	printf("\nAdding:  country = 'Mexico', currency = 'Peso'\n\n");

	/* Confirm whether to commit the update. */
	if (do_save())
	{
		EXEC SQL
			COMMIT RELEASE;
		printf("\nSAVED.\n\n");
	}
	else
	{
		EXEC SQL
			ROLLBACK RELEASE;
		printf("\nUNDONE.\n\n");
	}
return 0;
}


/*
 *	Ask the user whether to save the newly added row.
 */
int do_save PROTO((void))
{
	char	answer[10];

	printf("Save?  Enter 'y' for yes, 'n' for no:  ");
	gets(answer);

	return (*answer == 'y' ? 1 : 0);
}


/*
 *	If this is not the first time this program is run,
 *	the example row may already exist -- delete the example
 *	row in order to avoid a duplicate value error.
 */
void clean_up PROTO((void))
{
	EXEC SQL
		DELETE FROM country
		WHERE country =  'Mexico';

	EXEC SQL
		COMMIT WORK;
}
