/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.graphics;

import android.graphics.Color;
import android.support.v4.graphics.ColorUtils;
import android.support.v7.graphics.Palette;
import android.util.TimingLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

final class ColorCutQuantizer {
    private static final String LOG_TAG = "ColorCutQuantizer";
    private static final boolean LOG_TIMINGS = false;
    private static final int COMPONENT_RED = -3;
    private static final int COMPONENT_GREEN = -2;
    private static final int COMPONENT_BLUE = -1;
    private static final int QUANTIZE_WORD_WIDTH = 5;
    private static final int QUANTIZE_WORD_MASK = 31;
    final int[] mColors;
    final int[] mHistogram;
    final List<Palette.Swatch> mQuantizedColors;
    final TimingLogger mTimingLogger = null;
    final Palette.Filter[] mFilters;
    private final float[] mTempHsl = new float[3];
    private static final Comparator<Vbox> VBOX_COMPARATOR_VOLUME = new Comparator<Vbox>(){

        @Override
        public int compare(Vbox lhs, Vbox rhs) {
            return rhs.getVolume() - lhs.getVolume();
        }
    };

    ColorCutQuantizer(int[] pixels, int maxColors, Palette.Filter[] filters) {
        this.mFilters = filters;
        this.mHistogram = new int[32768];
        int[] hist = this.mHistogram;
        for (int i = 0; i < pixels.length; ++i) {
            int quantizedColor;
            pixels[i] = quantizedColor = ColorCutQuantizer.quantizeFromRgb888(pixels[i]);
            int n = quantizedColor;
            hist[n] = hist[n] + 1;
        }
        int distinctColorCount = 0;
        for (int color = 0; color < hist.length; ++color) {
            if (hist[color] > 0 && this.shouldIgnoreColor(color)) {
                hist[color] = 0;
            }
            if (hist[color] <= 0) continue;
            ++distinctColorCount;
        }
        this.mColors = new int[distinctColorCount];
        int[] colors = this.mColors;
        int distinctColorIndex = 0;
        for (int color = 0; color < hist.length; ++color) {
            if (hist[color] <= 0) continue;
            colors[distinctColorIndex++] = color;
        }
        if (distinctColorCount <= maxColors) {
            this.mQuantizedColors = new ArrayList<Palette.Swatch>();
            for (int color : colors) {
                this.mQuantizedColors.add(new Palette.Swatch(ColorCutQuantizer.approximateToRgb888(color), hist[color]));
            }
        } else {
            this.mQuantizedColors = this.quantizePixels(maxColors);
        }
    }

    List<Palette.Swatch> getQuantizedColors() {
        return this.mQuantizedColors;
    }

    private List<Palette.Swatch> quantizePixels(int maxColors) {
        PriorityQueue<Vbox> pq = new PriorityQueue<Vbox>(maxColors, VBOX_COMPARATOR_VOLUME);
        pq.offer(new Vbox(0, this.mColors.length - 1));
        this.splitBoxes(pq, maxColors);
        return this.generateAverageColors(pq);
    }

    private void splitBoxes(PriorityQueue<Vbox> queue, int maxSize) {
        while (queue.size() < maxSize) {
            Vbox vbox = queue.poll();
            if (vbox != null && vbox.canSplit()) {
                queue.offer(vbox.splitBox());
                queue.offer(vbox);
                continue;
            }
            return;
        }
    }

    private List<Palette.Swatch> generateAverageColors(Collection<Vbox> vboxes) {
        ArrayList<Palette.Swatch> colors = new ArrayList<Palette.Swatch>(vboxes.size());
        for (Vbox vbox : vboxes) {
            Palette.Swatch swatch = vbox.getAverageColor();
            if (this.shouldIgnoreColor(swatch)) continue;
            colors.add(swatch);
        }
        return colors;
    }

    private static void modifySignificantOctet(int[] a, int dimension, int lower, int upper) {
        switch (dimension) {
            case -3: {
                break;
            }
            case -2: {
                for (int i = lower; i <= upper; ++i) {
                    int color = a[i];
                    a[i] = ColorCutQuantizer.quantizedGreen(color) << 10 | ColorCutQuantizer.quantizedRed(color) << 5 | ColorCutQuantizer.quantizedBlue(color);
                }
                break;
            }
            case -1: {
                for (int i = lower; i <= upper; ++i) {
                    int color = a[i];
                    a[i] = ColorCutQuantizer.quantizedBlue(color) << 10 | ColorCutQuantizer.quantizedGreen(color) << 5 | ColorCutQuantizer.quantizedRed(color);
                }
                break;
            }
        }
    }

    private boolean shouldIgnoreColor(int color565) {
        int rgb = ColorCutQuantizer.approximateToRgb888(color565);
        ColorUtils.colorToHSL((int)rgb, (float[])this.mTempHsl);
        return this.shouldIgnoreColor(rgb, this.mTempHsl);
    }

    private boolean shouldIgnoreColor(Palette.Swatch color) {
        return this.shouldIgnoreColor(color.getRgb(), color.getHsl());
    }

    private boolean shouldIgnoreColor(int rgb, float[] hsl) {
        if (this.mFilters != null && this.mFilters.length > 0) {
            int count = this.mFilters.length;
            for (int i = 0; i < count; ++i) {
                if (this.mFilters[i].isAllowed(rgb, hsl)) continue;
                return true;
            }
        }
        return false;
    }

    private static int quantizeFromRgb888(int color) {
        int r = ColorCutQuantizer.modifyWordWidth(Color.red((int)color), 8, 5);
        int g = ColorCutQuantizer.modifyWordWidth(Color.green((int)color), 8, 5);
        int b = ColorCutQuantizer.modifyWordWidth(Color.blue((int)color), 8, 5);
        return r << 10 | g << 5 | b;
    }

    private static int approximateToRgb888(int r, int g, int b) {
        return Color.rgb((int)ColorCutQuantizer.modifyWordWidth(r, 5, 8), (int)ColorCutQuantizer.modifyWordWidth(g, 5, 8), (int)ColorCutQuantizer.modifyWordWidth(b, 5, 8));
    }

    private static int approximateToRgb888(int color) {
        return ColorCutQuantizer.approximateToRgb888(ColorCutQuantizer.quantizedRed(color), ColorCutQuantizer.quantizedGreen(color), ColorCutQuantizer.quantizedBlue(color));
    }

    private static int quantizedRed(int color) {
        return color >> 10 & 0x1F;
    }

    private static int quantizedGreen(int color) {
        return color >> 5 & 0x1F;
    }

    private static int quantizedBlue(int color) {
        return color & 0x1F;
    }

    private static int modifyWordWidth(int value, int currentWidth, int targetWidth) {
        int newValue = targetWidth > currentWidth ? value << targetWidth - currentWidth : value >> currentWidth - targetWidth;
        return newValue & (1 << targetWidth) - 1;
    }

    private class Vbox {
        private int mLowerIndex;
        private int mUpperIndex;
        private int mPopulation;
        private int mMinRed;
        private int mMaxRed;
        private int mMinGreen;
        private int mMaxGreen;
        private int mMinBlue;
        private int mMaxBlue;

        Vbox(int lowerIndex, int upperIndex) {
            this.mLowerIndex = lowerIndex;
            this.mUpperIndex = upperIndex;
            this.fitBox();
        }

        final int getVolume() {
            return (this.mMaxRed - this.mMinRed + 1) * (this.mMaxGreen - this.mMinGreen + 1) * (this.mMaxBlue - this.mMinBlue + 1);
        }

        final boolean canSplit() {
            return this.getColorCount() > 1;
        }

        final int getColorCount() {
            return 1 + this.mUpperIndex - this.mLowerIndex;
        }

        final void fitBox() {
            int[] colors = ColorCutQuantizer.this.mColors;
            int[] hist = ColorCutQuantizer.this.mHistogram;
            int minBlue = Integer.MAX_VALUE;
            int minGreen = Integer.MAX_VALUE;
            int minRed = Integer.MAX_VALUE;
            int maxBlue = Integer.MIN_VALUE;
            int maxGreen = Integer.MIN_VALUE;
            int maxRed = Integer.MIN_VALUE;
            int count = 0;
            for (int i = this.mLowerIndex; i <= this.mUpperIndex; ++i) {
                int color = colors[i];
                count += hist[color];
                int r = ColorCutQuantizer.quantizedRed(color);
                int g = ColorCutQuantizer.quantizedGreen(color);
                int b = ColorCutQuantizer.quantizedBlue(color);
                if (r > maxRed) {
                    maxRed = r;
                }
                if (r < minRed) {
                    minRed = r;
                }
                if (g > maxGreen) {
                    maxGreen = g;
                }
                if (g < minGreen) {
                    minGreen = g;
                }
                if (b > maxBlue) {
                    maxBlue = b;
                }
                if (b >= minBlue) continue;
                minBlue = b;
            }
            this.mMinRed = minRed;
            this.mMaxRed = maxRed;
            this.mMinGreen = minGreen;
            this.mMaxGreen = maxGreen;
            this.mMinBlue = minBlue;
            this.mMaxBlue = maxBlue;
            this.mPopulation = count;
        }

        final Vbox splitBox() {
            if (!this.canSplit()) {
                throw new IllegalStateException("Can not split a box with only 1 color");
            }
            int splitPoint = this.findSplitPoint();
            Vbox newBox = new Vbox(splitPoint + 1, this.mUpperIndex);
            this.mUpperIndex = splitPoint;
            this.fitBox();
            return newBox;
        }

        final int getLongestColorDimension() {
            int redLength = this.mMaxRed - this.mMinRed;
            int greenLength = this.mMaxGreen - this.mMinGreen;
            int blueLength = this.mMaxBlue - this.mMinBlue;
            if (redLength >= greenLength && redLength >= blueLength) {
                return -3;
            }
            if (greenLength >= redLength && greenLength >= blueLength) {
                return -2;
            }
            return -1;
        }

        final int findSplitPoint() {
            int longestDimension = this.getLongestColorDimension();
            int[] colors = ColorCutQuantizer.this.mColors;
            int[] hist = ColorCutQuantizer.this.mHistogram;
            ColorCutQuantizer.modifySignificantOctet(colors, longestDimension, this.mLowerIndex, this.mUpperIndex);
            Arrays.sort(colors, this.mLowerIndex, this.mUpperIndex + 1);
            ColorCutQuantizer.modifySignificantOctet(colors, longestDimension, this.mLowerIndex, this.mUpperIndex);
            int midPoint = this.mPopulation / 2;
            int count = 0;
            for (int i = this.mLowerIndex; i <= this.mUpperIndex; ++i) {
                if ((count += hist[colors[i]]) < midPoint) continue;
                return i;
            }
            return this.mLowerIndex;
        }

        final Palette.Swatch getAverageColor() {
            int[] colors = ColorCutQuantizer.this.mColors;
            int[] hist = ColorCutQuantizer.this.mHistogram;
            int redSum = 0;
            int greenSum = 0;
            int blueSum = 0;
            int totalPopulation = 0;
            for (int i = this.mLowerIndex; i <= this.mUpperIndex; ++i) {
                int color = colors[i];
                int colorPopulation = hist[color];
                totalPopulation += colorPopulation;
                redSum += colorPopulation * ColorCutQuantizer.quantizedRed(color);
                greenSum += colorPopulation * ColorCutQuantizer.quantizedGreen(color);
                blueSum += colorPopulation * ColorCutQuantizer.quantizedBlue(color);
            }
            int redMean = Math.round((float)redSum / (float)totalPopulation);
            int greenMean = Math.round((float)greenSum / (float)totalPopulation);
            int blueMean = Math.round((float)blueSum / (float)totalPopulation);
            return new Palette.Swatch(ColorCutQuantizer.approximateToRgb888(redMean, greenMean, blueMean), totalPopulation);
        }
    }
}

