/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.graphics;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.AsyncTask;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.os.AsyncTaskCompat;
import android.support.v7.graphics.ColorCutQuantizer;
import android.support.v7.graphics.DefaultGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Palette {
    private static final int DEFAULT_RESIZE_BITMAP_MAX_DIMENSION = 192;
    private static final int DEFAULT_CALCULATE_NUMBER_COLORS = 16;
    private static final float MIN_CONTRAST_TITLE_TEXT = 3.0f;
    private static final float MIN_CONTRAST_BODY_TEXT = 4.5f;
    private static final String LOG_TAG = "Palette";
    private static final boolean LOG_TIMINGS = false;
    private final List<Swatch> mSwatches;
    private final Generator mGenerator;
    private static final Filter DEFAULT_FILTER = new Filter(){
        private static final float BLACK_MAX_LIGHTNESS = 0.05f;
        private static final float WHITE_MIN_LIGHTNESS = 0.95f;

        @Override
        public boolean isAllowed(int rgb, float[] hsl) {
            return !this.isWhite(hsl) && !this.isBlack(hsl) && !this.isNearRedILine(hsl);
        }

        private boolean isBlack(float[] hslColor) {
            return hslColor[2] <= 0.05f;
        }

        private boolean isWhite(float[] hslColor) {
            return hslColor[2] >= 0.95f;
        }

        private boolean isNearRedILine(float[] hslColor) {
            return hslColor[0] >= 10.0f && hslColor[0] <= 37.0f && hslColor[1] <= 0.82f;
        }
    };

    public static Builder from(Bitmap bitmap) {
        return new Builder(bitmap);
    }

    public static Palette from(List<Swatch> swatches) {
        return new Builder(swatches).generate();
    }

    @Deprecated
    public static Palette generate(Bitmap bitmap) {
        return Palette.from(bitmap).generate();
    }

    @Deprecated
    public static Palette generate(Bitmap bitmap, int numColors) {
        return Palette.from(bitmap).maximumColorCount(numColors).generate();
    }

    @Deprecated
    public static AsyncTask<Bitmap, Void, Palette> generateAsync(Bitmap bitmap, PaletteAsyncListener listener) {
        return Palette.from(bitmap).generate(listener);
    }

    @Deprecated
    public static AsyncTask<Bitmap, Void, Palette> generateAsync(Bitmap bitmap, int numColors, PaletteAsyncListener listener) {
        return Palette.from(bitmap).maximumColorCount(numColors).generate(listener);
    }

    private Palette(List<Swatch> swatches, Generator generator) {
        this.mSwatches = swatches;
        this.mGenerator = generator;
    }

    public List<Swatch> getSwatches() {
        return Collections.unmodifiableList(this.mSwatches);
    }

    @Nullable
    public Swatch getVibrantSwatch() {
        return this.mGenerator.getVibrantSwatch();
    }

    @Nullable
    public Swatch getLightVibrantSwatch() {
        return this.mGenerator.getLightVibrantSwatch();
    }

    @Nullable
    public Swatch getDarkVibrantSwatch() {
        return this.mGenerator.getDarkVibrantSwatch();
    }

    @Nullable
    public Swatch getMutedSwatch() {
        return this.mGenerator.getMutedSwatch();
    }

    @Nullable
    public Swatch getLightMutedSwatch() {
        return this.mGenerator.getLightMutedSwatch();
    }

    @Nullable
    public Swatch getDarkMutedSwatch() {
        return this.mGenerator.getDarkMutedSwatch();
    }

    @ColorInt
    public int getVibrantColor(@ColorInt int defaultColor) {
        Swatch swatch = this.getVibrantSwatch();
        return swatch != null ? swatch.getRgb() : defaultColor;
    }

    @ColorInt
    public int getLightVibrantColor(@ColorInt int defaultColor) {
        Swatch swatch = this.getLightVibrantSwatch();
        return swatch != null ? swatch.getRgb() : defaultColor;
    }

    @ColorInt
    public int getDarkVibrantColor(@ColorInt int defaultColor) {
        Swatch swatch = this.getDarkVibrantSwatch();
        return swatch != null ? swatch.getRgb() : defaultColor;
    }

    @ColorInt
    public int getMutedColor(@ColorInt int defaultColor) {
        Swatch swatch = this.getMutedSwatch();
        return swatch != null ? swatch.getRgb() : defaultColor;
    }

    @ColorInt
    public int getLightMutedColor(@ColorInt int defaultColor) {
        Swatch swatch = this.getLightMutedSwatch();
        return swatch != null ? swatch.getRgb() : defaultColor;
    }

    @ColorInt
    public int getDarkMutedColor(@ColorInt int defaultColor) {
        Swatch swatch = this.getDarkMutedSwatch();
        return swatch != null ? swatch.getRgb() : defaultColor;
    }

    private static Bitmap scaleBitmapDown(Bitmap bitmap, int targetMaxDimension) {
        int maxDimension = Math.max(bitmap.getWidth(), bitmap.getHeight());
        if (maxDimension <= targetMaxDimension) {
            return bitmap;
        }
        float scaleRatio = (float)targetMaxDimension / (float)maxDimension;
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)Math.round((float)bitmap.getWidth() * scaleRatio), (int)Math.round((float)bitmap.getHeight() * scaleRatio), (boolean)false);
    }

    public static interface Filter {
        public boolean isAllowed(int var1, float[] var2);
    }

    static abstract class Generator {
        Generator() {
        }

        public abstract void generate(List<Swatch> var1);

        public Swatch getVibrantSwatch() {
            return null;
        }

        public Swatch getLightVibrantSwatch() {
            return null;
        }

        public Swatch getDarkVibrantSwatch() {
            return null;
        }

        public Swatch getMutedSwatch() {
            return null;
        }

        public Swatch getLightMutedSwatch() {
            return null;
        }

        public Swatch getDarkMutedSwatch() {
            return null;
        }
    }

    public static final class Builder {
        private List<Swatch> mSwatches;
        private Bitmap mBitmap;
        private int mMaxColors = 16;
        private int mResizeMaxDimension = 192;
        private final List<Filter> mFilters = new ArrayList<Filter>();
        private Generator mGenerator;

        public Builder(Bitmap bitmap) {
            this();
            if (bitmap == null || bitmap.isRecycled()) {
                throw new IllegalArgumentException("Bitmap is not valid");
            }
            this.mBitmap = bitmap;
        }

        public Builder(List<Swatch> swatches) {
            this();
            if (swatches == null || swatches.isEmpty()) {
                throw new IllegalArgumentException("List of Swatches is not valid");
            }
            this.mSwatches = swatches;
        }

        private Builder() {
            this.mFilters.add(DEFAULT_FILTER);
        }

        Builder generator(Generator generator) {
            this.mGenerator = generator;
            return this;
        }

        public Builder maximumColorCount(int colors) {
            this.mMaxColors = colors;
            return this;
        }

        public Builder resizeBitmapSize(int maxDimension) {
            this.mResizeMaxDimension = maxDimension;
            return this;
        }

        public Builder clearFilters() {
            this.mFilters.clear();
            return this;
        }

        public Builder addFilter(Filter filter) {
            if (filter != null) {
                this.mFilters.add(filter);
            }
            return this;
        }

        public Palette generate() {
            List<Swatch> swatches;
            Object logger = null;
            if (this.mBitmap != null) {
                if (this.mResizeMaxDimension <= 0) {
                    throw new IllegalArgumentException("Minimum dimension size for resizing should should be >= 1");
                }
                Bitmap scaledBitmap = Palette.scaleBitmapDown(this.mBitmap, this.mResizeMaxDimension);
                if (logger != null) {
                    logger.addSplit("Processed Bitmap");
                }
                int width = scaledBitmap.getWidth();
                int height = scaledBitmap.getHeight();
                int[] pixels = new int[width * height];
                scaledBitmap.getPixels(pixels, 0, width, 0, 0, width, height);
                ColorCutQuantizer quantizer = new ColorCutQuantizer(pixels, this.mMaxColors, this.mFilters.isEmpty() ? null : this.mFilters.toArray(new Filter[this.mFilters.size()]));
                if (scaledBitmap != this.mBitmap) {
                    scaledBitmap.recycle();
                }
                swatches = quantizer.getQuantizedColors();
                if (logger != null) {
                    logger.addSplit("Color quantization completed");
                }
            } else {
                swatches = this.mSwatches;
            }
            if (this.mGenerator == null) {
                this.mGenerator = new DefaultGenerator();
            }
            this.mGenerator.generate(swatches);
            if (logger != null) {
                logger.addSplit("Generator.generate() completed");
            }
            Palette p = new Palette(swatches, this.mGenerator);
            if (logger != null) {
                logger.addSplit("Created Palette");
                logger.dumpToLog();
            }
            return p;
        }

        public AsyncTask<Bitmap, Void, Palette> generate(final PaletteAsyncListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener can not be null");
            }
            return AsyncTaskCompat.executeParallel((AsyncTask)new AsyncTask<Bitmap, Void, Palette>(){

                protected Palette doInBackground(Bitmap ... params) {
                    return Builder.this.generate();
                }

                protected void onPostExecute(Palette colorExtractor) {
                    listener.onGenerated(colorExtractor);
                }
            }, (Object[])new Bitmap[]{this.mBitmap});
        }
    }

    public static final class Swatch {
        private final int mRed;
        private final int mGreen;
        private final int mBlue;
        private final int mRgb;
        private final int mPopulation;
        private boolean mGeneratedTextColors;
        private int mTitleTextColor;
        private int mBodyTextColor;
        private float[] mHsl;

        public Swatch(@ColorInt int color, int population) {
            this.mRed = Color.red((int)color);
            this.mGreen = Color.green((int)color);
            this.mBlue = Color.blue((int)color);
            this.mRgb = color;
            this.mPopulation = population;
        }

        Swatch(int red, int green, int blue, int population) {
            this.mRed = red;
            this.mGreen = green;
            this.mBlue = blue;
            this.mRgb = Color.rgb((int)red, (int)green, (int)blue);
            this.mPopulation = population;
        }

        @ColorInt
        public int getRgb() {
            return this.mRgb;
        }

        public float[] getHsl() {
            if (this.mHsl == null) {
                this.mHsl = new float[3];
                ColorUtils.RGBToHSL((int)this.mRed, (int)this.mGreen, (int)this.mBlue, (float[])this.mHsl);
            }
            return this.mHsl;
        }

        public int getPopulation() {
            return this.mPopulation;
        }

        @ColorInt
        public int getTitleTextColor() {
            this.ensureTextColorsGenerated();
            return this.mTitleTextColor;
        }

        @ColorInt
        public int getBodyTextColor() {
            this.ensureTextColorsGenerated();
            return this.mBodyTextColor;
        }

        private void ensureTextColorsGenerated() {
            if (!this.mGeneratedTextColors) {
                int lightBodyAlpha = ColorUtils.calculateMinimumAlpha((int)-1, (int)this.mRgb, (float)4.5f);
                int lightTitleAlpha = ColorUtils.calculateMinimumAlpha((int)-1, (int)this.mRgb, (float)3.0f);
                if (lightBodyAlpha != -1 && lightTitleAlpha != -1) {
                    this.mBodyTextColor = ColorUtils.setAlphaComponent((int)-1, (int)lightBodyAlpha);
                    this.mTitleTextColor = ColorUtils.setAlphaComponent((int)-1, (int)lightTitleAlpha);
                    this.mGeneratedTextColors = true;
                    return;
                }
                int darkBodyAlpha = ColorUtils.calculateMinimumAlpha((int)-16777216, (int)this.mRgb, (float)4.5f);
                int darkTitleAlpha = ColorUtils.calculateMinimumAlpha((int)-16777216, (int)this.mRgb, (float)3.0f);
                if (darkBodyAlpha != -1 && darkBodyAlpha != -1) {
                    this.mBodyTextColor = ColorUtils.setAlphaComponent((int)-16777216, (int)darkBodyAlpha);
                    this.mTitleTextColor = ColorUtils.setAlphaComponent((int)-16777216, (int)darkTitleAlpha);
                    this.mGeneratedTextColors = true;
                    return;
                }
                this.mBodyTextColor = lightBodyAlpha != -1 ? ColorUtils.setAlphaComponent((int)-1, (int)lightBodyAlpha) : ColorUtils.setAlphaComponent((int)-16777216, (int)darkBodyAlpha);
                this.mTitleTextColor = lightTitleAlpha != -1 ? ColorUtils.setAlphaComponent((int)-1, (int)lightTitleAlpha) : ColorUtils.setAlphaComponent((int)-16777216, (int)darkTitleAlpha);
                this.mGeneratedTextColors = true;
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [RGB: #" + Integer.toHexString(this.getRgb()) + ']' + " [HSL: " + Arrays.toString(this.getHsl()) + ']' + " [Population: " + this.mPopulation + ']' + " [Title Text: #" + Integer.toHexString(this.getTitleTextColor()) + ']' + " [Body Text: #" + Integer.toHexString(this.getBodyTextColor()) + ']';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Swatch swatch = (Swatch)o;
            return this.mPopulation == swatch.mPopulation && this.mRgb == swatch.mRgb;
        }

        public int hashCode() {
            return 31 * this.mRgb + this.mPopulation;
        }
    }

    public static interface PaletteAsyncListener {
        public void onGenerated(Palette var1);
    }
}

