/*
 * Decompiled with CFR 0.152.
 */
package android.support.percent;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.percent.R;
import android.support.v4.view.MarginLayoutParamsCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;

public class PercentLayoutHelper {
    private static final String TAG = "PercentLayout";
    private final ViewGroup mHost;

    public PercentLayoutHelper(ViewGroup host) {
        this.mHost = host;
    }

    public static void fetchWidthAndHeight(ViewGroup.LayoutParams params, TypedArray array, int widthAttr, int heightAttr) {
        params.width = array.getLayoutDimension(widthAttr, 0);
        params.height = array.getLayoutDimension(heightAttr, 0);
    }

    public void adjustChildren(int widthMeasureSpec, int heightMeasureSpec) {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("adjustChildren: " + this.mHost + " widthMeasureSpec: " + View.MeasureSpec.toString((int)widthMeasureSpec) + " heightMeasureSpec: " + View.MeasureSpec.toString((int)heightMeasureSpec)));
        }
        int widthHint = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightHint = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int N = this.mHost.getChildCount();
        for (int i = 0; i < N; ++i) {
            View view = this.mHost.getChildAt(i);
            ViewGroup.LayoutParams params = view.getLayoutParams();
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("should adjust " + view + " " + params));
            }
            if (!(params instanceof PercentLayoutParams)) continue;
            PercentLayoutInfo info = ((PercentLayoutParams)params).getPercentLayoutInfo();
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("using " + info));
            }
            if (info == null) continue;
            if (params instanceof ViewGroup.MarginLayoutParams) {
                info.fillMarginLayoutParams((ViewGroup.MarginLayoutParams)params, widthHint, heightHint);
                continue;
            }
            info.fillLayoutParams(params, widthHint, heightHint);
        }
    }

    public static PercentLayoutInfo getPercentLayoutInfo(Context context, AttributeSet attrs) {
        PercentLayoutInfo info = null;
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.PercentLayout_Layout);
        float value = array.getFraction(R.styleable.PercentLayout_Layout_layout_widthPercent, 1, 1, -1.0f);
        if (value != -1.0f) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("percent width: " + value));
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.widthPercent = value;
        }
        if ((value = array.getFraction(R.styleable.PercentLayout_Layout_layout_heightPercent, 1, 1, -1.0f)) != -1.0f) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("percent height: " + value));
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.heightPercent = value;
        }
        if ((value = array.getFraction(R.styleable.PercentLayout_Layout_layout_marginPercent, 1, 1, -1.0f)) != -1.0f) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("percent margin: " + value));
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.leftMarginPercent = value;
            info.topMarginPercent = value;
            info.rightMarginPercent = value;
            info.bottomMarginPercent = value;
        }
        if ((value = array.getFraction(R.styleable.PercentLayout_Layout_layout_marginLeftPercent, 1, 1, -1.0f)) != -1.0f) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("percent left margin: " + value));
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.leftMarginPercent = value;
        }
        if ((value = array.getFraction(R.styleable.PercentLayout_Layout_layout_marginTopPercent, 1, 1, -1.0f)) != -1.0f) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("percent top margin: " + value));
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.topMarginPercent = value;
        }
        if ((value = array.getFraction(R.styleable.PercentLayout_Layout_layout_marginRightPercent, 1, 1, -1.0f)) != -1.0f) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("percent right margin: " + value));
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.rightMarginPercent = value;
        }
        if ((value = array.getFraction(R.styleable.PercentLayout_Layout_layout_marginBottomPercent, 1, 1, -1.0f)) != -1.0f) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("percent bottom margin: " + value));
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.bottomMarginPercent = value;
        }
        if ((value = array.getFraction(R.styleable.PercentLayout_Layout_layout_marginStartPercent, 1, 1, -1.0f)) != -1.0f) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("percent start margin: " + value));
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.startMarginPercent = value;
        }
        if ((value = array.getFraction(R.styleable.PercentLayout_Layout_layout_marginEndPercent, 1, 1, -1.0f)) != -1.0f) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("percent end margin: " + value));
            }
            info = info != null ? info : new PercentLayoutInfo();
            info.endMarginPercent = value;
        }
        array.recycle();
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("constructed: " + info));
        }
        return info;
    }

    public void restoreOriginalParams() {
        int N = this.mHost.getChildCount();
        for (int i = 0; i < N; ++i) {
            View view = this.mHost.getChildAt(i);
            ViewGroup.LayoutParams params = view.getLayoutParams();
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("should restore " + view + " " + params));
            }
            if (!(params instanceof PercentLayoutParams)) continue;
            PercentLayoutInfo info = ((PercentLayoutParams)params).getPercentLayoutInfo();
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("using " + info));
            }
            if (info == null) continue;
            if (params instanceof ViewGroup.MarginLayoutParams) {
                info.restoreMarginLayoutParams((ViewGroup.MarginLayoutParams)params);
                continue;
            }
            info.restoreLayoutParams(params);
        }
    }

    public boolean handleMeasuredStateTooSmall() {
        boolean needsSecondMeasure = false;
        int N = this.mHost.getChildCount();
        for (int i = 0; i < N; ++i) {
            PercentLayoutInfo info;
            View view = this.mHost.getChildAt(i);
            ViewGroup.LayoutParams params = view.getLayoutParams();
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("should handle measured state too small " + view + " " + params));
            }
            if (!(params instanceof PercentLayoutParams) || (info = ((PercentLayoutParams)params).getPercentLayoutInfo()) == null) continue;
            if (PercentLayoutHelper.shouldHandleMeasuredWidthTooSmall(view, info)) {
                needsSecondMeasure = true;
                params.width = -2;
            }
            if (!PercentLayoutHelper.shouldHandleMeasuredHeightTooSmall(view, info)) continue;
            needsSecondMeasure = true;
            params.height = -2;
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("should trigger second measure pass: " + needsSecondMeasure));
        }
        return needsSecondMeasure;
    }

    private static boolean shouldHandleMeasuredWidthTooSmall(View view, PercentLayoutInfo info) {
        int state = ViewCompat.getMeasuredWidthAndState((View)view) & 0xFF000000;
        return state == 0x1000000 && info.widthPercent >= 0.0f && info.mPreservedParams.width == -2;
    }

    private static boolean shouldHandleMeasuredHeightTooSmall(View view, PercentLayoutInfo info) {
        int state = ViewCompat.getMeasuredHeightAndState((View)view) & 0xFF000000;
        return state == 0x1000000 && info.heightPercent >= 0.0f && info.mPreservedParams.height == -2;
    }

    public static interface PercentLayoutParams {
        public PercentLayoutInfo getPercentLayoutInfo();
    }

    public static class PercentLayoutInfo {
        public float widthPercent = -1.0f;
        public float heightPercent = -1.0f;
        public float leftMarginPercent = -1.0f;
        public float topMarginPercent = -1.0f;
        public float rightMarginPercent = -1.0f;
        public float bottomMarginPercent = -1.0f;
        public float startMarginPercent = -1.0f;
        public float endMarginPercent = -1.0f;
        final ViewGroup.MarginLayoutParams mPreservedParams = new ViewGroup.MarginLayoutParams(0, 0);

        public void fillLayoutParams(ViewGroup.LayoutParams params, int widthHint, int heightHint) {
            this.mPreservedParams.width = params.width;
            this.mPreservedParams.height = params.height;
            if (this.widthPercent >= 0.0f) {
                params.width = (int)((float)widthHint * this.widthPercent);
            }
            if (this.heightPercent >= 0.0f) {
                params.height = (int)((float)heightHint * this.heightPercent);
            }
            if (Log.isLoggable((String)PercentLayoutHelper.TAG, (int)3)) {
                Log.d((String)PercentLayoutHelper.TAG, (String)("after fillLayoutParams: (" + params.width + ", " + params.height + ")"));
            }
        }

        public void fillMarginLayoutParams(ViewGroup.MarginLayoutParams params, int widthHint, int heightHint) {
            this.fillLayoutParams((ViewGroup.LayoutParams)params, widthHint, heightHint);
            this.mPreservedParams.leftMargin = params.leftMargin;
            this.mPreservedParams.topMargin = params.topMargin;
            this.mPreservedParams.rightMargin = params.rightMargin;
            this.mPreservedParams.bottomMargin = params.bottomMargin;
            MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)this.mPreservedParams, (int)MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)params));
            MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)this.mPreservedParams, (int)MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)params));
            if (this.leftMarginPercent >= 0.0f) {
                params.leftMargin = (int)((float)widthHint * this.leftMarginPercent);
            }
            if (this.topMarginPercent >= 0.0f) {
                params.topMargin = (int)((float)heightHint * this.topMarginPercent);
            }
            if (this.rightMarginPercent >= 0.0f) {
                params.rightMargin = (int)((float)widthHint * this.rightMarginPercent);
            }
            if (this.bottomMarginPercent >= 0.0f) {
                params.bottomMargin = (int)((float)heightHint * this.bottomMarginPercent);
            }
            if (this.startMarginPercent >= 0.0f) {
                MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)params, (int)((int)((float)widthHint * this.startMarginPercent)));
            }
            if (this.endMarginPercent >= 0.0f) {
                MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)params, (int)((int)((float)widthHint * this.endMarginPercent)));
            }
            if (Log.isLoggable((String)PercentLayoutHelper.TAG, (int)3)) {
                Log.d((String)PercentLayoutHelper.TAG, (String)("after fillMarginLayoutParams: (" + params.width + ", " + params.height + ")"));
            }
        }

        public String toString() {
            return String.format("PercentLayoutInformation width: %f height %f, margins (%f, %f,  %f, %f, %f, %f)", Float.valueOf(this.widthPercent), Float.valueOf(this.heightPercent), Float.valueOf(this.leftMarginPercent), Float.valueOf(this.topMarginPercent), Float.valueOf(this.rightMarginPercent), Float.valueOf(this.bottomMarginPercent), Float.valueOf(this.startMarginPercent), Float.valueOf(this.endMarginPercent));
        }

        public void restoreMarginLayoutParams(ViewGroup.MarginLayoutParams params) {
            this.restoreLayoutParams((ViewGroup.LayoutParams)params);
            params.leftMargin = this.mPreservedParams.leftMargin;
            params.topMargin = this.mPreservedParams.topMargin;
            params.rightMargin = this.mPreservedParams.rightMargin;
            params.bottomMargin = this.mPreservedParams.bottomMargin;
            MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)params, (int)MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)this.mPreservedParams));
            MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)params, (int)MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)this.mPreservedParams));
        }

        public void restoreLayoutParams(ViewGroup.LayoutParams params) {
            params.width = this.mPreservedParams.width;
            params.height = this.mPreservedParams.height;
        }
    }
}

