/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.app;

import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v17.leanback.widget.SearchOrbView;
import android.support.v17.leanback.widget.TitleHelper;
import android.support.v17.leanback.widget.TitleView;
import android.support.v4.app.Fragment;
import android.view.View;
import android.view.ViewGroup;

class BrandedSupportFragment
extends Fragment {
    private static final String TITLE_SHOW = "titleShow";
    private boolean mShowingTitle = true;
    private String mTitle;
    private Drawable mBadgeDrawable;
    private TitleView mTitleView;
    private SearchOrbView.Colors mSearchAffordanceColors;
    private boolean mSearchAffordanceColorSet;
    private View.OnClickListener mExternalOnSearchClickedListener;
    private TitleHelper mTitleHelper;

    BrandedSupportFragment() {
    }

    void setTitleView(TitleView titleView) {
        this.mTitleView = titleView;
        if (this.mTitleView == null) {
            this.mTitleHelper = null;
        } else {
            this.mTitleView.setTitle(this.mTitle);
            this.mTitleView.setBadgeDrawable(this.mBadgeDrawable);
            if (this.mSearchAffordanceColorSet) {
                this.mTitleView.setSearchAffordanceColors(this.mSearchAffordanceColors);
            }
            if (this.mExternalOnSearchClickedListener != null) {
                this.mTitleView.setOnSearchClickedListener(this.mExternalOnSearchClickedListener);
            }
            if (this.getView() instanceof ViewGroup) {
                this.mTitleHelper = new TitleHelper((ViewGroup)this.getView(), this.mTitleView);
            }
        }
    }

    TitleView getTitleView() {
        return this.mTitleView;
    }

    TitleHelper getTitleHelper() {
        return this.mTitleHelper;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(TITLE_SHOW, this.mShowingTitle);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (savedInstanceState != null) {
            this.mShowingTitle = savedInstanceState.getBoolean(TITLE_SHOW);
        }
        if (this.mTitleView != null && view instanceof ViewGroup) {
            this.mTitleHelper = new TitleHelper((ViewGroup)view, this.mTitleView);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mTitleHelper = null;
    }

    void showTitle(boolean show) {
        if (show == this.mShowingTitle) {
            return;
        }
        this.mShowingTitle = show;
        if (this.mTitleHelper != null) {
            this.mTitleHelper.showTitle(show);
        }
    }

    public void setBadgeDrawable(Drawable drawable2) {
        if (this.mBadgeDrawable != drawable2) {
            this.mBadgeDrawable = drawable2;
            if (this.mTitleView != null) {
                this.mTitleView.setBadgeDrawable(drawable2);
            }
        }
    }

    public Drawable getBadgeDrawable() {
        return this.mBadgeDrawable;
    }

    public void setTitle(String title) {
        this.mTitle = title;
        if (this.mTitleView != null) {
            this.mTitleView.setTitle(title);
        }
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setOnSearchClickedListener(View.OnClickListener listener) {
        this.mExternalOnSearchClickedListener = listener;
        if (this.mTitleView != null) {
            this.mTitleView.setOnSearchClickedListener(listener);
        }
    }

    public void setSearchAffordanceColors(SearchOrbView.Colors colors) {
        this.mSearchAffordanceColors = colors;
        this.mSearchAffordanceColorSet = true;
        if (this.mTitleView != null) {
            this.mTitleView.setSearchAffordanceColors(this.mSearchAffordanceColors);
        }
    }

    public SearchOrbView.Colors getSearchAffordanceColors() {
        if (this.mSearchAffordanceColorSet) {
            return this.mSearchAffordanceColors;
        }
        if (this.mTitleView == null) {
            throw new IllegalStateException("Fragment views not yet created");
        }
        return this.mTitleView.getSearchAffordanceColors();
    }

    public void setSearchAffordanceColor(int color2) {
        this.setSearchAffordanceColors(new SearchOrbView.Colors(color2));
    }

    public int getSearchAffordanceColor() {
        return this.getSearchAffordanceColors().color;
    }

    public void onStart() {
        super.onStart();
        if (this.mTitleView != null) {
            this.mTitleView.setVisibility(this.mShowingTitle ? 0 : 4);
        }
    }

    public void onPause() {
        if (this.mTitleView != null) {
            this.mTitleView.enableAnimation(false);
        }
        super.onPause();
    }

    public void onResume() {
        super.onResume();
        if (this.mTitleView != null) {
            this.mTitleView.enableAnimation(true);
        }
    }
}

