/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.app;

import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.v17.leanback.R;
import android.support.v17.leanback.app.BaseFragment;
import android.support.v17.leanback.app.HeadersFragment;
import android.support.v17.leanback.app.RowsFragment;
import android.support.v17.leanback.transition.TransitionListener;
import android.support.v17.leanback.widget.BrowseFrameLayout;
import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.OnItemViewClickedListener;
import android.support.v17.leanback.widget.OnItemViewSelectedListener;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.PresenterSelector;
import android.support.v17.leanback.widget.Row;
import android.support.v17.leanback.widget.RowHeaderPresenter;
import android.support.v17.leanback.widget.RowPresenter;
import android.support.v17.leanback.widget.TitleView;
import android.support.v17.leanback.widget.VerticalGridView;
import android.support.v4.view.ViewCompat;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public class BrowseFragment
extends BaseFragment {
    static final String HEADER_STACK_INDEX = "headerStackIndex";
    static final String HEADER_SHOW = "headerShow";
    private static final String TAG = "BrowseFragment";
    private static final String LB_HEADERS_BACKSTACK = "lbHeadersBackStack_";
    private static boolean DEBUG = false;
    public static final int HEADERS_ENABLED = 1;
    public static final int HEADERS_HIDDEN = 2;
    public static final int HEADERS_DISABLED = 3;
    private RowsFragment mRowsFragment;
    private HeadersFragment mHeadersFragment;
    private ObjectAdapter mAdapter;
    private int mHeadersState = 1;
    private int mBrandColor = 0;
    private boolean mBrandColorSet;
    private BrowseFrameLayout mBrowseFrame;
    private boolean mHeadersBackStackEnabled = true;
    private String mWithHeadersBackStackName;
    private boolean mShowingHeaders = true;
    private boolean mCanShowHeaders = true;
    private int mContainerListMarginStart;
    private int mContainerListAlignTop;
    private boolean mRowScaleEnabled = true;
    private OnItemViewSelectedListener mExternalOnItemViewSelectedListener;
    private OnItemViewClickedListener mOnItemViewClickedListener;
    private int mSelectedPosition = -1;
    private PresenterSelector mHeaderPresenterSelector;
    private final SetSelectionRunnable mSetSelectionRunnable = new SetSelectionRunnable();
    private Object mSceneWithHeaders;
    private Object mSceneWithoutHeaders;
    private Object mSceneAfterEntranceTransition;
    private Object mHeadersTransition;
    private BackStackListener mBackStackChangedListener;
    private BrowseTransitionListener mBrowseTransitionListener;
    private static final String ARG_TITLE = BrowseFragment.class.getCanonicalName() + ".title";
    private static final String ARG_BADGE_URI = BrowseFragment.class.getCanonicalName() + ".badge";
    private static final String ARG_HEADERS_STATE = BrowseFragment.class.getCanonicalName() + ".headersState";
    private final BrowseFrameLayout.OnFocusSearchListener mOnFocusSearchListener = new BrowseFrameLayout.OnFocusSearchListener(){

        @Override
        public View onFocusSearch(View focused, int direction) {
            int towardEnd;
            if (BrowseFragment.this.mCanShowHeaders && BrowseFragment.this.isInHeadersTransition()) {
                return focused;
            }
            if (DEBUG) {
                Log.v((String)BrowseFragment.TAG, (String)("onFocusSearch focused " + focused + " + direction " + direction));
            }
            if (BrowseFragment.this.getTitleView() != null && focused != BrowseFragment.this.getTitleView() && direction == 33) {
                return BrowseFragment.this.getTitleView();
            }
            if (BrowseFragment.this.getTitleView() != null && BrowseFragment.this.getTitleView().hasFocus() && direction == 130) {
                return BrowseFragment.this.mCanShowHeaders && BrowseFragment.this.mShowingHeaders ? BrowseFragment.this.mHeadersFragment.getVerticalGridView() : BrowseFragment.this.mRowsFragment.getVerticalGridView();
            }
            boolean isRtl = ViewCompat.getLayoutDirection((View)focused) == 1;
            int towardStart = isRtl ? 66 : 17;
            int n = towardEnd = isRtl ? 17 : 66;
            if (BrowseFragment.this.mCanShowHeaders && direction == towardStart) {
                if (BrowseFragment.this.isVerticalScrolling() || BrowseFragment.this.mShowingHeaders) {
                    return focused;
                }
                return BrowseFragment.this.mHeadersFragment.getVerticalGridView();
            }
            if (direction == towardEnd) {
                if (BrowseFragment.this.isVerticalScrolling()) {
                    return focused;
                }
                return BrowseFragment.this.mRowsFragment.getVerticalGridView();
            }
            return null;
        }
    };
    private final BrowseFrameLayout.OnChildFocusListener mOnChildFocusListener = new BrowseFrameLayout.OnChildFocusListener(){

        @Override
        public boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
            if (BrowseFragment.this.getChildFragmentManager().isDestroyed()) {
                return true;
            }
            if (BrowseFragment.this.mCanShowHeaders && BrowseFragment.this.mShowingHeaders && BrowseFragment.this.mHeadersFragment != null && BrowseFragment.this.mHeadersFragment.getView() != null && BrowseFragment.this.mHeadersFragment.getView().requestFocus(direction, previouslyFocusedRect)) {
                return true;
            }
            if (BrowseFragment.this.mRowsFragment != null && BrowseFragment.this.mRowsFragment.getView() != null && BrowseFragment.this.mRowsFragment.getView().requestFocus(direction, previouslyFocusedRect)) {
                return true;
            }
            return BrowseFragment.this.getTitleView() != null && BrowseFragment.this.getTitleView().requestFocus(direction, previouslyFocusedRect);
        }

        @Override
        public void onRequestChildFocus(View child, View focused) {
            if (BrowseFragment.this.getChildFragmentManager().isDestroyed()) {
                return;
            }
            if (!BrowseFragment.this.mCanShowHeaders || BrowseFragment.this.isInHeadersTransition()) {
                return;
            }
            int childId = child.getId();
            if (childId == R.id.browse_container_dock && BrowseFragment.this.mShowingHeaders) {
                BrowseFragment.this.startHeadersTransitionInternal(false);
            } else if (childId == R.id.browse_headers_dock && !BrowseFragment.this.mShowingHeaders) {
                BrowseFragment.this.startHeadersTransitionInternal(true);
            }
        }
    };
    private HeadersFragment.OnHeaderClickedListener mHeaderClickedListener = new HeadersFragment.OnHeaderClickedListener(){

        @Override
        public void onHeaderClicked() {
            if (!BrowseFragment.this.mCanShowHeaders || !BrowseFragment.this.mShowingHeaders || BrowseFragment.this.isInHeadersTransition()) {
                return;
            }
            BrowseFragment.this.startHeadersTransitionInternal(false);
            BrowseFragment.this.mRowsFragment.getVerticalGridView().requestFocus();
        }
    };
    private OnItemViewSelectedListener mRowViewSelectedListener = new OnItemViewSelectedListener(){

        @Override
        public void onItemSelected(Presenter.ViewHolder itemViewHolder, Object item, RowPresenter.ViewHolder rowViewHolder, Row row) {
            int position = BrowseFragment.this.mRowsFragment.getVerticalGridView().getSelectedPosition();
            if (DEBUG) {
                Log.v((String)BrowseFragment.TAG, (String)("row selected position " + position));
            }
            BrowseFragment.this.onRowSelected(position);
            if (BrowseFragment.this.mExternalOnItemViewSelectedListener != null) {
                BrowseFragment.this.mExternalOnItemViewSelectedListener.onItemSelected(itemViewHolder, item, rowViewHolder, row);
            }
        }
    };
    private HeadersFragment.OnHeaderViewSelectedListener mHeaderViewSelectedListener = new HeadersFragment.OnHeaderViewSelectedListener(){

        @Override
        public void onHeaderSelected(RowHeaderPresenter.ViewHolder viewHolder, Row row) {
            int position = BrowseFragment.this.mHeadersFragment.getVerticalGridView().getSelectedPosition();
            if (DEBUG) {
                Log.v((String)BrowseFragment.TAG, (String)("header selected position " + position));
            }
            BrowseFragment.this.onRowSelected(position);
        }
    };

    public static Bundle createArgs(Bundle args, String title, int headersState) {
        if (args == null) {
            args = new Bundle();
        }
        args.putString(ARG_TITLE, title);
        args.putInt(ARG_HEADERS_STATE, headersState);
        return args;
    }

    public void setBrandColor(@ColorInt int color2) {
        this.mBrandColor = color2;
        this.mBrandColorSet = true;
        if (this.mHeadersFragment != null) {
            this.mHeadersFragment.setBackgroundColor(this.mBrandColor);
        }
    }

    @ColorInt
    public int getBrandColor() {
        return this.mBrandColor;
    }

    public void setAdapter(ObjectAdapter adapter) {
        this.mAdapter = adapter;
        if (this.mRowsFragment != null) {
            this.mRowsFragment.setAdapter(adapter);
            this.mHeadersFragment.setAdapter(adapter);
        }
    }

    public ObjectAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setOnItemViewSelectedListener(OnItemViewSelectedListener listener) {
        this.mExternalOnItemViewSelectedListener = listener;
    }

    public OnItemViewSelectedListener getOnItemViewSelectedListener() {
        return this.mExternalOnItemViewSelectedListener;
    }

    public void setOnItemViewClickedListener(OnItemViewClickedListener listener) {
        this.mOnItemViewClickedListener = listener;
        if (this.mRowsFragment != null) {
            this.mRowsFragment.setOnItemViewClickedListener(listener);
        }
    }

    public OnItemViewClickedListener getOnItemViewClickedListener() {
        return this.mOnItemViewClickedListener;
    }

    public void startHeadersTransition(boolean withHeaders) {
        if (!this.mCanShowHeaders) {
            throw new IllegalStateException("Cannot start headers transition");
        }
        if (this.isInHeadersTransition() || this.mShowingHeaders == withHeaders) {
            return;
        }
        this.startHeadersTransitionInternal(withHeaders);
    }

    public boolean isInHeadersTransition() {
        return this.mHeadersTransition != null;
    }

    public boolean isShowingHeaders() {
        return this.mShowingHeaders;
    }

    public void setBrowseTransitionListener(BrowseTransitionListener listener) {
        this.mBrowseTransitionListener = listener;
    }

    public void enableRowScaling(boolean enable) {
        this.mRowScaleEnabled = enable;
        if (this.mRowsFragment != null) {
            this.mRowsFragment.enableRowScaling(this.mRowScaleEnabled);
        }
    }

    private void startHeadersTransitionInternal(final boolean withHeaders) {
        if (this.getFragmentManager().isDestroyed()) {
            return;
        }
        this.mShowingHeaders = withHeaders;
        this.mRowsFragment.onExpandTransitionStart(!withHeaders, new Runnable(){

            @Override
            public void run() {
                BrowseFragment.this.mHeadersFragment.onTransitionPrepare();
                BrowseFragment.this.mHeadersFragment.onTransitionStart();
                BrowseFragment.this.createHeadersTransition();
                if (BrowseFragment.this.mBrowseTransitionListener != null) {
                    BrowseFragment.this.mBrowseTransitionListener.onHeadersTransitionStart(withHeaders);
                }
                BaseFragment.sTransitionHelper.runTransition(withHeaders ? BrowseFragment.this.mSceneWithHeaders : BrowseFragment.this.mSceneWithoutHeaders, BrowseFragment.this.mHeadersTransition);
                if (BrowseFragment.this.mHeadersBackStackEnabled) {
                    if (!withHeaders) {
                        BrowseFragment.this.getFragmentManager().beginTransaction().addToBackStack(BrowseFragment.this.mWithHeadersBackStackName).commit();
                    } else {
                        int index = ((BrowseFragment)BrowseFragment.this).mBackStackChangedListener.mIndexOfHeadersBackStack;
                        if (index >= 0) {
                            FragmentManager.BackStackEntry entry = BrowseFragment.this.getFragmentManager().getBackStackEntryAt(index);
                            BrowseFragment.this.getFragmentManager().popBackStackImmediate(entry.getId(), 1);
                        }
                    }
                }
            }
        });
    }

    private boolean isVerticalScrolling() {
        return this.mHeadersFragment.getVerticalGridView().getScrollState() != 0 || this.mRowsFragment.getVerticalGridView().getScrollState() != 0;
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mBackStackChangedListener != null) {
            this.mBackStackChangedListener.save(outState);
        } else {
            outState.putBoolean(HEADER_SHOW, this.mShowingHeaders);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        TypedArray ta = this.getActivity().obtainStyledAttributes(R.styleable.LeanbackTheme);
        this.mContainerListMarginStart = (int)ta.getDimension(R.styleable.LeanbackTheme_browseRowsMarginStart, (float)this.getActivity().getResources().getDimensionPixelSize(R.dimen.lb_browse_rows_margin_start));
        this.mContainerListAlignTop = (int)ta.getDimension(R.styleable.LeanbackTheme_browseRowsMarginTop, (float)this.getActivity().getResources().getDimensionPixelSize(R.dimen.lb_browse_rows_margin_top));
        ta.recycle();
        this.readArguments(this.getArguments());
        if (this.mCanShowHeaders) {
            if (this.mHeadersBackStackEnabled) {
                this.mWithHeadersBackStackName = LB_HEADERS_BACKSTACK + (Object)((Object)this);
                this.mBackStackChangedListener = new BackStackListener();
                this.getFragmentManager().addOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)this.mBackStackChangedListener);
                this.mBackStackChangedListener.load(savedInstanceState);
            } else if (savedInstanceState != null) {
                this.mShowingHeaders = savedInstanceState.getBoolean(HEADER_SHOW);
            }
        }
    }

    public void onDestroy() {
        if (this.mBackStackChangedListener != null) {
            this.getFragmentManager().removeOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)this.mBackStackChangedListener);
        }
        super.onDestroy();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.getChildFragmentManager().findFragmentById(R.id.browse_container_dock) == null) {
            this.mRowsFragment = new RowsFragment();
            this.mHeadersFragment = new HeadersFragment();
            this.getChildFragmentManager().beginTransaction().replace(R.id.browse_headers_dock, (Fragment)this.mHeadersFragment).replace(R.id.browse_container_dock, (Fragment)this.mRowsFragment).commit();
        } else {
            this.mHeadersFragment = (HeadersFragment)this.getChildFragmentManager().findFragmentById(R.id.browse_headers_dock);
            this.mRowsFragment = (RowsFragment)this.getChildFragmentManager().findFragmentById(R.id.browse_container_dock);
        }
        this.mHeadersFragment.setHeadersGone(!this.mCanShowHeaders);
        this.mRowsFragment.setAdapter(this.mAdapter);
        if (this.mHeaderPresenterSelector != null) {
            this.mHeadersFragment.setPresenterSelector(this.mHeaderPresenterSelector);
        }
        this.mHeadersFragment.setAdapter(this.mAdapter);
        this.mRowsFragment.enableRowScaling(this.mRowScaleEnabled);
        this.mRowsFragment.setOnItemViewSelectedListener(this.mRowViewSelectedListener);
        this.mHeadersFragment.setOnHeaderViewSelectedListener(this.mHeaderViewSelectedListener);
        this.mHeadersFragment.setOnHeaderClickedListener(this.mHeaderClickedListener);
        this.mRowsFragment.setOnItemViewClickedListener(this.mOnItemViewClickedListener);
        View root = inflater.inflate(R.layout.lb_browse_fragment, container, false);
        this.setTitleView((TitleView)root.findViewById(R.id.browse_title_group));
        this.mBrowseFrame = (BrowseFrameLayout)root.findViewById(R.id.browse_frame);
        this.mBrowseFrame.setOnChildFocusListener(this.mOnChildFocusListener);
        this.mBrowseFrame.setOnFocusSearchListener(this.mOnFocusSearchListener);
        if (this.mBrandColorSet) {
            this.mHeadersFragment.setBackgroundColor(this.mBrandColor);
        }
        this.mSceneWithHeaders = sTransitionHelper.createScene((ViewGroup)this.mBrowseFrame, new Runnable(){

            @Override
            public void run() {
                BrowseFragment.this.showHeaders(true);
            }
        });
        this.mSceneWithoutHeaders = sTransitionHelper.createScene((ViewGroup)this.mBrowseFrame, new Runnable(){

            @Override
            public void run() {
                BrowseFragment.this.showHeaders(false);
            }
        });
        this.mSceneAfterEntranceTransition = sTransitionHelper.createScene((ViewGroup)this.mBrowseFrame, new Runnable(){

            @Override
            public void run() {
                BrowseFragment.this.setEntranceTransitionEndState();
            }
        });
        return root;
    }

    private void createHeadersTransition() {
        this.mHeadersTransition = sTransitionHelper.loadTransition((Context)this.getActivity(), this.mShowingHeaders ? R.transition.lb_browse_headers_in : R.transition.lb_browse_headers_out);
        sTransitionHelper.setTransitionListener(this.mHeadersTransition, new TransitionListener(){

            @Override
            public void onTransitionStart(Object transition2) {
            }

            @Override
            public void onTransitionEnd(Object transition2) {
                BrowseFragment.this.mHeadersTransition = null;
                BrowseFragment.this.mRowsFragment.onTransitionEnd();
                BrowseFragment.this.mHeadersFragment.onTransitionEnd();
                if (BrowseFragment.this.mShowingHeaders) {
                    VerticalGridView headerGridView = BrowseFragment.this.mHeadersFragment.getVerticalGridView();
                    if (headerGridView != null && !headerGridView.hasFocus()) {
                        headerGridView.requestFocus();
                    }
                } else {
                    VerticalGridView rowsGridView = BrowseFragment.this.mRowsFragment.getVerticalGridView();
                    if (rowsGridView != null && !rowsGridView.hasFocus()) {
                        rowsGridView.requestFocus();
                    }
                }
                if (BrowseFragment.this.mBrowseTransitionListener != null) {
                    BrowseFragment.this.mBrowseTransitionListener.onHeadersTransitionStop(BrowseFragment.this.mShowingHeaders);
                }
            }
        });
    }

    public void setHeaderPresenterSelector(PresenterSelector headerPresenterSelector) {
        this.mHeaderPresenterSelector = headerPresenterSelector;
        if (this.mHeadersFragment != null) {
            this.mHeadersFragment.setPresenterSelector(this.mHeaderPresenterSelector);
        }
    }

    private void setRowsAlignedLeft(boolean alignLeft) {
        View containerList = this.mRowsFragment.getView();
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)containerList.getLayoutParams();
        lp.setMarginStart(alignLeft ? 0 : this.mContainerListMarginStart);
        containerList.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    private void setHeadersOnScreen(boolean onScreen) {
        View containerList = this.mHeadersFragment.getView();
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)containerList.getLayoutParams();
        lp.setMarginStart(onScreen ? 0 : -this.mContainerListMarginStart);
        containerList.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    private void showHeaders(boolean show) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("showHeaders " + show));
        }
        this.mHeadersFragment.setHeadersEnabled(show);
        this.setHeadersOnScreen(show);
        this.setRowsAlignedLeft(!show);
        this.mRowsFragment.setExpand(!show);
    }

    private void onRowSelected(int position) {
        if (position != this.mSelectedPosition) {
            this.mSetSelectionRunnable.post(position, 0, true);
            if (this.getAdapter() == null || this.getAdapter().size() == 0 || position == 0) {
                this.showTitle(true);
            } else {
                this.showTitle(false);
            }
        }
    }

    private void setSelection(int position, boolean smooth) {
        if (position != -1) {
            this.mRowsFragment.setSelectedPosition(position, smooth);
            this.mHeadersFragment.setSelectedPosition(position, smooth);
        }
        this.mSelectedPosition = position;
    }

    public void setSelectedPosition(int position) {
        this.setSelectedPosition(position, true);
    }

    public void setSelectedPosition(int position, boolean smooth) {
        this.mSetSelectionRunnable.post(position, 1, smooth);
    }

    @Override
    public void onStart() {
        super.onStart();
        this.mHeadersFragment.setWindowAlignmentFromTop(this.mContainerListAlignTop);
        this.mHeadersFragment.setItemAlignment();
        this.mRowsFragment.setWindowAlignmentFromTop(this.mContainerListAlignTop);
        this.mRowsFragment.setItemAlignment();
        this.mRowsFragment.setScalePivots(0.0f, this.mContainerListAlignTop);
        if (this.mCanShowHeaders && this.mShowingHeaders && this.mHeadersFragment.getView() != null) {
            this.mHeadersFragment.getView().requestFocus();
        } else if (!(this.mCanShowHeaders && this.mShowingHeaders || this.mRowsFragment.getView() == null)) {
            this.mRowsFragment.getView().requestFocus();
        }
        if (this.mCanShowHeaders) {
            this.showHeaders(this.mShowingHeaders);
        }
        if (this.isEntranceTransitionEnabled()) {
            this.setEntranceTransitionStartState();
        }
    }

    public final void setHeadersTransitionOnBackEnabled(boolean headersBackStackEnabled) {
        this.mHeadersBackStackEnabled = headersBackStackEnabled;
    }

    public final boolean isHeadersTransitionOnBackEnabled() {
        return this.mHeadersBackStackEnabled;
    }

    private void readArguments(Bundle args) {
        if (args == null) {
            return;
        }
        if (args.containsKey(ARG_TITLE)) {
            this.setTitle(args.getString(ARG_TITLE));
        }
        if (args.containsKey(ARG_HEADERS_STATE)) {
            this.setHeadersState(args.getInt(ARG_HEADERS_STATE));
        }
    }

    public void setHeadersState(int headersState) {
        if (headersState < 1 || headersState > 3) {
            throw new IllegalArgumentException("Invalid headers state: " + headersState);
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("setHeadersState " + headersState));
        }
        if (headersState != this.mHeadersState) {
            this.mHeadersState = headersState;
            switch (headersState) {
                case 1: {
                    this.mCanShowHeaders = true;
                    this.mShowingHeaders = true;
                    break;
                }
                case 2: {
                    this.mCanShowHeaders = true;
                    this.mShowingHeaders = false;
                    break;
                }
                case 3: {
                    this.mCanShowHeaders = false;
                    this.mShowingHeaders = false;
                    break;
                }
                default: {
                    Log.w((String)TAG, (String)("Unknown headers state: " + headersState));
                }
            }
            if (this.mHeadersFragment != null) {
                this.mHeadersFragment.setHeadersGone(!this.mCanShowHeaders);
            }
        }
    }

    public int getHeadersState() {
        return this.mHeadersState;
    }

    @Override
    protected Object createEntranceTransition() {
        return sTransitionHelper.loadTransition((Context)this.getActivity(), R.transition.lb_browse_entrance_transition);
    }

    @Override
    protected void runEntranceTransition(Object entranceTransition) {
        sTransitionHelper.runTransition(this.mSceneAfterEntranceTransition, entranceTransition);
    }

    @Override
    protected void onEntranceTransitionPrepare() {
        this.mHeadersFragment.onTransitionPrepare();
        this.mRowsFragment.onTransitionPrepare();
    }

    @Override
    protected void onEntranceTransitionStart() {
        this.mHeadersFragment.onTransitionStart();
        this.mRowsFragment.onTransitionStart();
    }

    @Override
    protected void onEntranceTransitionEnd() {
        this.mRowsFragment.onTransitionEnd();
        this.mHeadersFragment.onTransitionEnd();
    }

    void setSearchOrbViewOnScreen(boolean onScreen) {
        View searchOrbView = this.getTitleView().getSearchAffordanceView();
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)searchOrbView.getLayoutParams();
        lp.setMarginStart(onScreen ? 0 : -this.mContainerListMarginStart);
        searchOrbView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    void setEntranceTransitionStartState() {
        this.setHeadersOnScreen(false);
        this.setSearchOrbViewOnScreen(false);
        this.mRowsFragment.setEntranceTransitionState(false);
    }

    void setEntranceTransitionEndState() {
        this.setHeadersOnScreen(this.mShowingHeaders);
        this.setSearchOrbViewOnScreen(true);
        this.mRowsFragment.setEntranceTransitionState(true);
    }

    private class SetSelectionRunnable
    implements Runnable {
        static final int TYPE_INVALID = -1;
        static final int TYPE_INTERNAL_SYNC = 0;
        static final int TYPE_USER_REQUEST = 1;
        private int mPosition;
        private int mType;
        private boolean mSmooth;

        SetSelectionRunnable() {
            this.reset();
        }

        void post(int position, int type, boolean smooth) {
            if (type >= this.mType) {
                this.mPosition = position;
                this.mType = type;
                this.mSmooth = smooth;
                BrowseFragment.this.mBrowseFrame.removeCallbacks(this);
                BrowseFragment.this.mBrowseFrame.post(this);
            }
        }

        @Override
        public void run() {
            BrowseFragment.this.setSelection(this.mPosition, this.mSmooth);
            this.reset();
        }

        private void reset() {
            this.mPosition = -1;
            this.mType = -1;
            this.mSmooth = false;
        }
    }

    public static class BrowseTransitionListener {
        public void onHeadersTransitionStart(boolean withHeaders) {
        }

        public void onHeadersTransitionStop(boolean withHeaders) {
        }
    }

    final class BackStackListener
    implements FragmentManager.OnBackStackChangedListener {
        int mLastEntryCount;
        int mIndexOfHeadersBackStack;

        BackStackListener() {
            this.mLastEntryCount = BrowseFragment.this.getFragmentManager().getBackStackEntryCount();
            this.mIndexOfHeadersBackStack = -1;
        }

        void load(Bundle savedInstanceState) {
            if (savedInstanceState != null) {
                this.mIndexOfHeadersBackStack = savedInstanceState.getInt(BrowseFragment.HEADER_STACK_INDEX, -1);
                BrowseFragment.this.mShowingHeaders = this.mIndexOfHeadersBackStack == -1;
            } else if (!BrowseFragment.this.mShowingHeaders) {
                BrowseFragment.this.getFragmentManager().beginTransaction().addToBackStack(BrowseFragment.this.mWithHeadersBackStackName).commit();
            }
        }

        void save(Bundle outState) {
            outState.putInt(BrowseFragment.HEADER_STACK_INDEX, this.mIndexOfHeadersBackStack);
        }

        public void onBackStackChanged() {
            if (BrowseFragment.this.getFragmentManager() == null) {
                Log.w((String)BrowseFragment.TAG, (String)"getFragmentManager() is null, stack:", (Throwable)new Exception());
                return;
            }
            int count = BrowseFragment.this.getFragmentManager().getBackStackEntryCount();
            if (count > this.mLastEntryCount) {
                FragmentManager.BackStackEntry entry = BrowseFragment.this.getFragmentManager().getBackStackEntryAt(count - 1);
                if (BrowseFragment.this.mWithHeadersBackStackName.equals(entry.getName())) {
                    this.mIndexOfHeadersBackStack = count - 1;
                }
            } else if (count < this.mLastEntryCount && this.mIndexOfHeadersBackStack >= count) {
                this.mIndexOfHeadersBackStack = -1;
                if (!BrowseFragment.this.mShowingHeaders) {
                    BrowseFragment.this.startHeadersTransitionInternal(true);
                }
            }
            this.mLastEntryCount = count;
        }
    }
}

