/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.app;

import android.content.Context;
import android.media.AudioManager;
import android.support.v17.leanback.widget.GuidedAction;
import android.support.v17.leanback.widget.GuidedActionsStylist;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;

class GuidedActionAdapter
extends RecyclerView.Adapter {
    private static final String TAG = "GuidedActionAdapter";
    private static final boolean DEBUG = false;
    private RecyclerView mRecyclerView;
    private final ActionOnKeyListener mActionOnKeyListener;
    private final ActionOnFocusListener mActionOnFocusListener;
    private final List<GuidedAction> mActions;
    private ClickListener mClickListener;
    private GuidedActionsStylist mStylist;
    private final View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            ActionViewHolder avh;
            GuidedAction action;
            if (v != null && v.getWindowToken() != null && GuidedActionAdapter.this.mClickListener != null && (action = (avh = (ActionViewHolder)GuidedActionAdapter.this.mRecyclerView.getChildViewHolder(v)).getAction()).isEnabled() && !action.infoOnly()) {
                GuidedActionAdapter.this.mClickListener.onGuidedActionClicked(action);
            }
        }
    };

    public GuidedActionAdapter(List<GuidedAction> actions, ClickListener clickListener, FocusListener focusListener, GuidedActionsStylist presenter) {
        this.mActions = new ArrayList<GuidedAction>(actions);
        this.mClickListener = clickListener;
        this.mStylist = presenter;
        this.mActionOnKeyListener = new ActionOnKeyListener(clickListener, this.mActions);
        this.mActionOnFocusListener = new ActionOnFocusListener(focusListener);
    }

    public void setActions(List<GuidedAction> actions) {
        this.mActionOnFocusListener.unFocus();
        this.mActions.clear();
        this.mActions.addAll(actions);
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.mActions.size();
    }

    public GuidedAction getItem(int position) {
        return this.mActions.get(position);
    }

    public void setClickListener(ClickListener clickListener) {
        this.mClickListener = clickListener;
        this.mActionOnKeyListener.setListener(clickListener);
    }

    public void setFocusListener(FocusListener focusListener) {
        this.mActionOnFocusListener.setFocusListener(focusListener);
    }

    public List<GuidedAction> getActions() {
        return new ArrayList<GuidedAction>(this.mActions);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        this.mRecyclerView = null;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        GuidedActionsStylist.ViewHolder vh = this.mStylist.onCreateViewHolder(parent);
        View v = vh.view;
        v.setOnKeyListener((View.OnKeyListener)this.mActionOnKeyListener);
        v.setOnClickListener(this.mOnClickListener);
        v.setOnFocusChangeListener((View.OnFocusChangeListener)this.mActionOnFocusListener);
        return new ActionViewHolder(v, vh);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (position >= this.mActions.size()) {
            return;
        }
        ActionViewHolder avh = (ActionViewHolder)holder;
        GuidedAction action = this.mActions.get(position);
        avh.setAction(action);
        this.mStylist.onBindViewHolder(avh.mStylistViewHolder, action);
    }

    public int getItemCount() {
        return this.mActions.size();
    }

    private class ActionOnKeyListener
    implements View.OnKeyListener {
        private final List<GuidedAction> mActions;
        private boolean mKeyPressed = false;
        private ClickListener mClickListener;

        public ActionOnKeyListener(ClickListener listener, List<GuidedAction> actions) {
            this.mClickListener = listener;
            this.mActions = actions;
        }

        public void setListener(ClickListener listener) {
            this.mClickListener = listener;
        }

        private void playSound(View v, int soundEffect) {
            if (v.isSoundEffectsEnabled()) {
                Context ctx = v.getContext();
                AudioManager manager = (AudioManager)ctx.getSystemService("audio");
                manager.playSoundEffect(soundEffect);
            }
        }

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (v == null || event == null) {
                return false;
            }
            boolean handled = false;
            block0 : switch (keyCode) {
                case 23: 
                case 66: 
                case 99: 
                case 100: 
                case 160: {
                    ActionViewHolder avh = (ActionViewHolder)GuidedActionAdapter.this.mRecyclerView.getChildViewHolder(v);
                    GuidedAction action = avh.getAction();
                    if (!action.isEnabled() || action.infoOnly()) {
                        if (event.getAction() == 0) {
                            // empty if block
                        }
                        return true;
                    }
                    switch (event.getAction()) {
                        case 0: {
                            if (this.mKeyPressed) break block0;
                            this.mKeyPressed = true;
                            this.playSound(v, 0);
                            GuidedActionAdapter.this.mStylist.onAnimateItemPressed(avh.mStylistViewHolder, this.mKeyPressed);
                            handled = true;
                            break block0;
                        }
                        case 1: {
                            if (!this.mKeyPressed) break block0;
                            this.mKeyPressed = false;
                            GuidedActionAdapter.this.mStylist.onAnimateItemPressed(avh.mStylistViewHolder, this.mKeyPressed);
                            this.handleCheckedActions(avh, action);
                            this.mClickListener.onGuidedActionClicked(action);
                            handled = true;
                            break block0;
                        }
                    }
                    break;
                }
            }
            return handled;
        }

        private void handleCheckedActions(ActionViewHolder avh, GuidedAction action) {
            int actionCheckSetId = action.getCheckSetId();
            if (actionCheckSetId != 0) {
                int size = this.mActions.size();
                for (int i = 0; i < size; ++i) {
                    GuidedAction a = this.mActions.get(i);
                    if (a == action || a.getCheckSetId() != actionCheckSetId || !a.isChecked()) continue;
                    a.setChecked(false);
                    RecyclerView.ViewHolder vh = GuidedActionAdapter.this.mRecyclerView.findViewHolderForPosition(i);
                    if (vh == null) continue;
                    GuidedActionsStylist.ViewHolder subViewHolder = ((ActionViewHolder)vh).mStylistViewHolder;
                    GuidedActionAdapter.this.mStylist.onAnimateItemChecked(subViewHolder, false);
                }
                if (!action.isChecked()) {
                    action.setChecked(true);
                    GuidedActionAdapter.this.mStylist.onAnimateItemChecked(avh.mStylistViewHolder, true);
                }
            }
        }
    }

    private class ActionOnFocusListener
    implements View.OnFocusChangeListener {
        private FocusListener mFocusListener;
        private View mSelectedView;

        ActionOnFocusListener(FocusListener focusListener) {
            this.mFocusListener = focusListener;
        }

        public void setFocusListener(FocusListener focusListener) {
            this.mFocusListener = focusListener;
        }

        public void unFocus() {
            if (this.mSelectedView != null) {
                RecyclerView.ViewHolder vh = GuidedActionAdapter.this.mRecyclerView.getChildViewHolder(this.mSelectedView);
                if (vh != null) {
                    ActionViewHolder avh = (ActionViewHolder)vh;
                    GuidedActionAdapter.this.mStylist.onAnimateItemFocused(avh.mStylistViewHolder, false);
                } else {
                    Log.w((String)GuidedActionAdapter.TAG, (String)"RecyclerView returned null view holder", (Throwable)new Throwable());
                }
            }
        }

        public void onFocusChange(View v, boolean hasFocus) {
            ActionViewHolder avh = (ActionViewHolder)GuidedActionAdapter.this.mRecyclerView.getChildViewHolder(v);
            GuidedActionAdapter.this.mStylist.onAnimateItemFocused(avh.mStylistViewHolder, hasFocus);
            if (hasFocus) {
                this.mSelectedView = v;
                if (this.mFocusListener != null) {
                    this.mFocusListener.onGuidedActionFocused(avh.getAction());
                }
            } else if (this.mSelectedView == v) {
                this.mSelectedView = null;
            }
        }
    }

    private static class ActionViewHolder
    extends RecyclerView.ViewHolder {
        private final GuidedActionsStylist.ViewHolder mStylistViewHolder;
        private GuidedAction mAction;

        public ActionViewHolder(View v, GuidedActionsStylist.ViewHolder subViewHolder) {
            super(v);
            this.mStylistViewHolder = subViewHolder;
        }

        public GuidedAction getAction() {
            return this.mAction;
        }

        public void setAction(GuidedAction action) {
            this.mAction = action;
        }
    }

    public static interface FocusListener {
        public void onGuidedActionFocused(GuidedAction var1);
    }

    public static interface ClickListener {
        public void onGuidedActionClicked(GuidedAction var1);
    }
}

