/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.app;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v17.leanback.app.PlaybackControlGlue;
import android.support.v17.leanback.app.PlaybackOverlayFragment;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.util.Log;

public abstract class MediaControllerGlue
extends PlaybackControlGlue {
    private static final String TAG = "MediaControllerGlue";
    private static final boolean DEBUG = false;
    private MediaControllerCompat mMediaController;
    private final MediaControllerCompat.Callback mCallback = new MediaControllerCompat.Callback(){

        public void onMetadataChanged(MediaMetadataCompat metadata) {
            MediaControllerGlue.this.onMetadataChanged();
        }

        public void onPlaybackStateChanged(PlaybackStateCompat state) {
            MediaControllerGlue.this.onStateChanged();
        }

        public void onSessionDestroyed() {
            MediaControllerGlue.this.mMediaController = null;
        }

        public void onSessionEvent(String event, Bundle extras) {
        }
    };

    public MediaControllerGlue(Context context, PlaybackOverlayFragment fragment, int[] seekSpeeds) {
        super(context, fragment, seekSpeeds);
    }

    public MediaControllerGlue(Context context, PlaybackOverlayFragment fragment, int[] fastForwardSpeeds, int[] rewindSpeeds) {
        super(context, fragment, fastForwardSpeeds, rewindSpeeds);
    }

    public void attachToMediaController(MediaControllerCompat mediaController) {
        if (mediaController != this.mMediaController) {
            this.detach();
            this.mMediaController = mediaController;
            if (this.mMediaController != null) {
                this.mMediaController.registerCallback(this.mCallback);
            }
            this.onMetadataChanged();
            this.onStateChanged();
        }
    }

    public void detach() {
        if (this.mMediaController != null) {
            this.mMediaController.unregisterCallback(this.mCallback);
        }
        this.mMediaController = null;
    }

    public final MediaControllerCompat getMediaController() {
        return this.mMediaController;
    }

    @Override
    public boolean hasValidMedia() {
        return this.mMediaController != null && this.mMediaController.getMetadata() != null;
    }

    @Override
    public boolean isMediaPlaying() {
        return this.mMediaController.getPlaybackState().getState() == 3;
    }

    @Override
    public int getCurrentSpeedId() {
        int speed = (int)this.mMediaController.getPlaybackState().getPlaybackSpeed();
        if (speed == 0) {
            return 0;
        }
        if (speed == 1) {
            return 1;
        }
        if (speed > 0) {
            int[] seekSpeeds = this.getFastForwardSpeeds();
            for (int index = 0; index < seekSpeeds.length; ++index) {
                if (speed != seekSpeeds[index]) continue;
                return 10 + index;
            }
        } else {
            int[] seekSpeeds = this.getRewindSpeeds();
            for (int index = 0; index < seekSpeeds.length; ++index) {
                if (-speed != seekSpeeds[index]) continue;
                return -10 - index;
            }
        }
        Log.w((String)TAG, (String)("Couldn't find index for speed " + speed));
        return -1;
    }

    @Override
    public CharSequence getMediaTitle() {
        return this.mMediaController.getMetadata().getDescription().getTitle();
    }

    @Override
    public CharSequence getMediaSubtitle() {
        return this.mMediaController.getMetadata().getDescription().getSubtitle();
    }

    @Override
    public int getMediaDuration() {
        return (int)this.mMediaController.getMetadata().getLong("android.media.metadata.DURATION");
    }

    @Override
    public int getCurrentPosition() {
        return (int)this.mMediaController.getPlaybackState().getPosition();
    }

    @Override
    public Drawable getMediaArt() {
        Bitmap bitmap = this.mMediaController.getMetadata().getDescription().getIconBitmap();
        return bitmap == null ? null : new BitmapDrawable(this.getContext().getResources(), bitmap);
    }

    @Override
    public long getSupportedActions() {
        long result = 0L;
        long actions = this.mMediaController.getPlaybackState().getActions();
        if ((actions & 0x200L) != 0L) {
            result |= 0x40L;
        }
        if ((actions & 0x20L) != 0L) {
            result |= 0x100L;
        }
        if ((actions & 0x10L) != 0L) {
            result |= 0x10L;
        }
        if ((actions & 0x40L) != 0L) {
            result |= 0x80L;
        }
        if ((actions & 8L) != 0L) {
            result |= 0x20L;
        }
        return result;
    }

    @Override
    protected void startPlayback(int speed) {
        if (speed == 1) {
            this.mMediaController.getTransportControls().play();
        } else if (speed > 0) {
            this.mMediaController.getTransportControls().fastForward();
        } else {
            this.mMediaController.getTransportControls().rewind();
        }
    }

    @Override
    protected void pausePlayback() {
        this.mMediaController.getTransportControls().pause();
    }

    @Override
    protected void skipToNext() {
        this.mMediaController.getTransportControls().skipToNext();
    }

    @Override
    protected void skipToPrevious() {
        this.mMediaController.getTransportControls().skipToPrevious();
    }
}

