/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.app;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.support.v17.leanback.app.PlaybackOverlayFragment;
import android.support.v17.leanback.widget.AbstractDetailsDescriptionPresenter;
import android.support.v17.leanback.widget.Action;
import android.support.v17.leanback.widget.ControlButtonPresenterSelector;
import android.support.v17.leanback.widget.OnActionClickedListener;
import android.support.v17.leanback.widget.OnItemViewClickedListener;
import android.support.v17.leanback.widget.PlaybackControlsRow;
import android.support.v17.leanback.widget.PlaybackControlsRowPresenter;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.PresenterSelector;
import android.support.v17.leanback.widget.Row;
import android.support.v17.leanback.widget.RowPresenter;
import android.support.v17.leanback.widget.SparseArrayObjectAdapter;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.View;

public abstract class PlaybackControlGlue
implements OnActionClickedListener,
View.OnKeyListener {
    public static final int ACTION_CUSTOM_LEFT_FIRST = 1;
    public static final int ACTION_SKIP_TO_PREVIOUS = 16;
    public static final int ACTION_REWIND = 32;
    public static final int ACTION_PLAY_PAUSE = 64;
    public static final int ACTION_FAST_FORWARD = 128;
    public static final int ACTION_SKIP_TO_NEXT = 256;
    public static final int ACTION_CUSTOM_RIGHT_FIRST = 4096;
    public static final int PLAYBACK_SPEED_INVALID = -1;
    public static final int PLAYBACK_SPEED_PAUSED = 0;
    public static final int PLAYBACK_SPEED_NORMAL = 1;
    public static final int PLAYBACK_SPEED_FAST_L0 = 10;
    public static final int PLAYBACK_SPEED_FAST_L1 = 11;
    public static final int PLAYBACK_SPEED_FAST_L2 = 12;
    public static final int PLAYBACK_SPEED_FAST_L3 = 13;
    public static final int PLAYBACK_SPEED_FAST_L4 = 14;
    private static final String TAG = "PlaybackControlGlue";
    private static final boolean DEBUG = false;
    private static final int MSG_UPDATE_PLAYBACK_STATE = 100;
    private static final int UPDATE_PLAYBACK_STATE_DELAY_MS = 2000;
    private static final int NUMBER_OF_SEEK_SPEEDS = 5;
    private final PlaybackOverlayFragment mFragment;
    private final Context mContext;
    private final int[] mFastForwardSpeeds;
    private final int[] mRewindSpeeds;
    private PlaybackControlsRow mControlsRow;
    private SparseArrayObjectAdapter mPrimaryActionsAdapter;
    private PlaybackControlsRow.PlayPauseAction mPlayPauseAction;
    private PlaybackControlsRow.SkipNextAction mSkipNextAction;
    private PlaybackControlsRow.SkipPreviousAction mSkipPreviousAction;
    private PlaybackControlsRow.FastForwardAction mFastForwardAction;
    private PlaybackControlsRow.RewindAction mRewindAction;
    private OnItemViewClickedListener mExternalOnItemViewClickedListener;
    private int mPlaybackSpeed = 1;
    private boolean mFadeWhenPlaying = true;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 100) {
                PlaybackControlGlue.this.updatePlaybackState();
            }
        }
    };
    private final OnItemViewClickedListener mOnItemViewClickedListener = new OnItemViewClickedListener(){

        @Override
        public void onItemClicked(Presenter.ViewHolder viewHolder, Object object, RowPresenter.ViewHolder viewHolder2, Row row) {
            boolean handled = false;
            if (object instanceof Action) {
                handled = PlaybackControlGlue.this.dispatchAction((Action)object, null);
            }
            if (!handled && PlaybackControlGlue.this.mExternalOnItemViewClickedListener != null) {
                PlaybackControlGlue.this.mExternalOnItemViewClickedListener.onItemClicked(viewHolder, object, viewHolder2, row);
            }
        }
    };
    private final PlaybackOverlayFragment.InputEventHandler mOnInputEventHandler = new PlaybackOverlayFragment.InputEventHandler(){

        @Override
        public boolean handleInputEvent(InputEvent event) {
            if (event instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)event;
                return PlaybackControlGlue.this.onKey(null, keyEvent.getKeyCode(), keyEvent);
            }
            return false;
        }
    };

    public PlaybackControlGlue(Context context, int[] seekSpeeds) {
        this(context, null, seekSpeeds, seekSpeeds);
    }

    public PlaybackControlGlue(Context context, int[] fastForwardSpeeds, int[] rewindSpeeds) {
        this(context, null, fastForwardSpeeds, rewindSpeeds);
    }

    public PlaybackControlGlue(Context context, PlaybackOverlayFragment fragment, int[] seekSpeeds) {
        this(context, fragment, seekSpeeds, seekSpeeds);
    }

    public PlaybackControlGlue(Context context, PlaybackOverlayFragment fragment, int[] fastForwardSpeeds, int[] rewindSpeeds) {
        this.mContext = context;
        this.mFragment = fragment;
        if (fragment != null) {
            this.attachToFragment();
        }
        if (fastForwardSpeeds.length == 0 || fastForwardSpeeds.length > 5) {
            throw new IllegalStateException("invalid fastForwardSpeeds array size");
        }
        this.mFastForwardSpeeds = fastForwardSpeeds;
        if (rewindSpeeds.length == 0 || rewindSpeeds.length > 5) {
            throw new IllegalStateException("invalid rewindSpeeds array size");
        }
        this.mRewindSpeeds = rewindSpeeds;
    }

    private void attachToFragment() {
        this.mFragment.setInputEventHandler(this.mOnInputEventHandler);
    }

    public PlaybackControlsRowPresenter createControlsRowAndPresenter() {
        PlaybackControlsRow controlsRow = new PlaybackControlsRow(this);
        this.setControlsRow(controlsRow);
        AbstractDetailsDescriptionPresenter detailsPresenter = new AbstractDetailsDescriptionPresenter(){

            @Override
            protected void onBindDescription(AbstractDetailsDescriptionPresenter.ViewHolder viewHolder, Object object) {
                PlaybackControlGlue glue = (PlaybackControlGlue)object;
                if (glue.hasValidMedia()) {
                    viewHolder.getTitle().setText(glue.getMediaTitle());
                    viewHolder.getSubtitle().setText(glue.getMediaSubtitle());
                } else {
                    viewHolder.getTitle().setText((CharSequence)"");
                    viewHolder.getSubtitle().setText((CharSequence)"");
                }
            }
        };
        return new PlaybackControlsRowPresenter(detailsPresenter){

            @Override
            protected void onBindRowViewHolder(RowPresenter.ViewHolder vh, Object item) {
                super.onBindRowViewHolder(vh, item);
                vh.setOnKeyListener(PlaybackControlGlue.this);
            }

            @Override
            protected void onUnbindRowViewHolder(RowPresenter.ViewHolder vh) {
                super.onUnbindRowViewHolder(vh);
                vh.setOnKeyListener(null);
            }
        };
    }

    public PlaybackOverlayFragment getFragment() {
        return this.mFragment;
    }

    public Context getContext() {
        return this.mContext;
    }

    public int[] getFastForwardSpeeds() {
        return this.mFastForwardSpeeds;
    }

    public int[] getRewindSpeeds() {
        return this.mRewindSpeeds;
    }

    public void setFadingEnabled(boolean enable) {
        this.mFadeWhenPlaying = enable;
        if (!this.mFadeWhenPlaying && this.mFragment != null) {
            this.mFragment.setFadingEnabled(false);
        }
    }

    public boolean isFadingEnabled() {
        return this.mFadeWhenPlaying;
    }

    public void setOnItemViewClickedListener(OnItemViewClickedListener listener) {
        this.mExternalOnItemViewClickedListener = listener;
        if (this.mFragment != null) {
            this.mFragment.setOnItemViewClickedListener(this.mOnItemViewClickedListener);
        }
    }

    public OnItemViewClickedListener getOnItemViewClickedListener() {
        return this.mExternalOnItemViewClickedListener;
    }

    public void setControlsRow(PlaybackControlsRow controlsRow) {
        this.mControlsRow = controlsRow;
        this.mPrimaryActionsAdapter = this.createPrimaryActionsAdapter(new ControlButtonPresenterSelector());
        this.mControlsRow.setPrimaryActionsAdapter(this.mPrimaryActionsAdapter);
        this.updateControlsRow();
    }

    public PlaybackControlsRow getControlsRow() {
        return this.mControlsRow;
    }

    public void enableProgressUpdating(boolean enable) {
    }

    public int getUpdatePeriod() {
        return 500;
    }

    public void updateProgress() {
        int position = this.getCurrentPosition();
        this.mControlsRow.setCurrentTime(position);
    }

    @Override
    public void onActionClicked(Action action) {
        this.dispatchAction(action, null);
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 111: {
                boolean abortSeek;
                boolean bl = abortSeek = this.mPlaybackSpeed >= 10 || this.mPlaybackSpeed <= -10;
                if (abortSeek) {
                    this.mPlaybackSpeed = 1;
                    this.startPlayback(this.mPlaybackSpeed);
                    this.updatePlaybackStatusAfterUserAction();
                    return keyCode == 4 || keyCode == 111;
                }
                return false;
            }
        }
        Action action = this.mControlsRow.getActionForKeyCode(this.mPrimaryActionsAdapter, keyCode);
        if (action != null && (action == this.mPrimaryActionsAdapter.lookup(64) || action == this.mPrimaryActionsAdapter.lookup(32) || action == this.mPrimaryActionsAdapter.lookup(128) || action == this.mPrimaryActionsAdapter.lookup(16) || action == this.mPrimaryActionsAdapter.lookup(256))) {
            if (event.getAction() == 0) {
                this.dispatchAction(action, event);
            }
            return true;
        }
        return false;
    }

    private boolean dispatchAction(Action action, KeyEvent keyEvent) {
        boolean handled = false;
        if (action == this.mPlayPauseAction) {
            boolean canPause;
            boolean canPlay = keyEvent == null || keyEvent.getKeyCode() == 85 || keyEvent.getKeyCode() == 126;
            boolean bl = canPause = keyEvent == null || keyEvent.getKeyCode() == 85 || keyEvent.getKeyCode() == 127;
            if (this.mPlaybackSpeed != 1) {
                if (canPlay) {
                    this.mPlaybackSpeed = 1;
                    this.startPlayback(this.mPlaybackSpeed);
                }
            } else if (canPause) {
                this.mPlaybackSpeed = 0;
                this.pausePlayback();
            }
            this.updatePlaybackStatusAfterUserAction();
            handled = true;
        } else if (action == this.mSkipNextAction) {
            this.skipToNext();
            handled = true;
        } else if (action == this.mSkipPreviousAction) {
            this.skipToPrevious();
            handled = true;
        } else if (action == this.mFastForwardAction) {
            if (this.mPlaybackSpeed < this.getMaxForwardSpeedId()) {
                switch (this.mPlaybackSpeed) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        ++this.mPlaybackSpeed;
                        break;
                    }
                    default: {
                        this.mPlaybackSpeed = 10;
                    }
                }
                this.startPlayback(this.mPlaybackSpeed);
                this.updatePlaybackStatusAfterUserAction();
            }
            handled = true;
        } else if (action == this.mRewindAction) {
            if (this.mPlaybackSpeed > -this.getMaxRewindSpeedId()) {
                switch (this.mPlaybackSpeed) {
                    case -13: 
                    case -12: 
                    case -11: 
                    case -10: {
                        --this.mPlaybackSpeed;
                        break;
                    }
                    default: {
                        this.mPlaybackSpeed = -10;
                    }
                }
                this.startPlayback(this.mPlaybackSpeed);
                this.updatePlaybackStatusAfterUserAction();
            }
            handled = true;
        }
        return handled;
    }

    private int getMaxForwardSpeedId() {
        return 10 + (this.mFastForwardSpeeds.length - 1);
    }

    private int getMaxRewindSpeedId() {
        return 10 + (this.mRewindSpeeds.length - 1);
    }

    private void updateControlsRow() {
        this.updateRowMetadata();
        this.mHandler.removeMessages(100);
        this.updatePlaybackState();
    }

    private void updatePlaybackStatusAfterUserAction() {
        this.updatePlaybackState(this.mPlaybackSpeed);
        this.mHandler.removeMessages(100);
        this.mHandler.sendEmptyMessageDelayed(100, 2000L);
    }

    private void updateRowMetadata() {
        if (this.mControlsRow == null) {
            return;
        }
        if (!this.hasValidMedia()) {
            this.mControlsRow.setImageDrawable(null);
            this.mControlsRow.setTotalTime(0);
            this.mControlsRow.setCurrentTime(0);
        } else {
            this.mControlsRow.setImageDrawable(this.getMediaArt());
            this.mControlsRow.setTotalTime(this.getMediaDuration());
            this.mControlsRow.setCurrentTime(this.getCurrentPosition());
        }
        this.onRowChanged(this.mControlsRow);
    }

    private void updatePlaybackState() {
        if (this.hasValidMedia()) {
            this.mPlaybackSpeed = this.getCurrentSpeedId();
            this.updatePlaybackState(this.mPlaybackSpeed);
        }
    }

    private void updatePlaybackState(int playbackSpeed) {
        int index;
        if (this.mControlsRow == null) {
            return;
        }
        long actions = this.getSupportedActions();
        if ((actions & 0x10L) != 0L) {
            if (this.mSkipPreviousAction == null) {
                this.mSkipPreviousAction = new PlaybackControlsRow.SkipPreviousAction(this.mContext);
            }
            this.mPrimaryActionsAdapter.set(16, this.mSkipPreviousAction);
        } else {
            this.mPrimaryActionsAdapter.clear(16);
            this.mSkipPreviousAction = null;
        }
        if ((actions & 0x20L) != 0L) {
            if (this.mRewindAction == null) {
                this.mRewindAction = new PlaybackControlsRow.RewindAction(this.mContext, this.mRewindSpeeds.length);
            }
            this.mPrimaryActionsAdapter.set(32, this.mRewindAction);
        } else {
            this.mPrimaryActionsAdapter.clear(32);
            this.mRewindAction = null;
        }
        if ((actions & 0x40L) != 0L) {
            if (this.mPlayPauseAction == null) {
                this.mPlayPauseAction = new PlaybackControlsRow.PlayPauseAction(this.mContext);
            }
            this.mPrimaryActionsAdapter.set(64, this.mPlayPauseAction);
        } else {
            this.mPrimaryActionsAdapter.clear(64);
            this.mPlayPauseAction = null;
        }
        if ((actions & 0x80L) != 0L) {
            if (this.mFastForwardAction == null) {
                this.mFastForwardAction = new PlaybackControlsRow.FastForwardAction(this.mContext, this.mFastForwardSpeeds.length);
            }
            this.mPrimaryActionsAdapter.set(128, this.mFastForwardAction);
        } else {
            this.mPrimaryActionsAdapter.clear(128);
            this.mFastForwardAction = null;
        }
        if ((actions & 0x100L) != 0L) {
            if (this.mSkipNextAction == null) {
                this.mSkipNextAction = new PlaybackControlsRow.SkipNextAction(this.mContext);
            }
            this.mPrimaryActionsAdapter.set(256, this.mSkipNextAction);
        } else {
            this.mPrimaryActionsAdapter.clear(256);
            this.mSkipNextAction = null;
        }
        if (this.mFastForwardAction != null) {
            index = 0;
            if (playbackSpeed >= 10) {
                index = playbackSpeed - 10;
                if (playbackSpeed < this.getMaxForwardSpeedId()) {
                    ++index;
                }
            }
            if (this.mFastForwardAction.getIndex() != index) {
                this.mFastForwardAction.setIndex(index);
                PlaybackControlGlue.notifyItemChanged(this.mPrimaryActionsAdapter, this.mFastForwardAction);
            }
        }
        if (this.mRewindAction != null) {
            index = 0;
            if (playbackSpeed <= -10) {
                index = -playbackSpeed - 10;
                if (-playbackSpeed < this.getMaxRewindSpeedId()) {
                    ++index;
                }
            }
            if (this.mRewindAction.getIndex() != index) {
                this.mRewindAction.setIndex(index);
                PlaybackControlGlue.notifyItemChanged(this.mPrimaryActionsAdapter, this.mRewindAction);
            }
        }
        if (playbackSpeed == 0) {
            this.updateProgress();
            this.enableProgressUpdating(false);
        } else {
            this.enableProgressUpdating(true);
        }
        if (this.mFadeWhenPlaying && this.mFragment != null) {
            this.mFragment.setFadingEnabled(playbackSpeed == 1);
        }
        if (this.mPlayPauseAction != null) {
            int n = index = playbackSpeed == 0 ? PlaybackControlsRow.PlayPauseAction.PLAY : PlaybackControlsRow.PlayPauseAction.PAUSE;
            if (this.mPlayPauseAction.getIndex() != index) {
                this.mPlayPauseAction.setIndex(index);
                PlaybackControlGlue.notifyItemChanged(this.mPrimaryActionsAdapter, this.mPlayPauseAction);
            }
        }
    }

    private static void notifyItemChanged(SparseArrayObjectAdapter adapter, Object object) {
        int index = adapter.indexOf(object);
        if (index >= 0) {
            adapter.notifyArrayItemRangeChanged(index, 1);
        }
    }

    private static String getSpeedString(int speed) {
        switch (speed) {
            case -1: {
                return "PLAYBACK_SPEED_INVALID";
            }
            case 0: {
                return "PLAYBACK_SPEED_PAUSED";
            }
            case 1: {
                return "PLAYBACK_SPEED_NORMAL";
            }
            case 10: {
                return "PLAYBACK_SPEED_FAST_L0";
            }
            case 11: {
                return "PLAYBACK_SPEED_FAST_L1";
            }
            case 12: {
                return "PLAYBACK_SPEED_FAST_L2";
            }
            case 13: {
                return "PLAYBACK_SPEED_FAST_L3";
            }
            case 14: {
                return "PLAYBACK_SPEED_FAST_L4";
            }
            case -10: {
                return "-PLAYBACK_SPEED_FAST_L0";
            }
            case -11: {
                return "-PLAYBACK_SPEED_FAST_L1";
            }
            case -12: {
                return "-PLAYBACK_SPEED_FAST_L2";
            }
            case -13: {
                return "-PLAYBACK_SPEED_FAST_L3";
            }
            case -14: {
                return "-PLAYBACK_SPEED_FAST_L4";
            }
        }
        return null;
    }

    public abstract boolean hasValidMedia();

    public abstract boolean isMediaPlaying();

    public abstract CharSequence getMediaTitle();

    public abstract CharSequence getMediaSubtitle();

    public abstract int getMediaDuration();

    public abstract Drawable getMediaArt();

    public abstract long getSupportedActions();

    public abstract int getCurrentSpeedId();

    public abstract int getCurrentPosition();

    protected abstract void startPlayback(int var1);

    protected abstract void pausePlayback();

    protected abstract void skipToNext();

    protected abstract void skipToPrevious();

    protected abstract void onRowChanged(PlaybackControlsRow var1);

    protected SparseArrayObjectAdapter createPrimaryActionsAdapter(PresenterSelector presenterSelector) {
        return new SparseArrayObjectAdapter(presenterSelector);
    }

    protected void onStateChanged() {
        if (!this.hasValidMedia()) {
            return;
        }
        if (this.mHandler.hasMessages(100)) {
            this.mHandler.removeMessages(100);
            if (this.getCurrentSpeedId() != this.mPlaybackSpeed) {
                this.mHandler.sendEmptyMessageDelayed(100, 2000L);
            } else {
                this.updatePlaybackState();
            }
        } else {
            this.updatePlaybackState();
        }
    }

    protected void onMetadataChanged() {
        this.updateRowMetadata();
    }
}

