/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.app;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v17.leanback.R;
import android.support.v17.leanback.animation.LogAccelerateInterpolator;
import android.support.v17.leanback.animation.LogDecelerateInterpolator;
import android.support.v17.leanback.app.DetailsSupportFragment;
import android.support.v17.leanback.widget.BaseGridView;
import android.support.v17.leanback.widget.ItemBridgeAdapter;
import android.support.v17.leanback.widget.ObjectAdapter;
import android.support.v17.leanback.widget.PlaybackControlsRowPresenter;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.VerticalGridView;
import android.support.v7.widget.RecyclerView;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import java.util.ArrayList;

public class PlaybackOverlaySupportFragment
extends DetailsSupportFragment {
    public static final int BG_NONE = 0;
    public static final int BG_DARK = 1;
    public static final int BG_LIGHT = 2;
    private static final String TAG = "PlaybackOverlaySupportFragment";
    private static final boolean DEBUG = false;
    private static final int ANIMATION_MULTIPLIER = 1;
    private static int START_FADE_OUT = 1;
    private static final int IDLE = 0;
    private static final int IN = 1;
    private static final int OUT = 2;
    private int mAlignPosition;
    private int mPaddingBottom;
    private View mRootView;
    private int mBackgroundType = 1;
    private int mBgDarkColor;
    private int mBgLightColor;
    private int mShowTimeMs;
    private int mMajorFadeTranslateY;
    private int mMinorFadeTranslateY;
    private int mAnimationTranslateY;
    private OnFadeCompleteListener mFadeCompleteListener;
    private InputEventHandler mInputEventHandler;
    private boolean mFadingEnabled = true;
    private int mFadingStatus = 0;
    private int mBgAlpha;
    private ValueAnimator mBgFadeInAnimator;
    private ValueAnimator mBgFadeOutAnimator;
    private ValueAnimator mControlRowFadeInAnimator;
    private ValueAnimator mControlRowFadeOutAnimator;
    private ValueAnimator mDescriptionFadeInAnimator;
    private ValueAnimator mDescriptionFadeOutAnimator;
    private ValueAnimator mOtherRowFadeInAnimator;
    private ValueAnimator mOtherRowFadeOutAnimator;
    private boolean mTranslateAnimationEnabled;
    private boolean mResetControlsToPrimaryActionsPending;
    private RecyclerView.ItemAnimator mItemAnimator;
    private final Animator.AnimatorListener mFadeListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
            PlaybackOverlaySupportFragment.this.enableVerticalGridAnimations(false);
        }

        public void onAnimationRepeat(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            if (PlaybackOverlaySupportFragment.this.mBgAlpha > 0) {
                PlaybackOverlaySupportFragment.this.enableVerticalGridAnimations(true);
                PlaybackOverlaySupportFragment.this.startFadeTimer();
                if (PlaybackOverlaySupportFragment.this.mFadeCompleteListener != null) {
                    PlaybackOverlaySupportFragment.this.mFadeCompleteListener.onFadeInComplete();
                }
            } else {
                if (PlaybackOverlaySupportFragment.this.getVerticalGridView() != null) {
                    PlaybackOverlaySupportFragment.this.getVerticalGridView().setSelectedPosition(0);
                    PlaybackOverlaySupportFragment.this.resetControlsToPrimaryActions(null);
                }
                if (PlaybackOverlaySupportFragment.this.mFadeCompleteListener != null) {
                    PlaybackOverlaySupportFragment.this.mFadeCompleteListener.onFadeOutComplete();
                }
            }
            PlaybackOverlaySupportFragment.this.mFadingStatus = 0;
        }
    };
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message message) {
            if (message.what == START_FADE_OUT && PlaybackOverlaySupportFragment.this.mFadingEnabled) {
                PlaybackOverlaySupportFragment.this.fade(false);
            }
        }
    };
    private final BaseGridView.OnTouchInterceptListener mOnTouchInterceptListener = new BaseGridView.OnTouchInterceptListener(){

        @Override
        public boolean onInterceptTouchEvent(MotionEvent event) {
            return PlaybackOverlaySupportFragment.this.onInterceptInputEvent((InputEvent)event);
        }
    };
    private final BaseGridView.OnKeyInterceptListener mOnKeyInterceptListener = new BaseGridView.OnKeyInterceptListener(){

        @Override
        public boolean onInterceptKeyEvent(KeyEvent event) {
            return PlaybackOverlaySupportFragment.this.onInterceptInputEvent((InputEvent)event);
        }
    };
    private TimeInterpolator mLogDecelerateInterpolator = new LogDecelerateInterpolator(100, 0);
    private TimeInterpolator mLogAccelerateInterpolator = new LogAccelerateInterpolator(100, 0);
    private final ItemBridgeAdapter.AdapterListener mAdapterListener = new ItemBridgeAdapter.AdapterListener(){

        @Override
        public void onAttachedToWindow(ItemBridgeAdapter.ViewHolder vh) {
            if (PlaybackOverlaySupportFragment.this.mFadingStatus == 0 && PlaybackOverlaySupportFragment.this.mBgAlpha == 0 || PlaybackOverlaySupportFragment.this.mFadingStatus == 2) {
                vh.getViewHolder().view.setAlpha(0.0f);
            }
            if (vh.getPosition() == 0 && PlaybackOverlaySupportFragment.this.mResetControlsToPrimaryActionsPending) {
                PlaybackOverlaySupportFragment.this.resetControlsToPrimaryActions(vh);
            }
        }

        @Override
        public void onDetachedFromWindow(ItemBridgeAdapter.ViewHolder vh) {
            Presenter.ViewHolder descriptionVh;
            vh.getViewHolder().view.setAlpha(1.0f);
            vh.getViewHolder().view.setTranslationY(0.0f);
            if (vh.getViewHolder() instanceof PlaybackControlsRowPresenter.ViewHolder && (descriptionVh = ((PlaybackControlsRowPresenter.ViewHolder)vh.getViewHolder()).mDescriptionViewHolder) != null) {
                descriptionVh.view.setAlpha(1.0f);
            }
        }

        @Override
        public void onBind(ItemBridgeAdapter.ViewHolder vh) {
            if (vh.getPosition() == 0) {
                PlaybackOverlaySupportFragment.this.updateControlsBottomSpace(vh);
            }
        }
    };
    private final ObjectAdapter.DataObserver mObserver = new ObjectAdapter.DataObserver(){

        @Override
        public void onChanged() {
            PlaybackOverlaySupportFragment.this.updateControlsBottomSpace(null);
        }
    };

    private void setBgAlpha(int alpha) {
        this.mBgAlpha = alpha;
        if (this.mRootView != null) {
            this.mRootView.getBackground().setAlpha(alpha);
        }
    }

    private void enableVerticalGridAnimations(boolean enable) {
        if (this.getVerticalGridView() != null) {
            this.getVerticalGridView().setAnimateChildLayout(enable);
        }
    }

    private void resetControlsToPrimaryActions(ItemBridgeAdapter.ViewHolder vh) {
        if (vh == null && this.getVerticalGridView() != null) {
            vh = (ItemBridgeAdapter.ViewHolder)this.getVerticalGridView().findViewHolderForPosition(0);
        }
        if (vh == null) {
            this.mResetControlsToPrimaryActionsPending = true;
        } else if (vh.getPresenter() instanceof PlaybackControlsRowPresenter) {
            this.mResetControlsToPrimaryActionsPending = false;
            ((PlaybackControlsRowPresenter)vh.getPresenter()).showPrimaryActions((PlaybackControlsRowPresenter.ViewHolder)vh.getViewHolder());
        }
    }

    public void setFadingEnabled(boolean enabled) {
        if (enabled != this.mFadingEnabled) {
            this.mFadingEnabled = enabled;
            if (this.mFadingEnabled) {
                if (this.isResumed() && this.mFadingStatus == 0 && !this.mHandler.hasMessages(START_FADE_OUT)) {
                    this.startFadeTimer();
                }
            } else {
                this.mHandler.removeMessages(START_FADE_OUT);
                this.fade(true);
            }
        }
    }

    public boolean isFadingEnabled() {
        return this.mFadingEnabled;
    }

    public void setFadeCompleteListener(OnFadeCompleteListener listener) {
        this.mFadeCompleteListener = listener;
    }

    public OnFadeCompleteListener getFadeCompleteListener() {
        return this.mFadeCompleteListener;
    }

    public final void setInputEventHandler(InputEventHandler handler) {
        this.mInputEventHandler = handler;
    }

    public final InputEventHandler getInputEventHandler() {
        return this.mInputEventHandler;
    }

    public void tickle() {
        if (!this.mFadingEnabled || !this.isResumed()) {
            return;
        }
        if (this.mHandler.hasMessages(START_FADE_OUT)) {
            this.startFadeTimer();
        } else {
            this.fade(true);
        }
    }

    private boolean areControlsHidden() {
        return this.mFadingStatus == 0 && this.mBgAlpha == 0;
    }

    private boolean onInterceptInputEvent(InputEvent event) {
        boolean controlsHidden = this.areControlsHidden();
        boolean consumeEvent = false;
        int keyCode = 0;
        if (this.mInputEventHandler != null) {
            consumeEvent = this.mInputEventHandler.handleInputEvent(event);
        }
        if (event instanceof KeyEvent) {
            keyCode = ((KeyEvent)event).getKeyCode();
        }
        switch (keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                if (controlsHidden) {
                    consumeEvent = true;
                }
                this.tickle();
                break;
            }
            case 4: 
            case 111: {
                if (this.mFadingEnabled && !controlsHidden) {
                    consumeEvent = true;
                    this.mHandler.removeMessages(START_FADE_OUT);
                    this.fade(false);
                    break;
                }
                if (!consumeEvent) break;
                this.tickle();
                break;
            }
            default: {
                if (!consumeEvent) break;
                this.tickle();
            }
        }
        return consumeEvent;
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.mFadingEnabled) {
            this.setBgAlpha(0);
            this.fade(true);
        }
        this.getVerticalGridView().setOnTouchInterceptListener(this.mOnTouchInterceptListener);
        this.getVerticalGridView().setOnKeyInterceptListener(this.mOnKeyInterceptListener);
    }

    private void startFadeTimer() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(START_FADE_OUT);
            this.mHandler.sendEmptyMessageDelayed(START_FADE_OUT, (long)this.mShowTimeMs);
        }
    }

    private static ValueAnimator loadAnimator(Context context, int resId) {
        ValueAnimator animator2 = (ValueAnimator)AnimatorInflater.loadAnimator((Context)context, (int)resId);
        animator2.setDuration(animator2.getDuration() * 1L);
        return animator2;
    }

    private void loadBgAnimator() {
        ValueAnimator.AnimatorUpdateListener listener = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator arg0) {
                PlaybackOverlaySupportFragment.this.setBgAlpha((Integer)arg0.getAnimatedValue());
            }
        };
        this.mBgFadeInAnimator = PlaybackOverlaySupportFragment.loadAnimator((Context)this.getActivity(), R.animator.lb_playback_bg_fade_in);
        this.mBgFadeInAnimator.addUpdateListener(listener);
        this.mBgFadeInAnimator.addListener(this.mFadeListener);
        this.mBgFadeOutAnimator = PlaybackOverlaySupportFragment.loadAnimator((Context)this.getActivity(), R.animator.lb_playback_bg_fade_out);
        this.mBgFadeOutAnimator.addUpdateListener(listener);
        this.mBgFadeOutAnimator.addListener(this.mFadeListener);
    }

    private View getControlRowView() {
        if (this.getVerticalGridView() == null) {
            return null;
        }
        RecyclerView.ViewHolder vh = this.getVerticalGridView().findViewHolderForPosition(0);
        if (vh == null) {
            return null;
        }
        return vh.itemView;
    }

    private void loadControlRowAnimator() {
        AnimatorListener listener = new AnimatorListener(){

            @Override
            void getViews(ArrayList<View> views) {
                View view = PlaybackOverlaySupportFragment.this.getControlRowView();
                if (view != null) {
                    views.add(view);
                }
            }
        };
        ValueAnimator.AnimatorUpdateListener updateListener = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator arg0) {
                View view = PlaybackOverlaySupportFragment.this.getControlRowView();
                if (view != null) {
                    float fraction2 = ((Float)arg0.getAnimatedValue()).floatValue();
                    view.setAlpha(fraction2);
                    view.setTranslationY((float)PlaybackOverlaySupportFragment.this.mAnimationTranslateY * (1.0f - fraction2));
                }
            }
        };
        this.mControlRowFadeInAnimator = PlaybackOverlaySupportFragment.loadAnimator((Context)this.getActivity(), R.animator.lb_playback_controls_fade_in);
        this.mControlRowFadeInAnimator.addUpdateListener(updateListener);
        this.mControlRowFadeInAnimator.addListener((Animator.AnimatorListener)listener);
        this.mControlRowFadeInAnimator.setInterpolator(this.mLogDecelerateInterpolator);
        this.mControlRowFadeOutAnimator = PlaybackOverlaySupportFragment.loadAnimator((Context)this.getActivity(), R.animator.lb_playback_controls_fade_out);
        this.mControlRowFadeOutAnimator.addUpdateListener(updateListener);
        this.mControlRowFadeOutAnimator.addListener((Animator.AnimatorListener)listener);
        this.mControlRowFadeOutAnimator.setInterpolator(this.mLogAccelerateInterpolator);
    }

    private void loadOtherRowAnimator() {
        final AnimatorListener listener = new AnimatorListener(){

            @Override
            void getViews(ArrayList<View> views) {
                if (PlaybackOverlaySupportFragment.this.getVerticalGridView() == null) {
                    return;
                }
                int count = PlaybackOverlaySupportFragment.this.getVerticalGridView().getChildCount();
                for (int i = 0; i < count; ++i) {
                    View view = PlaybackOverlaySupportFragment.this.getVerticalGridView().getChildAt(i);
                    if (view == null) continue;
                    views.add(view);
                }
            }
        };
        ValueAnimator.AnimatorUpdateListener updateListener = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator arg0) {
                if (PlaybackOverlaySupportFragment.this.getVerticalGridView() == null) {
                    return;
                }
                float fraction2 = ((Float)arg0.getAnimatedValue()).floatValue();
                for (View view : listener.mViews) {
                    if (PlaybackOverlaySupportFragment.this.getVerticalGridView().getChildPosition(view) <= 0) continue;
                    view.setAlpha(fraction2);
                    view.setTranslationY((float)PlaybackOverlaySupportFragment.this.mAnimationTranslateY * (1.0f - fraction2));
                }
            }
        };
        this.mOtherRowFadeInAnimator = PlaybackOverlaySupportFragment.loadAnimator((Context)this.getActivity(), R.animator.lb_playback_controls_fade_in);
        this.mOtherRowFadeInAnimator.addListener((Animator.AnimatorListener)listener);
        this.mOtherRowFadeInAnimator.addUpdateListener(updateListener);
        this.mOtherRowFadeInAnimator.setInterpolator(this.mLogDecelerateInterpolator);
        this.mOtherRowFadeOutAnimator = PlaybackOverlaySupportFragment.loadAnimator((Context)this.getActivity(), R.animator.lb_playback_controls_fade_out);
        this.mOtherRowFadeOutAnimator.addListener((Animator.AnimatorListener)listener);
        this.mOtherRowFadeOutAnimator.addUpdateListener(updateListener);
        this.mOtherRowFadeOutAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
    }

    private void loadDescriptionAnimator() {
        ValueAnimator.AnimatorUpdateListener listener = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator arg0) {
                Presenter.ViewHolder vh;
                if (PlaybackOverlaySupportFragment.this.getVerticalGridView() == null) {
                    return;
                }
                ItemBridgeAdapter.ViewHolder adapterVh = (ItemBridgeAdapter.ViewHolder)PlaybackOverlaySupportFragment.this.getVerticalGridView().findViewHolderForPosition(0);
                if (adapterVh != null && adapterVh.getViewHolder() instanceof PlaybackControlsRowPresenter.ViewHolder && (vh = ((PlaybackControlsRowPresenter.ViewHolder)adapterVh.getViewHolder()).mDescriptionViewHolder) != null) {
                    vh.view.setAlpha(((Float)arg0.getAnimatedValue()).floatValue());
                }
            }
        };
        this.mDescriptionFadeInAnimator = PlaybackOverlaySupportFragment.loadAnimator((Context)this.getActivity(), R.animator.lb_playback_description_fade_in);
        this.mDescriptionFadeInAnimator.addUpdateListener(listener);
        this.mDescriptionFadeInAnimator.setInterpolator(this.mLogDecelerateInterpolator);
        this.mDescriptionFadeOutAnimator = PlaybackOverlaySupportFragment.loadAnimator((Context)this.getActivity(), R.animator.lb_playback_description_fade_out);
        this.mDescriptionFadeOutAnimator.addUpdateListener(listener);
    }

    private void fade(boolean fadeIn) {
        if (this.getView() == null) {
            return;
        }
        if (fadeIn && this.mFadingStatus == 1 || !fadeIn && this.mFadingStatus == 2) {
            return;
        }
        if (fadeIn && this.mBgAlpha == 255 || !fadeIn && this.mBgAlpha == 0) {
            return;
        }
        int n = this.mAnimationTranslateY = this.getVerticalGridView().getSelectedPosition() == 0 ? this.mMajorFadeTranslateY : this.mMinorFadeTranslateY;
        if (this.mFadingStatus == 0) {
            if (fadeIn) {
                this.mBgFadeInAnimator.start();
                this.mControlRowFadeInAnimator.start();
                this.mOtherRowFadeInAnimator.start();
                this.mDescriptionFadeInAnimator.start();
            } else {
                this.mBgFadeOutAnimator.start();
                this.mControlRowFadeOutAnimator.start();
                this.mOtherRowFadeOutAnimator.start();
                this.mDescriptionFadeOutAnimator.start();
            }
        } else if (fadeIn) {
            this.mBgFadeOutAnimator.reverse();
            this.mControlRowFadeOutAnimator.reverse();
            this.mOtherRowFadeOutAnimator.reverse();
            this.mDescriptionFadeOutAnimator.reverse();
        } else {
            this.mBgFadeInAnimator.reverse();
            this.mControlRowFadeInAnimator.reverse();
            this.mOtherRowFadeInAnimator.reverse();
            this.mDescriptionFadeInAnimator.reverse();
        }
        if (fadeIn && this.mFadingStatus == 0) {
            int count = this.getVerticalGridView().getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getVerticalGridView().getChildAt(i).setTranslationY((float)this.mAnimationTranslateY);
            }
        }
        this.mFadingStatus = fadeIn ? 1 : 2;
    }

    @Override
    public void setAdapter(ObjectAdapter adapter) {
        if (this.getAdapter() != null) {
            this.getAdapter().unregisterObserver(this.mObserver);
        }
        super.setAdapter(adapter);
        if (adapter != null) {
            adapter.registerObserver(this.mObserver);
        }
    }

    @Override
    void setVerticalGridViewLayout(VerticalGridView listview) {
        if (listview == null) {
            return;
        }
        PlaybackOverlaySupportFragment.setBottomPadding((View)listview, this.mPaddingBottom);
        listview.setItemAlignmentOffset(this.mAlignPosition);
        listview.setItemAlignmentOffsetPercent(100.0f);
        listview.setWindowAlignmentOffset(0);
        listview.setWindowAlignmentOffsetPercent(100.0f);
        listview.setWindowAlignment(2);
    }

    private static void setBottomPadding(View view, int padding) {
        view.setPadding(view.getPaddingLeft(), view.getPaddingTop(), view.getPaddingRight(), padding);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mAlignPosition = this.getResources().getDimensionPixelSize(R.dimen.lb_playback_controls_align_bottom);
        this.mPaddingBottom = this.getResources().getDimensionPixelSize(R.dimen.lb_playback_controls_padding_bottom);
        this.mBgDarkColor = this.getResources().getColor(R.color.lb_playback_controls_background_dark);
        this.mBgLightColor = this.getResources().getColor(R.color.lb_playback_controls_background_light);
        this.mShowTimeMs = this.getResources().getInteger(R.integer.lb_playback_controls_show_time_ms);
        this.mMajorFadeTranslateY = this.getResources().getDimensionPixelSize(R.dimen.lb_playback_major_fade_translate_y);
        this.mMinorFadeTranslateY = this.getResources().getDimensionPixelSize(R.dimen.lb_playback_minor_fade_translate_y);
        this.loadBgAnimator();
        this.loadControlRowAnimator();
        this.loadOtherRowAnimator();
        this.loadDescriptionAnimator();
    }

    public void setBackgroundType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                if (type == this.mBackgroundType) break;
                this.mBackgroundType = type;
                this.updateBackground();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid background type");
            }
        }
    }

    public int getBackgroundType() {
        return this.mBackgroundType;
    }

    private void updateBackground() {
        if (this.mRootView != null) {
            int color2 = this.mBgDarkColor;
            switch (this.mBackgroundType) {
                case 1: {
                    break;
                }
                case 2: {
                    color2 = this.mBgLightColor;
                    break;
                }
                case 0: {
                    color2 = 0;
                }
            }
            this.mRootView.setBackground((Drawable)new ColorDrawable(color2));
        }
    }

    private void updateControlsBottomSpace(ItemBridgeAdapter.ViewHolder vh) {
        if (vh == null && this.getVerticalGridView() != null) {
            vh = (ItemBridgeAdapter.ViewHolder)this.getVerticalGridView().findViewHolderForPosition(0);
        }
        if (vh != null && vh.getPresenter() instanceof PlaybackControlsRowPresenter) {
            int adapterSize = this.getAdapter() == null ? 0 : this.getAdapter().size();
            ((PlaybackControlsRowPresenter)vh.getPresenter()).showBottomSpace((PlaybackControlsRowPresenter.ViewHolder)vh.getViewHolder(), adapterSize > 1);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = super.onCreateView(inflater, container, savedInstanceState);
        this.mBgAlpha = 255;
        this.updateBackground();
        this.getRowsSupportFragment().setExternalAdapterListener(this.mAdapterListener);
        return this.mRootView;
    }

    @Override
    public void onDestroyView() {
        this.mRootView = null;
        super.onDestroyView();
    }

    static abstract class AnimatorListener
    implements Animator.AnimatorListener {
        ArrayList<View> mViews = new ArrayList();
        ArrayList<Integer> mLayerType = new ArrayList();

        AnimatorListener() {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }

        public void onAnimationStart(Animator animation) {
            this.getViews(this.mViews);
            for (View view : this.mViews) {
                this.mLayerType.add(view.getLayerType());
                view.setLayerType(2, null);
            }
        }

        public void onAnimationEnd(Animator animation) {
            for (int i = 0; i < this.mViews.size(); ++i) {
                this.mViews.get(i).setLayerType(this.mLayerType.get(i).intValue(), null);
            }
            this.mLayerType.clear();
            this.mViews.clear();
        }

        abstract void getViews(ArrayList<View> var1);
    }

    public static interface InputEventHandler {
        public boolean handleInputEvent(InputEvent var1);
    }

    public static class OnFadeCompleteListener {
        public void onFadeInComplete() {
        }

        public void onFadeOutComplete() {
        }
    }
}

