/*
 * Decompiled with CFR 0.152.
 */
package android.support.v17.leanback.app;

import android.animation.TimeAnimator;
import android.os.Bundle;
import android.support.v17.leanback.R;
import android.support.v17.leanback.app.BaseRowSupportFragment;
import android.support.v17.leanback.widget.HorizontalGridView;
import android.support.v17.leanback.widget.ItemBridgeAdapter;
import android.support.v17.leanback.widget.ListRowPresenter;
import android.support.v17.leanback.widget.OnItemViewClickedListener;
import android.support.v17.leanback.widget.OnItemViewSelectedListener;
import android.support.v17.leanback.widget.Presenter;
import android.support.v17.leanback.widget.RowPresenter;
import android.support.v17.leanback.widget.ScaleFrameLayout;
import android.support.v17.leanback.widget.VerticalGridView;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import java.util.ArrayList;

public class RowsSupportFragment
extends BaseRowSupportFragment {
    private static final String TAG = "RowsSupportFragment";
    private static final boolean DEBUG = false;
    private ItemBridgeAdapter.ViewHolder mSelectedViewHolder;
    private int mSubPosition;
    private boolean mExpand = true;
    private boolean mViewsCreated;
    private float mRowScaleFactor;
    private int mAlignedTop;
    private boolean mRowScaleEnabled;
    private ScaleFrameLayout mScaleFrameLayout;
    private boolean mAfterEntranceTransition = true;
    private OnItemViewSelectedListener mOnItemViewSelectedListener;
    private OnItemViewClickedListener mOnItemViewClickedListener;
    int mSelectAnimatorDuration;
    Interpolator mSelectAnimatorInterpolator = new DecelerateInterpolator(2.0f);
    private RecyclerView.RecycledViewPool mRecycledViewPool;
    private ArrayList<Presenter> mPresenterMapper;
    private ItemBridgeAdapter.AdapterListener mExternalAdapterListener;
    private final ItemBridgeAdapter.AdapterListener mBridgeAdapterListener = new ItemBridgeAdapter.AdapterListener(){

        @Override
        public void onAddPresenter(Presenter presenter, int type) {
            if (RowsSupportFragment.this.mExternalAdapterListener != null) {
                RowsSupportFragment.this.mExternalAdapterListener.onAddPresenter(presenter, type);
            }
        }

        @Override
        public void onCreate(ItemBridgeAdapter.ViewHolder vh) {
            VerticalGridView listView = RowsSupportFragment.this.getVerticalGridView();
            if (listView != null) {
                listView.setClipChildren(false);
            }
            RowsSupportFragment.this.setupSharedViewPool(vh);
            RowsSupportFragment.this.mViewsCreated = true;
            vh.setExtraObject(new RowViewHolderExtra(vh));
            RowsSupportFragment.setRowViewSelected(vh, false, true);
            if (RowsSupportFragment.this.mExternalAdapterListener != null) {
                RowsSupportFragment.this.mExternalAdapterListener.onCreate(vh);
            }
        }

        @Override
        public void onAttachedToWindow(ItemBridgeAdapter.ViewHolder vh) {
            RowsSupportFragment.setRowViewExpanded(vh, RowsSupportFragment.this.mExpand);
            RowPresenter rowPresenter = (RowPresenter)vh.getPresenter();
            RowPresenter.ViewHolder rowVh = rowPresenter.getRowViewHolder(vh.getViewHolder());
            rowVh.setOnItemViewSelectedListener(RowsSupportFragment.this.mOnItemViewSelectedListener);
            rowVh.setOnItemViewClickedListener(RowsSupportFragment.this.mOnItemViewClickedListener);
            rowPresenter.setEntranceTransitionState(rowVh, RowsSupportFragment.this.mAfterEntranceTransition);
            if (RowsSupportFragment.this.mExternalAdapterListener != null) {
                RowsSupportFragment.this.mExternalAdapterListener.onAttachedToWindow(vh);
            }
        }

        @Override
        public void onDetachedFromWindow(ItemBridgeAdapter.ViewHolder vh) {
            if (RowsSupportFragment.this.mSelectedViewHolder == vh) {
                RowsSupportFragment.setRowViewSelected(RowsSupportFragment.this.mSelectedViewHolder, false, true);
                RowsSupportFragment.this.mSelectedViewHolder = null;
            }
            if (RowsSupportFragment.this.mExternalAdapterListener != null) {
                RowsSupportFragment.this.mExternalAdapterListener.onDetachedFromWindow(vh);
            }
        }

        @Override
        public void onBind(ItemBridgeAdapter.ViewHolder vh) {
            if (RowsSupportFragment.this.mExternalAdapterListener != null) {
                RowsSupportFragment.this.mExternalAdapterListener.onBind(vh);
            }
        }

        @Override
        public void onUnbind(ItemBridgeAdapter.ViewHolder vh) {
            RowsSupportFragment.setRowViewSelected(vh, false, true);
            if (RowsSupportFragment.this.mExternalAdapterListener != null) {
                RowsSupportFragment.this.mExternalAdapterListener.onUnbind(vh);
            }
        }
    };

    @Override
    protected VerticalGridView findGridViewFromRoot(View view) {
        return (VerticalGridView)view.findViewById(R.id.container_list);
    }

    public void setOnItemViewClickedListener(OnItemViewClickedListener listener) {
        this.mOnItemViewClickedListener = listener;
        if (this.mViewsCreated) {
            throw new IllegalStateException("Item clicked listener must be set before views are created");
        }
    }

    public OnItemViewClickedListener getOnItemViewClickedListener() {
        return this.mOnItemViewClickedListener;
    }

    public void setExpand(boolean expand) {
        this.mExpand = expand;
        VerticalGridView listView = this.getVerticalGridView();
        if (listView != null) {
            this.updateRowScaling();
            int count = listView.getChildCount();
            for (int i = 0; i < count; ++i) {
                View view = listView.getChildAt(i);
                ItemBridgeAdapter.ViewHolder vh = (ItemBridgeAdapter.ViewHolder)listView.getChildViewHolder(view);
                RowsSupportFragment.setRowViewExpanded(vh, this.mExpand);
            }
        }
    }

    public void setOnItemViewSelectedListener(OnItemViewSelectedListener listener) {
        this.mOnItemViewSelectedListener = listener;
        VerticalGridView listView = this.getVerticalGridView();
        if (listView != null) {
            int count = listView.getChildCount();
            for (int i = 0; i < count; ++i) {
                View view = listView.getChildAt(i);
                ItemBridgeAdapter.ViewHolder ibvh = (ItemBridgeAdapter.ViewHolder)listView.getChildViewHolder(view);
                RowPresenter rowPresenter = (RowPresenter)ibvh.getPresenter();
                RowPresenter.ViewHolder vh = rowPresenter.getRowViewHolder(ibvh.getViewHolder());
                vh.setOnItemViewSelectedListener(this.mOnItemViewSelectedListener);
            }
        }
    }

    public OnItemViewSelectedListener getOnItemViewSelectedListener() {
        return this.mOnItemViewSelectedListener;
    }

    public void enableRowScaling(boolean enable) {
        this.mRowScaleEnabled = enable;
    }

    @Override
    void onRowSelected(RecyclerView parent, RecyclerView.ViewHolder viewHolder, int position, int subposition) {
        if (this.mSelectedViewHolder != viewHolder || this.mSubPosition != subposition) {
            this.mSubPosition = subposition;
            if (this.mSelectedViewHolder != null) {
                RowsSupportFragment.setRowViewSelected(this.mSelectedViewHolder, false, false);
            }
            this.mSelectedViewHolder = (ItemBridgeAdapter.ViewHolder)viewHolder;
            if (this.mSelectedViewHolder != null) {
                RowsSupportFragment.setRowViewSelected(this.mSelectedViewHolder, true, false);
            }
        }
    }

    @Override
    int getLayoutResourceId() {
        return R.layout.lb_rows_fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mSelectAnimatorDuration = this.getResources().getInteger(R.integer.lb_browse_rows_anim_duration);
        this.mRowScaleFactor = this.getResources().getFraction(R.fraction.lb_browse_rows_scale, 1, 1);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = super.onCreateView(inflater, container, savedInstanceState);
        this.mScaleFrameLayout = (ScaleFrameLayout)view.findViewById(R.id.scale_frame);
        return view;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getVerticalGridView().setItemAlignmentViewId(R.id.row_content);
        this.getVerticalGridView().setSaveChildrenPolicy(2);
        this.mRecycledViewPool = null;
        this.mPresenterMapper = null;
    }

    @Override
    public void onDestroyView() {
        this.mViewsCreated = false;
        super.onDestroyView();
    }

    @Override
    void setItemAlignment() {
        super.setItemAlignment();
        if (this.getVerticalGridView() != null) {
            this.getVerticalGridView().setItemAlignmentOffsetWithPadding(true);
        }
    }

    void setExternalAdapterListener(ItemBridgeAdapter.AdapterListener listener) {
        this.mExternalAdapterListener = listener;
    }

    View getScaleView() {
        return this.getVerticalGridView();
    }

    void setScalePivots(float pivotX, float pivotY) {
        this.mScaleFrameLayout.setPivotX(pivotX);
        this.mScaleFrameLayout.setPivotY(pivotY);
    }

    private static void setRowViewExpanded(ItemBridgeAdapter.ViewHolder vh, boolean expanded) {
        ((RowPresenter)vh.getPresenter()).setRowViewExpanded(vh.getViewHolder(), expanded);
    }

    private static void setRowViewSelected(ItemBridgeAdapter.ViewHolder vh, boolean selected, boolean immediate) {
        RowViewHolderExtra extra = (RowViewHolderExtra)vh.getExtraObject();
        extra.animateSelect(selected, immediate);
        ((RowPresenter)vh.getPresenter()).setRowViewSelected(vh.getViewHolder(), selected);
    }

    private void setupSharedViewPool(ItemBridgeAdapter.ViewHolder bridgeVh) {
        RowPresenter rowPresenter = (RowPresenter)bridgeVh.getPresenter();
        RowPresenter.ViewHolder rowVh = rowPresenter.getRowViewHolder(bridgeVh.getViewHolder());
        if (rowVh instanceof ListRowPresenter.ViewHolder) {
            HorizontalGridView view = ((ListRowPresenter.ViewHolder)rowVh).getGridView();
            if (this.mRecycledViewPool == null) {
                this.mRecycledViewPool = view.getRecycledViewPool();
            } else {
                view.setRecycledViewPool(this.mRecycledViewPool);
            }
            ItemBridgeAdapter bridgeAdapter = ((ListRowPresenter.ViewHolder)rowVh).getBridgeAdapter();
            if (this.mPresenterMapper == null) {
                this.mPresenterMapper = bridgeAdapter.getPresenterMapper();
            } else {
                bridgeAdapter.setPresenterMapper(this.mPresenterMapper);
            }
        }
    }

    @Override
    void updateAdapter() {
        super.updateAdapter();
        this.mSelectedViewHolder = null;
        this.mViewsCreated = false;
        ItemBridgeAdapter adapter = this.getBridgeAdapter();
        if (adapter != null) {
            adapter.setAdapterListener(this.mBridgeAdapterListener);
        }
    }

    @Override
    boolean onTransitionPrepare() {
        boolean prepared = super.onTransitionPrepare();
        if (prepared) {
            this.freezeRows(true);
        }
        return prepared;
    }

    void onExpandTransitionStart(boolean expand, Runnable callback) {
        this.onTransitionPrepare();
        this.onTransitionStart();
        if (expand) {
            callback.run();
            return;
        }
        new ExpandPreLayout(callback).execute();
    }

    private boolean needsScale() {
        return this.mRowScaleEnabled && !this.mExpand;
    }

    private void updateRowScaling() {
        float scaleFactor = this.needsScale() ? this.mRowScaleFactor : 1.0f;
        this.mScaleFrameLayout.setLayoutScaleY(scaleFactor);
        this.getScaleView().setScaleY(scaleFactor);
        this.getScaleView().setScaleX(scaleFactor);
        this.updateWindowAlignOffset();
    }

    private void updateWindowAlignOffset() {
        int alignOffset = this.mAlignedTop;
        if (this.needsScale()) {
            alignOffset = (int)((float)alignOffset / this.mRowScaleFactor + 0.5f);
        }
        this.getVerticalGridView().setWindowAlignmentOffset(alignOffset);
    }

    @Override
    void setWindowAlignmentFromTop(int alignedTop) {
        this.mAlignedTop = alignedTop;
        VerticalGridView gridView = this.getVerticalGridView();
        if (gridView != null) {
            this.updateWindowAlignOffset();
            gridView.setWindowAlignmentOffsetPercent(-1.0f);
            gridView.setWindowAlignment(0);
        }
    }

    @Override
    void onTransitionEnd() {
        super.onTransitionEnd();
        this.freezeRows(false);
    }

    private void freezeRows(boolean freeze) {
        VerticalGridView verticalView = this.getVerticalGridView();
        if (verticalView != null) {
            int count = verticalView.getChildCount();
            for (int i = 0; i < count; ++i) {
                ItemBridgeAdapter.ViewHolder ibvh = (ItemBridgeAdapter.ViewHolder)verticalView.getChildViewHolder(verticalView.getChildAt(i));
                RowPresenter rowPresenter = (RowPresenter)ibvh.getPresenter();
                RowPresenter.ViewHolder vh = rowPresenter.getRowViewHolder(ibvh.getViewHolder());
                rowPresenter.freeze(vh, freeze);
            }
        }
    }

    void setEntranceTransitionState(boolean afterTransition) {
        this.mAfterEntranceTransition = afterTransition;
        VerticalGridView verticalView = this.getVerticalGridView();
        if (verticalView != null) {
            int count = verticalView.getChildCount();
            for (int i = 0; i < count; ++i) {
                ItemBridgeAdapter.ViewHolder ibvh = (ItemBridgeAdapter.ViewHolder)verticalView.getChildViewHolder(verticalView.getChildAt(i));
                RowPresenter rowPresenter = (RowPresenter)ibvh.getPresenter();
                RowPresenter.ViewHolder vh = rowPresenter.getRowViewHolder(ibvh.getViewHolder());
                rowPresenter.setEntranceTransitionState(vh, this.mAfterEntranceTransition);
            }
        }
    }

    class ExpandPreLayout
    implements ViewTreeObserver.OnPreDrawListener {
        final View mVerticalView;
        final Runnable mCallback;
        int mState;
        static final int STATE_INIT = 0;
        static final int STATE_FIRST_DRAW = 1;
        static final int STATE_SECOND_DRAW = 2;

        ExpandPreLayout(Runnable callback) {
            this.mVerticalView = RowsSupportFragment.this.getVerticalGridView();
            this.mCallback = callback;
        }

        void execute() {
            this.mVerticalView.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
            RowsSupportFragment.this.setExpand(false);
            this.mState = 0;
        }

        public boolean onPreDraw() {
            if (this.mState == 0) {
                RowsSupportFragment.this.setExpand(true);
                this.mState = 1;
            } else if (this.mState == 1) {
                this.mCallback.run();
                this.mVerticalView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                this.mState = 2;
            }
            return false;
        }
    }

    final class RowViewHolderExtra
    implements TimeAnimator.TimeListener {
        final RowPresenter mRowPresenter;
        final Presenter.ViewHolder mRowViewHolder;
        final TimeAnimator mSelectAnimator = new TimeAnimator();
        int mSelectAnimatorDurationInUse;
        Interpolator mSelectAnimatorInterpolatorInUse;
        float mSelectLevelAnimStart;
        float mSelectLevelAnimDelta;

        RowViewHolderExtra(ItemBridgeAdapter.ViewHolder ibvh) {
            this.mRowPresenter = (RowPresenter)ibvh.getPresenter();
            this.mRowViewHolder = ibvh.getViewHolder();
            this.mSelectAnimator.setTimeListener((TimeAnimator.TimeListener)this);
        }

        public void onTimeUpdate(TimeAnimator animation, long totalTime, long deltaTime) {
            if (this.mSelectAnimator.isRunning()) {
                this.updateSelect(totalTime, deltaTime);
            }
        }

        void updateSelect(long totalTime, long deltaTime) {
            float fraction2;
            if (totalTime >= (long)this.mSelectAnimatorDurationInUse) {
                fraction2 = 1.0f;
                this.mSelectAnimator.end();
            } else {
                fraction2 = (float)((double)totalTime / (double)this.mSelectAnimatorDurationInUse);
            }
            if (this.mSelectAnimatorInterpolatorInUse != null) {
                fraction2 = this.mSelectAnimatorInterpolatorInUse.getInterpolation(fraction2);
            }
            float level = this.mSelectLevelAnimStart + fraction2 * this.mSelectLevelAnimDelta;
            this.mRowPresenter.setSelectLevel(this.mRowViewHolder, level);
        }

        void animateSelect(boolean select, boolean immediate) {
            float end;
            this.mSelectAnimator.end();
            float f = end = select ? 1.0f : 0.0f;
            if (immediate) {
                this.mRowPresenter.setSelectLevel(this.mRowViewHolder, end);
            } else if (this.mRowPresenter.getSelectLevel(this.mRowViewHolder) != end) {
                this.mSelectAnimatorDurationInUse = RowsSupportFragment.this.mSelectAnimatorDuration;
                this.mSelectAnimatorInterpolatorInUse = RowsSupportFragment.this.mSelectAnimatorInterpolator;
                this.mSelectLevelAnimStart = this.mRowPresenter.getSelectLevel(this.mRowViewHolder);
                this.mSelectLevelAnimDelta = end - this.mSelectLevelAnimStart;
                this.mSelectAnimator.start();
            }
        }
    }
}

